/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.SourceSinkFactory;
import com.google.common.io.SourceSinkTester;
import com.google.common.io.TestCharSink;
import com.google.common.io.TestOption;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CharSourceTester
extends SourceSinkTester<CharSource, String, SourceSinkFactory.CharSourceFactory> {
    private static final ImmutableList<Method> testMethods = CharSourceTester.getTestMethods(CharSourceTester.class);
    private final ImmutableList<String> expectedLines;
    private CharSource source;

    static TestSuite tests(String name, SourceSinkFactory.CharSourceFactory factory) {
        TestSuite suite = new TestSuite(name);
        for (Map.Entry entry : TEST_STRINGS.entrySet()) {
            suite.addTest((Test)CharSourceTester.suiteForString(factory, (String)entry.getValue(), name, (String)entry.getKey()));
        }
        return suite;
    }

    static TestSuite suiteForString(SourceSinkFactory.CharSourceFactory factory, String string, String name, String desc) {
        String string2 = String.valueOf(String.valueOf(name));
        String string3 = String.valueOf(String.valueOf(desc));
        TestSuite suite = new TestSuite(new StringBuilder(3 + string2.length() + string3.length()).append(string2).append(" [").append(string3).append("]").toString());
        for (Method method : testMethods) {
            suite.addTest((Test)new CharSourceTester(factory, string, name, desc, method));
        }
        return suite;
    }

    public CharSourceTester(SourceSinkFactory.CharSourceFactory factory, String string, String suiteName, String caseDesc, Method method) {
        super(factory, string, suiteName, caseDesc, method);
        this.expectedLines = CharSourceTester.getLines((String)this.expected);
    }

    protected void setUp() throws Exception {
        this.source = (CharSource)((SourceSinkFactory.CharSourceFactory)this.factory).createSource(this.data);
    }

    public void testOpenStream() throws IOException {
        int read;
        Reader reader = this.source.openStream();
        StringWriter writer = new StringWriter();
        char[] buf = new char[64];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        reader.close();
        writer.close();
        this.assertExpectedString(writer.toString());
    }

    public void testOpenBufferedStream() throws IOException {
        int read;
        BufferedReader reader = this.source.openBufferedStream();
        StringWriter writer = new StringWriter();
        char[] buf = new char[64];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        reader.close();
        writer.close();
        this.assertExpectedString(writer.toString());
    }

    public void testCopyTo_appendable() throws IOException {
        StringBuilder builder = new StringBuilder();
        CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)this.source.copyTo((Appendable)builder));
        this.assertExpectedString(builder.toString());
    }

    public void testCopyTo_charSink() throws IOException {
        TestCharSink sink = new TestCharSink(new TestOption[0]);
        CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)this.source.copyTo((CharSink)sink));
        this.assertExpectedString(sink.getString());
    }

    public void testRead_toString() throws IOException {
        String string = this.source.read();
        this.assertExpectedString(string);
    }

    public void testReadFirstLine() throws IOException {
        if (this.expectedLines.isEmpty()) {
            CharSourceTester.assertNull((Object)this.source.readFirstLine());
        } else {
            CharSourceTester.assertEquals((String)((String)this.expectedLines.get(0)), (String)this.source.readFirstLine());
        }
    }

    public void testReadLines_toList() throws IOException {
        this.assertExpectedLines((List<String>)this.source.readLines());
    }

    public void testIsEmpty() throws IOException {
        CharSourceTester.assertEquals((boolean)((String)this.expected).isEmpty(), (boolean)this.source.isEmpty());
    }

    public void testReadLines_withProcessor() throws IOException {
        List list = (List)this.source.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return true;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        this.assertExpectedLines(list);
    }

    public void testReadLines_withProcessor_stopsOnFalse() throws IOException {
        List list = (List)this.source.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return false;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        if (this.expectedLines.isEmpty()) {
            CharSourceTester.assertTrue((boolean)list.isEmpty());
        } else {
            CharSourceTester.assertEquals((Object)this.expectedLines.subList(0, 1), (Object)list);
        }
    }

    private void assertExpectedString(String string) {
        CharSourceTester.assertEquals((String)((String)this.expected), (String)string);
    }

    private void assertExpectedLines(List<String> list) {
        CharSourceTester.assertEquals(this.expectedLines, list);
    }
}

