/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.common.io.IoTestCase;
import com.google.common.io.LineProcessor;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import junit.framework.Assert;

public class CharStreamsTest
extends IoTestCase {
    private static final String TEXT = "The quick brown fox jumped over the lazy dog.";

    public void testToString() throws IOException {
        CharStreamsTest.assertEquals((String)TEXT, (String)CharStreams.toString((Readable)new StringReader(TEXT)));
    }

    public void testSkipFully_blockingRead() throws IOException {
        NonSkippingReader reader = new NonSkippingReader("abcdef");
        CharStreams.skipFully((Reader)reader, (long)6L);
        CharStreamsTest.assertEquals((int)-1, (int)((Reader)reader).read());
    }

    public void testReadLines() throws IOException {
        List lines = CharStreams.readLines((Readable)new StringReader("a\nb\nc"));
        CharStreamsTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)lines);
    }

    public void testReadLines_withLineProcessor() throws IOException {
        String text = "a\nb\nc";
        StringReader r = new StringReader(text);
        LineProcessor<Integer> alwaysFalse = new LineProcessor<Integer>(){
            int seen;

            public boolean processLine(String line) {
                ++this.seen;
                return false;
            }

            public Integer getResult() {
                return this.seen;
            }
        };
        CharStreamsTest.assertEquals((String)"processLine was called more than once", (int)1, (int)((Integer)CharStreams.readLines((Readable)r, (LineProcessor)alwaysFalse)));
        r = new StringReader(text);
        LineProcessor<Integer> alwaysTrue = new LineProcessor<Integer>(){
            int seen;

            public boolean processLine(String line) {
                ++this.seen;
                return true;
            }

            public Integer getResult() {
                return this.seen;
            }
        };
        CharStreamsTest.assertEquals((String)"processLine was not called for all the lines", (int)3, (int)((Integer)CharStreams.readLines((Readable)r, (LineProcessor)alwaysTrue)));
        r = new StringReader(text);
        final StringBuilder sb = new StringBuilder();
        LineProcessor<Integer> conditional = new LineProcessor<Integer>(){
            int seen;

            public boolean processLine(String line) {
                ++this.seen;
                sb.append(line);
                return this.seen < 2;
            }

            public Integer getResult() {
                return this.seen;
            }
        };
        CharStreamsTest.assertEquals((int)2, (int)((Integer)CharStreams.readLines((Readable)r, (LineProcessor)conditional)));
        CharStreamsTest.assertEquals((String)"ab", (String)sb.toString());
    }

    public void testSkipFully_EOF() throws IOException {
        StringReader reader = new StringReader("abcde");
        try {
            CharStreams.skipFully((Reader)reader, (long)6L);
            CharStreamsTest.fail((String)"expected EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testSkipFully() throws IOException {
        String testString = "abcdef";
        StringReader reader = new StringReader(testString);
        CharStreamsTest.assertEquals((int)testString.charAt(0), (int)((Reader)reader).read());
        CharStreams.skipFully((Reader)reader, (long)1L);
        CharStreamsTest.assertEquals((int)testString.charAt(2), (int)((Reader)reader).read());
        CharStreams.skipFully((Reader)reader, (long)2L);
        CharStreamsTest.assertEquals((int)testString.charAt(5), (int)((Reader)reader).read());
        CharStreamsTest.assertEquals((int)-1, (int)((Reader)reader).read());
    }

    public void testAsWriter() {
        StringBuilder plainAppendable = new StringBuilder();
        Writer result = CharStreams.asWriter((Appendable)plainAppendable);
        CharStreamsTest.assertNotSame((Object)plainAppendable, (Object)result);
        CharStreamsTest.assertNotNull((Object)result);
        StringWriter secretlyAWriter = new StringWriter();
        result = CharStreams.asWriter((Appendable)secretlyAWriter);
        CharStreamsTest.assertSame((Object)secretlyAWriter, (Object)result);
    }

    public void testCopy() throws IOException {
        StringBuilder builder = new StringBuilder();
        long copied = CharStreams.copy((Readable)new StringReader(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"), (Appendable)builder);
        CharStreamsTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)builder.toString());
        CharStreamsTest.assertEquals((long)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".length(), (long)copied);
        StringBuilder builder2 = new StringBuilder();
        copied = CharStreams.copy((Readable)new StringReader("\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1"), (Appendable)builder2);
        CharStreamsTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)builder2.toString());
        CharStreamsTest.assertEquals((long)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1".length(), (long)copied);
    }

    public void testCopyWithReaderThatDoesNotFillBuffer() throws IOException {
        String string = Strings.repeat((String)"0123456789", (int)100);
        StringBuilder b = new StringBuilder();
        long copied = CharStreams.copy((Readable)CharStreamsTest.newNonBufferFillingReader(new StringReader(string)), (Appendable)b);
        CharStreamsTest.assertEquals((String)string, (String)b.toString());
        CharStreamsTest.assertEquals((long)string.length(), (long)copied);
    }

    public void testNullWriter() throws Exception {
        Writer nullWriter = CharStreams.nullWriter();
        nullWriter.write(110);
        String test = "Test string for NullWriter";
        nullWriter.write(test);
        nullWriter.write(test, 2, 10);
        CharStreamsTest.assertSame((Object)CharStreams.nullWriter(), (Object)CharStreams.nullWriter());
    }

    private static Reader newNonBufferFillingReader(Reader reader) {
        return new FilterReader(reader){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                if (len <= 0) {
                    int n = len;
                    Assert.fail((String)new StringBuilder(37).append("read called with a len of ").append(n).toString());
                }
                return this.in.read(cbuf, off, Math.max(len - 1024, 0));
            }
        };
    }

    private static class NonSkippingReader
    extends StringReader {
        NonSkippingReader(String s) {
            super(s);
        }

        @Override
        public long skip(long n) {
            return 0L;
        }
    }
}

