/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.IoTestCase;
import com.google.common.io.LineBuffer;
import com.google.common.io.LineReader;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LineBufferTest
extends IoTestCase {
    private static final int[] CHUNK_SIZES = new int[]{1, 2, 3, Integer.MAX_VALUE};

    public void testProcess() throws IOException {
        LineBufferTest.bufferHelper("", new String[0]);
        LineBufferTest.bufferHelper("\n", "\n");
        LineBufferTest.bufferHelper("\r\n", "\r\n");
        LineBufferTest.bufferHelper("\n\r", "\n", "\r");
        LineBufferTest.bufferHelper("\r", "\r");
        LineBufferTest.bufferHelper("\n\n", "\n", "\n");
        LineBufferTest.bufferHelper("\r\n\r\n", "\r\n", "\r\n");
        LineBufferTest.bufferHelper("\r\r", "\r", "\r");
        LineBufferTest.bufferHelper("\ra\r\n\n\r\r", "\r", "a\r\n", "\n", "\r", "\r");
        LineBufferTest.bufferHelper("no newlines at all", "no newlines at all");
        LineBufferTest.bufferHelper("two lines\nbut no newline at end", "two lines\n", "but no newline at end");
        LineBufferTest.bufferHelper("\nempty first line\nno newline at end", "\n", "empty first line\n", "no newline at end");
        LineBufferTest.bufferHelper("three\rlines\rno newline at end", "three\r", "lines\r", "no newline at end");
        LineBufferTest.bufferHelper("mixed\nline\rendings\r\n", "mixed\n", "line\r", "endings\r\n");
    }

    private static void bufferHelper(String input, String ... expect) throws IOException {
        List<String> expectProcess = Arrays.asList(expect);
        List expectRead = Lists.transform(expectProcess, (Function)new Function<String, String>(){

            public String apply(String value) {
                return value.replaceAll("[\\r\\n]", "");
            }
        });
        for (int chunk : CHUNK_SIZES) {
            chunk = Math.max(1, Math.min(chunk, input.length()));
            LineBufferTest.assertEquals(expectProcess, LineBufferTest.bufferHelper(input, chunk));
            LineBufferTest.assertEquals((Object)expectRead, LineBufferTest.readUsingJava(input, chunk));
            LineBufferTest.assertEquals((Object)expectRead, LineBufferTest.readUsingReader(input, chunk, true));
            LineBufferTest.assertEquals((Object)expectRead, LineBufferTest.readUsingReader(input, chunk, false));
        }
    }

    private static List<String> bufferHelper(String input, int chunk) throws IOException {
        int len;
        final ArrayList lines = Lists.newArrayList();
        LineBuffer lineBuf = new LineBuffer(){

            protected void handleLine(String line, String end) {
                String string = String.valueOf(line);
                String string2 = String.valueOf(end);
                lines.add(string2.length() != 0 ? string.concat(string2) : new String(string));
            }
        };
        char[] chars = input.toCharArray();
        for (int off = 0; off < chars.length; off += len) {
            len = Math.min(chars.length, off + chunk) - off;
            lineBuf.add(chars, off, len);
        }
        lineBuf.finish();
        return lines;
    }

    private static List<String> readUsingJava(String input, int chunk) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(LineBufferTest.getChunkedReader(input, chunk));
        ArrayList lines = Lists.newArrayList();
        while ((line = r.readLine()) != null) {
            lines.add(line);
        }
        r.close();
        return lines;
    }

    private static List<String> readUsingReader(String input, int chunk, boolean asReader) throws IOException {
        String line;
        Readable readable = asReader ? LineBufferTest.getChunkedReader(input, chunk) : LineBufferTest.getChunkedReadable(input, chunk);
        LineReader r = new LineReader(readable);
        ArrayList lines = Lists.newArrayList();
        while ((line = r.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private static Readable getChunkedReadable(String input, int chunk) {
        final Reader reader = LineBufferTest.getChunkedReader(input, chunk);
        return new Readable(){

            @Override
            public int read(CharBuffer cbuf) throws IOException {
                return reader.read(cbuf);
            }
        };
    }

    private static Reader getChunkedReader(String input, final int chunk) {
        return new FilterReader(new StringReader(input)){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return super.read(cbuf, off, Math.min(chunk, len));
            }
        };
    }
}

