/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;

public class MultiReaderTest
extends TestCase {
    public void testOnlyOneOpen() throws Exception {
        String testString = "abcdefgh";
        final CharSource source = MultiReaderTest.newCharSource(testString);
        final int[] counter = new int[1];
        CharSource reader = new CharSource(){

            public Reader openStream() throws IOException {
                int n = counter[0];
                counter[0] = n + 1;
                if (n != 0) {
                    throw new IllegalStateException("More than one source open");
                }
                return new FilterReader(source.openStream()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        counter[0] = counter[0] - 1;
                    }
                };
            }
        };
        Reader joinedReader = CharSource.concat((CharSource[])new CharSource[]{reader, reader, reader}).openStream();
        String result = CharStreams.toString((Readable)joinedReader);
        MultiReaderTest.assertEquals((int)(testString.length() * 3), (int)result.length());
    }

    public void testReady() throws Exception {
        CharSource source = MultiReaderTest.newCharSource("a");
        ImmutableList list = ImmutableList.of((Object)source, (Object)source);
        Reader joinedReader = CharSource.concat((Iterable)list).openStream();
        MultiReaderTest.assertTrue((boolean)joinedReader.ready());
        MultiReaderTest.assertEquals((int)97, (int)joinedReader.read());
        MultiReaderTest.assertEquals((int)97, (int)joinedReader.read());
        MultiReaderTest.assertEquals((int)-1, (int)joinedReader.read());
        MultiReaderTest.assertFalse((boolean)joinedReader.ready());
    }

    public void testSimple() throws Exception {
        String testString = "abcdefgh";
        CharSource source = MultiReaderTest.newCharSource(testString);
        Reader joinedReader = CharSource.concat((CharSource[])new CharSource[]{source, source}).openStream();
        String string = String.valueOf(testString);
        String string2 = String.valueOf(testString);
        String expectedString = string2.length() != 0 ? string.concat(string2) : new String(string);
        MultiReaderTest.assertEquals((String)expectedString, (String)CharStreams.toString((Readable)joinedReader));
    }

    private static CharSource newCharSource(final String text) {
        return new CharSource(){

            public Reader openStream() {
                return new StringReader(text);
            }
        };
    }

    public void testSkip() throws Exception {
        String begin = "abcde";
        String end = "fghij";
        Reader joinedReader = CharSource.concat((CharSource[])new CharSource[]{MultiReaderTest.newCharSource(begin), MultiReaderTest.newCharSource(end)}).openStream();
        String string = String.valueOf(begin);
        String string2 = String.valueOf(end);
        String expected = string2.length() != 0 ? string.concat(string2) : new String(string);
        MultiReaderTest.assertEquals((int)expected.charAt(0), (int)joinedReader.read());
        CharStreams.skipFully((Reader)joinedReader, (long)1L);
        MultiReaderTest.assertEquals((int)expected.charAt(2), (int)joinedReader.read());
        CharStreams.skipFully((Reader)joinedReader, (long)4L);
        MultiReaderTest.assertEquals((int)expected.charAt(7), (int)joinedReader.read());
        CharStreams.skipFully((Reader)joinedReader, (long)1L);
        MultiReaderTest.assertEquals((int)expected.charAt(9), (int)joinedReader.read());
        MultiReaderTest.assertEquals((int)-1, (int)joinedReader.read());
    }

    public void testSkipZero() throws Exception {
        CharSource source = MultiReaderTest.newCharSource("a");
        ImmutableList list = ImmutableList.of((Object)source, (Object)source);
        Reader joinedReader = CharSource.concat((Iterable)list).openStream();
        MultiReaderTest.assertEquals((long)0L, (long)joinedReader.skip(0L));
        MultiReaderTest.assertEquals((int)97, (int)joinedReader.read());
    }
}

