/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.SourceSinkFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;

public class SourceSinkTester<S, T, F extends SourceSinkFactory<S, T>>
extends TestCase {
    static final String LOREM_IPSUM = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras fringilla elit ac ipsum adipiscing vulputate. Maecenas in lorem nulla, ac sollicitudin quam. Praesent neque elit, sodales quis vestibulum vel, pellentesque nec erat. Proin cursus commodo lacus eget congue. Aliquam erat volutpat. Fusce ut leo sed risus tempor vehicula et a odio. Nam aliquet dolor viverra libero rutrum accumsan quis in augue. Suspendisse id dui in lorem tristique placerat eget vel risus. Sed metus neque, scelerisque in molestie ac, mattis quis lectus. Pellentesque viverra justo commodo quam bibendum ut gravida leo accumsan. Nullam malesuada sagittis diam, quis suscipit mauris euismod vulputate. Pellentesque ultrices tellus sed lorem aliquet pulvinar. Nam lorem nunc, ultrices at auctor non, scelerisque eget turpis. Nullam eget varius erat. Sed a lorem id arcu dictum euismod. Fusce lectus odio, elementum ullamcorper mattis viverra, dictum sit amet lacus.\n\nNunc quis lacus est. Sed aliquam pretium cursus. Sed eu libero eros. In hac habitasse platea dictumst. Pellentesque molestie, nibh nec iaculis luctus, justo sem lobortis enim, at feugiat leo magna nec libero. Mauris quis odio eget nisl rutrum cursus nec eget augue. Sed nec arcu sem. In hac habitasse platea dictumst.";
    static final ImmutableMap<String, String> TEST_STRINGS = ImmutableMap.builder().put((Object)"empty", (Object)"").put((Object)"1 char", (Object)"0").put((Object)"1 word", (Object)"hello").put((Object)"2 words", (Object)"hello world").put((Object)"\\n line break", (Object)"hello\nworld").put((Object)"\\r line break", (Object)"hello\rworld").put((Object)"\\r\\n line break", (Object)"hello\r\nworld").put((Object)"\\n at EOF", (Object)"hello\nworld\n").put((Object)"\\r at EOF", (Object)"hello\nworld\r").put((Object)"lorem ipsum", (Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras fringilla elit ac ipsum adipiscing vulputate. Maecenas in lorem nulla, ac sollicitudin quam. Praesent neque elit, sodales quis vestibulum vel, pellentesque nec erat. Proin cursus commodo lacus eget congue. Aliquam erat volutpat. Fusce ut leo sed risus tempor vehicula et a odio. Nam aliquet dolor viverra libero rutrum accumsan quis in augue. Suspendisse id dui in lorem tristique placerat eget vel risus. Sed metus neque, scelerisque in molestie ac, mattis quis lectus. Pellentesque viverra justo commodo quam bibendum ut gravida leo accumsan. Nullam malesuada sagittis diam, quis suscipit mauris euismod vulputate. Pellentesque ultrices tellus sed lorem aliquet pulvinar. Nam lorem nunc, ultrices at auctor non, scelerisque eget turpis. Nullam eget varius erat. Sed a lorem id arcu dictum euismod. Fusce lectus odio, elementum ullamcorper mattis viverra, dictum sit amet lacus.\n\nNunc quis lacus est. Sed aliquam pretium cursus. Sed eu libero eros. In hac habitasse platea dictumst. Pellentesque molestie, nibh nec iaculis luctus, justo sem lobortis enim, at feugiat leo magna nec libero. Mauris quis odio eget nisl rutrum cursus nec eget augue. Sed nec arcu sem. In hac habitasse platea dictumst.").build();
    protected final F factory;
    protected final T data;
    protected final T expected;
    private final String suiteName;
    private final String caseDesc;

    SourceSinkTester(F factory, T data, String suiteName, String caseDesc, Method method) {
        super(method.getName());
        this.factory = (SourceSinkFactory)Preconditions.checkNotNull(factory);
        this.data = Preconditions.checkNotNull(data);
        this.expected = Preconditions.checkNotNull(factory.getExpected(data));
        this.suiteName = (String)Preconditions.checkNotNull((Object)suiteName);
        this.caseDesc = (String)Preconditions.checkNotNull((Object)caseDesc);
    }

    public String getName() {
        String string = String.valueOf(String.valueOf(super.getName()));
        String string2 = String.valueOf(String.valueOf(this.suiteName));
        String string3 = String.valueOf(String.valueOf(this.caseDesc));
        return new StringBuilder(6 + string.length() + string2.length() + string3.length()).append(string).append(" [").append(string2).append(" [").append(string3).append("]]").toString();
    }

    protected static ImmutableList<String> getLines(final String string) {
        try {
            return new CharSource(){

                public Reader openStream() throws IOException {
                    return new StringReader(string);
                }
            }.readLines();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public void tearDown() throws IOException {
        this.factory.tearDown();
    }

    static ImmutableList<Method> getTestMethods(Class<?> testClass) {
        ArrayList result = Lists.newArrayList();
        for (Method method : testClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 0 || !method.getName().startsWith("test")) continue;
            result.add(method);
        }
        return ImmutableList.copyOf((Collection)result);
    }
}

