/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.collect.ImmutableList;
import com.google.common.net.HostSpecifier;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.text.ParseException;
import java.util.List;
import junit.framework.TestCase;

public final class HostSpecifierTest
extends TestCase {
    private static final List<String> GOOD_IPS = ImmutableList.of((Object)"1.2.3.4", (Object)"2001:db8::1", (Object)"[2001:db8::1]");
    private static final List<String> BAD_IPS = ImmutableList.of((Object)"1.2.3", (Object)"2001:db8::1::::::0", (Object)"[2001:db8::1", (Object)"[::]:80");
    private static final List<String> GOOD_DOMAINS = ImmutableList.of((Object)"com", (Object)"google.com", (Object)"foo.co.uk");
    private static final List<String> BAD_DOMAINS = ImmutableList.of((Object)"foo.blah", (Object)"", (Object)"[google.com]");

    public void testGoodIpAddresses() throws ParseException {
        for (String spec : GOOD_IPS) {
            this.assertGood(spec);
        }
    }

    public void testBadIpAddresses() {
        for (String spec : BAD_IPS) {
            this.assertBad(spec);
        }
    }

    public void testGoodDomains() throws ParseException {
        for (String spec : GOOD_DOMAINS) {
            this.assertGood(spec);
        }
    }

    public void testBadDomains() {
        for (String spec : BAD_DOMAINS) {
            this.assertBad(spec);
        }
    }

    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{HostSpecifierTest.spec("1.2.3.4"), HostSpecifierTest.spec("1.2.3.4")}).addEqualityGroup(new Object[]{HostSpecifierTest.spec("2001:db8::1"), HostSpecifierTest.spec("2001:db8::1"), HostSpecifierTest.spec("[2001:db8::1]")}).addEqualityGroup(new Object[]{HostSpecifierTest.spec("2001:db8::2")}).addEqualityGroup(new Object[]{HostSpecifierTest.spec("google.com"), HostSpecifierTest.spec("google.com")}).addEqualityGroup(new Object[]{HostSpecifierTest.spec("www.google.com")}).testEquals();
    }

    private static HostSpecifier spec(String specifier) {
        return HostSpecifier.fromValid((String)specifier);
    }

    public void testNulls() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(HostSpecifier.class);
        tester.testAllPublicInstanceMethods((Object)HostSpecifier.fromValid((String)"google.com"));
    }

    private void assertGood(String spec) throws ParseException {
        HostSpecifier.fromValid((String)spec);
        HostSpecifier.from((String)spec);
        HostSpecifierTest.assertTrue((boolean)HostSpecifier.isValid((String)spec));
    }

    private void assertBad(String spec) {
        try {
            HostSpecifier.fromValid((String)spec);
            String string = String.valueOf(spec);
            HostSpecifierTest.fail((String)(string.length() != 0 ? "Should have thrown IllegalArgumentException: ".concat(string) : new String("Should have thrown IllegalArgumentException: ")));
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HostSpecifier.from((String)spec);
            String string = String.valueOf(spec);
            HostSpecifierTest.fail((String)(string.length() != 0 ? "Should have thrown ParseException: ".concat(string) : new String("Should have thrown ParseException: ")));
        }
        catch (ParseException expected) {
            HostSpecifierTest.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException));
        }
        HostSpecifierTest.assertFalse((boolean)HostSpecifier.isValid((String)spec));
    }
}

