/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.net.HttpHeaders;
import java.lang.reflect.Field;
import java.util.ArrayList;
import junit.framework.TestCase;

public class HttpHeadersTest
extends TestCase {
    private static final Splitter SPLITTER = Splitter.on((char)'_');
    private static final Joiner JOINER = Joiner.on((char)'-');

    public void testConstantNameMatchesString() throws Exception {
        ImmutableBiMap specialCases = ImmutableBiMap.of((Object)"ETAG", (Object)"ETag");
        ImmutableSet uppercaseAcronyms = ImmutableSet.of((Object)"ID", (Object)"DNT", (Object)"IP", (Object)"MD5", (Object)"P3P", (Object)"TE", (Object[])new String[]{"UID", "URL", "WWW", "XSS"});
        HttpHeadersTest.assertConstantNameMatchesString(HttpHeaders.class, (ImmutableBiMap<String, String>)specialCases, (ImmutableSet<String>)uppercaseAcronyms);
    }

    static void assertConstantNameMatchesString(Class<?> clazz, ImmutableBiMap<String, String> specialCases, ImmutableSet<String> uppercaseAcronyms) throws IllegalAccessException {
        for (Field field : HttpHeadersTest.relevantFields(clazz)) {
            HttpHeadersTest.assertEquals((Object)HttpHeadersTest.upperToHttpHeaderName(field.getName(), specialCases, uppercaseAcronyms), (Object)field.get(null));
        }
    }

    static ImmutableSet<Field> relevantFields(Class<?> cls) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Field field : cls.getDeclaredFields()) {
            if (field.isSynthetic() || field.getType() != String.class) continue;
            builder.add((Object)field);
        }
        return builder.build();
    }

    private static String upperToHttpHeaderName(String constantName, ImmutableBiMap<String, String> specialCases, ImmutableSet<String> uppercaseAcronyms) {
        if (specialCases.containsKey((Object)constantName)) {
            return (String)specialCases.get((Object)constantName);
        }
        ArrayList parts = Lists.newArrayList();
        for (String part : SPLITTER.split((CharSequence)constantName)) {
            if (!uppercaseAcronyms.contains((Object)part)) {
                char c = part.charAt(0);
                String string = String.valueOf(String.valueOf(Ascii.toLowerCase((String)part.substring(1))));
                part = new StringBuilder(1 + string.length()).append(c).append(string).toString();
            }
            parts.add(part);
        }
        return JOINER.join((Iterable)parts);
    }
}

