/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Bytes;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ByteArrayAsListTest
extends TestCase {
    private static List<Byte> asList(Byte[] values) {
        byte[] temp = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = (Byte)Preconditions.checkNotNull((Object)values[i]);
        }
        return Bytes.asList((byte[])temp);
    }

    @GwtIncompatible(value="suite")
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new BytesAsListGenerator()).named("Bytes.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new BytesAsListHeadSubListGenerator()).named("Bytes.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new BytesAsListTailSubListGenerator()).named("Bytes.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new BytesAsListMiddleSubListGenerator()).named("Bytes.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Byte[] concat(Byte[] left, Byte[] right) {
        Byte[] result = new Byte[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static class SampleBytes
    extends SampleElements<Byte> {
        public SampleBytes() {
            super((Object)0, (Object)1, (Object)2, (Object)3, (Object)4);
        }
    }

    public static abstract class TestByteListGenerator
    implements TestListGenerator<Byte> {
        public SampleElements<Byte> samples() {
            return new SampleBytes();
        }

        public List<Byte> create(Object ... elements) {
            Byte[] array = new Byte[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Byte)e;
            }
            return this.create(array);
        }

        protected abstract List<Byte> create(Byte[] var1);

        public Byte[] createArray(int length) {
            return new Byte[length];
        }

        public List<Byte> order(List<Byte> insertionOrder) {
            return insertionOrder;
        }
    }

    public static final class BytesAsListMiddleSubListGenerator
    extends TestByteListGenerator {
        @Override
        protected List<Byte> create(Byte[] elements) {
            Byte[] prefix = new Byte[]{(byte)-128, (byte)127};
            Byte[] suffix = new Byte[]{(byte)86, (byte)99};
            Byte[] all = ByteArrayAsListTest.concat(ByteArrayAsListTest.concat(prefix, elements), suffix);
            return ByteArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class BytesAsListTailSubListGenerator
    extends TestByteListGenerator {
        @Override
        protected List<Byte> create(Byte[] elements) {
            Byte[] prefix = new Byte[]{(byte)86, (byte)99};
            Byte[] all = ByteArrayAsListTest.concat(prefix, elements);
            return ByteArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class BytesAsListHeadSubListGenerator
    extends TestByteListGenerator {
        @Override
        protected List<Byte> create(Byte[] elements) {
            Byte[] suffix = new Byte[]{(byte)-128, (byte)127};
            Byte[] all = ByteArrayAsListTest.concat(elements, suffix);
            return ByteArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    public static final class BytesAsListGenerator
    extends TestByteListGenerator {
        @Override
        protected List<Byte> create(Byte[] elements) {
            return ByteArrayAsListTest.asList(elements);
        }
    }
}

