/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Shorts;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class ShortsTest
extends TestCase {
    private static final short[] EMPTY = new short[0];
    private static final short[] ARRAY1 = new short[]{1};
    private static final short[] ARRAY234 = new short[]{2, 3, 4};
    private static final short LEAST = Short.MIN_VALUE;
    private static final short GREATEST = Short.MAX_VALUE;
    private static final short[] VALUES = new short[]{Short.MIN_VALUE, -1, 0, 1, Short.MAX_VALUE};

    public void testHashCode() {
        for (short value : VALUES) {
            ShortsTest.assertEquals((int)Short.valueOf(value).hashCode(), (int)Shorts.hashCode((short)value));
        }
    }

    public void testCheckedCast() {
        for (short value : VALUES) {
            ShortsTest.assertEquals((short)value, (short)Shorts.checkedCast((long)value));
        }
        ShortsTest.assertCastFails(32768L);
        ShortsTest.assertCastFails(-32769L);
        ShortsTest.assertCastFails(Long.MAX_VALUE);
        ShortsTest.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (short value : VALUES) {
            ShortsTest.assertEquals((short)value, (short)Shorts.saturatedCast((long)value));
        }
        ShortsTest.assertEquals((short)Short.MAX_VALUE, (short)Shorts.saturatedCast((long)32768L));
        ShortsTest.assertEquals((short)Short.MIN_VALUE, (short)Shorts.saturatedCast((long)-32769L));
        ShortsTest.assertEquals((short)Short.MAX_VALUE, (short)Shorts.saturatedCast((long)Long.MAX_VALUE));
        ShortsTest.assertEquals((short)Short.MIN_VALUE, (short)Shorts.saturatedCast((long)Long.MIN_VALUE));
    }

    private static void assertCastFails(long value) {
        try {
            Shorts.checkedCast((long)value);
            long l = value;
            ShortsTest.fail((String)new StringBuilder(54).append("Cast to short should have failed: ").append(l).toString());
        }
        catch (IllegalArgumentException ex) {
            long l = value;
            String string = String.valueOf(String.valueOf(ex.getMessage()));
            ShortsTest.assertTrue((String)new StringBuilder(50 + string.length()).append(l).append(" not found in exception text: ").append(string).toString(), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (short x : VALUES) {
            for (short y : VALUES) {
                int n;
                int n2;
                short s;
                short s2;
                int expected = Short.valueOf(x).compareTo(y);
                int actual = Shorts.compare((short)x, (short)y);
                if (expected == 0) {
                    s2 = x;
                    s = y;
                    ShortsTest.assertEquals((String)new StringBuilder(14).append(s2).append(", ").append(s).toString(), (int)expected, (int)actual);
                    continue;
                }
                if (expected < 0) {
                    s2 = x;
                    s = y;
                    n2 = expected;
                    n = actual;
                    ShortsTest.assertTrue((String)new StringBuilder(57).append(s2).append(", ").append(s).append(" (expected: ").append(n2).append(", actual").append(n).append(")").toString(), (actual < 0 ? 1 : 0) != 0);
                    continue;
                }
                s2 = x;
                s = y;
                n2 = expected;
                n = actual;
                ShortsTest.assertTrue((String)new StringBuilder(57).append(s2).append(", ").append(s).append(" (expected: ").append(n2).append(", actual").append(n).append(")").toString(), (actual > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testContains() {
        ShortsTest.assertFalse((boolean)Shorts.contains((short[])EMPTY, (short)1));
        ShortsTest.assertFalse((boolean)Shorts.contains((short[])ARRAY1, (short)2));
        ShortsTest.assertFalse((boolean)Shorts.contains((short[])ARRAY234, (short)1));
        ShortsTest.assertTrue((boolean)Shorts.contains((short[])new short[]{-1}, (short)-1));
        ShortsTest.assertTrue((boolean)Shorts.contains((short[])ARRAY234, (short)2));
        ShortsTest.assertTrue((boolean)Shorts.contains((short[])ARRAY234, (short)3));
        ShortsTest.assertTrue((boolean)Shorts.contains((short[])ARRAY234, (short)4));
    }

    public void testIndexOf() {
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])EMPTY, (short)1));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])ARRAY1, (short)2));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])ARRAY234, (short)1));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])new short[]{-1}, (short)-1));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])ARRAY234, (short)2));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])ARRAY234, (short)3));
        ShortsTest.assertEquals((int)2, (int)Shorts.indexOf((short[])ARRAY234, (short)4));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])new short[]{2, 3, 2, 3}, (short)3));
    }

    public void testIndexOf_arrayTarget() {
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])EMPTY, (short[])EMPTY));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])ARRAY234, (short[])EMPTY));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])EMPTY, (short[])ARRAY234));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])ARRAY234, (short[])ARRAY1));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])ARRAY1, (short[])ARRAY234));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])ARRAY1, (short[])ARRAY1));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])ARRAY234, (short[])ARRAY234));
        ShortsTest.assertEquals((int)0, (int)Shorts.indexOf((short[])ARRAY234, (short[])new short[]{2, 3}));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])ARRAY234, (short[])new short[]{3, 4}));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])ARRAY234, (short[])new short[]{3}));
        ShortsTest.assertEquals((int)2, (int)Shorts.indexOf((short[])ARRAY234, (short[])new short[]{4}));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])new short[]{2, 3, 3, 3, 3}, (short[])new short[]{3}));
        ShortsTest.assertEquals((int)2, (int)Shorts.indexOf((short[])new short[]{2, 3, 2, 3, 4, 2, 3}, (short[])new short[]{2, 3, 4}));
        ShortsTest.assertEquals((int)1, (int)Shorts.indexOf((short[])new short[]{2, 2, 3, 4, 2, 3, 4}, (short[])new short[]{2, 3, 4}));
        ShortsTest.assertEquals((int)-1, (int)Shorts.indexOf((short[])new short[]{4, 3, 2}, (short[])new short[]{2, 3, 4}));
    }

    public void testLastIndexOf() {
        ShortsTest.assertEquals((int)-1, (int)Shorts.lastIndexOf((short[])EMPTY, (short)1));
        ShortsTest.assertEquals((int)-1, (int)Shorts.lastIndexOf((short[])ARRAY1, (short)2));
        ShortsTest.assertEquals((int)-1, (int)Shorts.lastIndexOf((short[])ARRAY234, (short)1));
        ShortsTest.assertEquals((int)0, (int)Shorts.lastIndexOf((short[])new short[]{-1}, (short)-1));
        ShortsTest.assertEquals((int)0, (int)Shorts.lastIndexOf((short[])ARRAY234, (short)2));
        ShortsTest.assertEquals((int)1, (int)Shorts.lastIndexOf((short[])ARRAY234, (short)3));
        ShortsTest.assertEquals((int)2, (int)Shorts.lastIndexOf((short[])ARRAY234, (short)4));
        ShortsTest.assertEquals((int)3, (int)Shorts.lastIndexOf((short[])new short[]{2, 3, 2, 3}, (short)3));
    }

    public void testMax_noArgs() {
        try {
            Shorts.max((short[])new short[0]);
            ShortsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        ShortsTest.assertEquals((short)Short.MIN_VALUE, (short)Shorts.max((short[])new short[]{Short.MIN_VALUE}));
        ShortsTest.assertEquals((short)Short.MAX_VALUE, (short)Shorts.max((short[])new short[]{Short.MAX_VALUE}));
        ShortsTest.assertEquals((short)9, (short)Shorts.max((short[])new short[]{8, 6, 7, 5, 3, 0, 9}));
    }

    public void testMin_noArgs() {
        try {
            Shorts.min((short[])new short[0]);
            ShortsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        ShortsTest.assertEquals((short)Short.MIN_VALUE, (short)Shorts.min((short[])new short[]{Short.MIN_VALUE}));
        ShortsTest.assertEquals((short)Short.MAX_VALUE, (short)Shorts.min((short[])new short[]{Short.MAX_VALUE}));
        ShortsTest.assertEquals((short)0, (short)Shorts.min((short[])new short[]{8, 6, 7, 5, 3, 0, 9}));
    }

    public void testConcat() {
        ShortsTest.assertTrue((boolean)Arrays.equals(EMPTY, Shorts.concat((short[][])new short[0][])));
        ShortsTest.assertTrue((boolean)Arrays.equals(EMPTY, Shorts.concat((short[][])new short[][]{EMPTY})));
        ShortsTest.assertTrue((boolean)Arrays.equals(EMPTY, Shorts.concat((short[][])new short[][]{EMPTY, EMPTY, EMPTY})));
        ShortsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Shorts.concat((short[][])new short[][]{ARRAY1})));
        ShortsTest.assertNotSame((Object)ARRAY1, (Object)Shorts.concat((short[][])new short[][]{ARRAY1}));
        ShortsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Shorts.concat((short[][])new short[][]{EMPTY, ARRAY1, EMPTY})));
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{1, 1, 1}, Shorts.concat((short[][])new short[][]{ARRAY1, ARRAY1, ARRAY1})));
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 3, 4}, Shorts.concat((short[][])new short[][]{ARRAY1, ARRAY234})));
    }

    @GwtIncompatible(value="Shorts.toByteArray")
    public void testToByteArray() {
        ShortsTest.assertTrue((boolean)Arrays.equals(new byte[]{35, 69}, Shorts.toByteArray((short)9029)));
        ShortsTest.assertTrue((boolean)Arrays.equals(new byte[]{-2, -36}, Shorts.toByteArray((short)-292)));
    }

    @GwtIncompatible(value="Shorts.fromByteArray")
    public void testFromByteArray() {
        ShortsTest.assertEquals((short)9029, (short)Shorts.fromByteArray((byte[])new byte[]{35, 69}));
        ShortsTest.assertEquals((short)-292, (short)Shorts.fromByteArray((byte[])new byte[]{-2, -36}));
        try {
            Shorts.fromByteArray((byte[])new byte[]{1});
            ShortsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Shorts.fromBytes")
    public void testFromBytes() {
        ShortsTest.assertEquals((short)9029, (short)Shorts.fromBytes((byte)35, (byte)69));
        ShortsTest.assertEquals((short)-292, (short)Shorts.fromBytes((byte)-2, (byte)-36));
    }

    @GwtIncompatible(value="Shorts.fromByteArray, Shorts.toByteArray")
    public void testByteArrayRoundTrips() {
        Random r = new Random(5L);
        byte[] b = new byte[2];
        for (int i = 0; i < 10000; ++i) {
            short num = (short)r.nextInt();
            ShortsTest.assertEquals((short)num, (short)Shorts.fromByteArray((byte[])Shorts.toByteArray((short)num)));
            r.nextBytes(b);
            ShortsTest.assertTrue((boolean)Arrays.equals(b, Shorts.toByteArray((short)Shorts.fromByteArray((byte[])b))));
        }
    }

    public void testEnsureCapacity() {
        ShortsTest.assertSame((Object)EMPTY, (Object)Shorts.ensureCapacity((short[])EMPTY, (int)0, (int)1));
        ShortsTest.assertSame((Object)ARRAY1, (Object)Shorts.ensureCapacity((short[])ARRAY1, (int)0, (int)1));
        ShortsTest.assertSame((Object)ARRAY1, (Object)Shorts.ensureCapacity((short[])ARRAY1, (int)1, (int)1));
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{1, 0, 0}, Shorts.ensureCapacity((short[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Shorts.ensureCapacity((short[])ARRAY1, (int)-1, (int)1);
            ShortsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Shorts.ensureCapacity((short[])ARRAY1, (int)1, (int)-1);
            ShortsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoin() {
        ShortsTest.assertEquals((String)"", (String)Shorts.join((String)",", (short[])EMPTY));
        ShortsTest.assertEquals((String)"1", (String)Shorts.join((String)",", (short[])ARRAY1));
        ShortsTest.assertEquals((String)"1,2", (String)Shorts.join((String)",", (short[])new short[]{1, 2}));
        ShortsTest.assertEquals((String)"123", (String)Shorts.join((String)"", (short[])new short[]{1, 2, 3}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new short[0], {Short.MIN_VALUE}, {Short.MIN_VALUE, Short.MIN_VALUE}, {Short.MIN_VALUE, 1}, {1}, {1, Short.MIN_VALUE}, {Short.MAX_VALUE, 32766}, {Short.MAX_VALUE, Short.MAX_VALUE}, {Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE});
        Comparator comparator = Shorts.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Shorts.lexicographicalComparator();
        ShortsTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testStringConverterSerialization() {
        SerializableTester.reserializeAndAssert((Object)Shorts.stringConverter());
    }

    public void testToArray() {
        List<Short> none = Arrays.asList(new Short[0]);
        ShortsTest.assertTrue((boolean)Arrays.equals(EMPTY, Shorts.toArray(none)));
        List<Short> one = Arrays.asList((short)1);
        ShortsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Shorts.toArray(one)));
        short[] array = new short[]{0, 1, 3};
        List<Short> three = Arrays.asList((short)0, (short)1, (short)3);
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(three)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray((Collection)Shorts.asList((short[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Shorts.asList((short[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                short[] arr = Shorts.toArray((Collection)misleadingSize);
                ShortsTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    ShortsTest.assertEquals((short)VALUES[j], (short)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Short> list = Arrays.asList((short)0, (short)1, null);
        try {
            Shorts.toArray(list);
            ShortsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        short[] array = new short[]{0, 1, 2};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(bytes)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(shorts)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(ints)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(floats)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(longs)));
        ShortsTest.assertTrue((boolean)Arrays.equals(array, Shorts.toArray(doubles)));
    }

    public void testAsList_isAView() {
        short[] array = new short[]{0, 1};
        List list = Shorts.asList((short[])array);
        list.set(0, (short)2);
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, array));
        array[1] = 3;
        ShortsTest.assertEquals(Arrays.asList((short)2, (short)3), (Object)list);
    }

    public void testAsList_toArray_roundTrip() {
        short[] array = new short[]{0, 1, 2};
        List list = Shorts.asList((short[])array);
        short[] newArray = Shorts.toArray((Collection)list);
        list.set(0, (short)4);
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{0, 1, 2}, newArray));
        newArray[1] = 5;
        ShortsTest.assertEquals((short)1, (short)((Short)list.get(1)));
    }

    public void testAsList_subList_toArray_roundTrip() {
        short[] array = new short[]{0, 1, 2, 3};
        List list = Shorts.asList((short[])array);
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[]{1, 2}, Shorts.toArray(list.subList(1, 3))));
        ShortsTest.assertTrue((boolean)Arrays.equals(new short[0], Shorts.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        ShortsTest.assertSame(Collections.emptyList(), (Object)Shorts.asList((short[])EMPTY));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Shorts.class);
    }

    public void testStringConverter_convert() {
        Converter converter = Shorts.stringConverter();
        ShortsTest.assertEquals((Object)1, (Object)converter.convert((Object)"1"));
        ShortsTest.assertEquals((Object)0, (Object)converter.convert((Object)"0"));
        ShortsTest.assertEquals((Object)-1, (Object)converter.convert((Object)"-1"));
        ShortsTest.assertEquals((Object)255, (Object)converter.convert((Object)"0xff"));
        ShortsTest.assertEquals((Object)255, (Object)converter.convert((Object)"0xFF"));
        ShortsTest.assertEquals((Object)-255, (Object)converter.convert((Object)"-0xFF"));
        ShortsTest.assertEquals((Object)255, (Object)converter.convert((Object)"#0000FF"));
        ShortsTest.assertEquals((Object)438, (Object)converter.convert((Object)"0666"));
    }

    public void testStringConverter_convertError() {
        try {
            Shorts.stringConverter().convert((Object)"notanumber");
            ShortsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testStringConverter_nullConversions() {
        ShortsTest.assertNull((Object)Shorts.stringConverter().convert(null));
        ShortsTest.assertNull((Object)Shorts.stringConverter().reverse().convert(null));
    }

    public void testStringConverter_reverse() {
        Converter converter = Shorts.stringConverter();
        ShortsTest.assertEquals((String)"1", (String)((String)converter.reverse().convert((Object)1)));
        ShortsTest.assertEquals((String)"0", (String)((String)converter.reverse().convert((Object)0)));
        ShortsTest.assertEquals((String)"-1", (String)((String)converter.reverse().convert((Object)-1)));
        ShortsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255)));
        ShortsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255)));
        ShortsTest.assertEquals((String)"-255", (String)((String)converter.reverse().convert((Object)-255)));
        ShortsTest.assertEquals((String)"438", (String)((String)converter.reverse().convert((Object)438)));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testStringConverter_nullPointerTester() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)Shorts.stringConverter());
    }
}

