/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedInts;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.math.BigInteger;
import java.util.Iterator;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class UnsignedIntegerTest
extends TestCase {
    private static final ImmutableSet<Integer> TEST_INTS;
    private static final ImmutableSet<Long> TEST_LONGS;

    private static int force32(int value) {
        return value & 0xFFFFFFFF;
    }

    public void testFromIntBitsAndIntValueAreInverses() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            UnsignedIntegerTest.assertEquals((String)UnsignedInts.toString((int)value), (int)value, (int)UnsignedInteger.fromIntBits((int)value).intValue());
        }
    }

    public void testFromIntBitsLongValue() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            long expected = (long)value & 0xFFFFFFFFL;
            UnsignedIntegerTest.assertEquals((String)UnsignedInts.toString((int)value), (long)expected, (long)UnsignedInteger.fromIntBits((int)value).longValue());
        }
    }

    public void testValueOfLong() {
        long min = 0L;
        long max = 0xFFFFFFFFL;
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            boolean expectSuccess = value >= min && value <= max;
            try {
                UnsignedIntegerTest.assertEquals((long)value, (long)UnsignedInteger.valueOf((long)value).longValue());
                UnsignedIntegerTest.assertTrue((boolean)expectSuccess);
            }
            catch (IllegalArgumentException e) {
                UnsignedIntegerTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    public void testValueOfBigInteger() {
        long min = 0L;
        long max = 0xFFFFFFFFL;
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            boolean expectSuccess = value >= min && value <= max;
            try {
                UnsignedIntegerTest.assertEquals((long)value, (long)UnsignedInteger.valueOf((BigInteger)BigInteger.valueOf(value)).longValue());
                UnsignedIntegerTest.assertTrue((boolean)expectSuccess);
            }
            catch (IllegalArgumentException e) {
                UnsignedIntegerTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    public void testToString() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            UnsignedInteger unsignedValue = UnsignedInteger.fromIntBits((int)value);
            UnsignedIntegerTest.assertEquals((String)unsignedValue.bigIntegerValue().toString(), (String)unsignedValue.toString());
        }
    }

    @GwtIncompatible(value="too slow")
    public void testToStringRadix() {
        for (int radix = 2; radix <= 36; ++radix) {
            Iterator i$ = TEST_INTS.iterator();
            while (i$.hasNext()) {
                int l = (Integer)i$.next();
                UnsignedInteger value = UnsignedInteger.fromIntBits((int)l);
                UnsignedIntegerTest.assertEquals((String)value.bigIntegerValue().toString(radix), (String)value.toString(radix));
            }
        }
    }

    public void testToStringRadixQuick() {
        int[] radices;
        for (int radix : radices = new int[]{2, 3, 5, 7, 10, 12, 16, 21, 31, 36}) {
            Iterator i$ = TEST_INTS.iterator();
            while (i$.hasNext()) {
                int l = (Integer)i$.next();
                UnsignedInteger value = UnsignedInteger.fromIntBits((int)l);
                UnsignedIntegerTest.assertEquals((String)value.bigIntegerValue().toString(radix), (String)value.toString(radix));
            }
        }
    }

    public void testFloatValue() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            UnsignedInteger unsignedValue = UnsignedInteger.fromIntBits((int)value);
            UnsignedIntegerTest.assertEquals((Object)Float.valueOf(unsignedValue.bigIntegerValue().floatValue()), (Object)Float.valueOf(unsignedValue.floatValue()));
        }
    }

    public void testDoubleValue() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            UnsignedInteger unsignedValue = UnsignedInteger.fromIntBits((int)value);
            UnsignedIntegerTest.assertEquals((Object)unsignedValue.bigIntegerValue().doubleValue(), (Object)unsignedValue.doubleValue());
        }
    }

    public void testPlus() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                int expected = aUnsigned.bigIntegerValue().add(bUnsigned.bigIntegerValue()).intValue();
                UnsignedInteger unsignedSum = aUnsigned.plus(bUnsigned);
                UnsignedIntegerTest.assertEquals((int)expected, (int)unsignedSum.intValue());
            }
        }
    }

    public void testMinus() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                int expected = UnsignedIntegerTest.force32(aUnsigned.bigIntegerValue().subtract(bUnsigned.bigIntegerValue()).intValue());
                UnsignedInteger unsignedSub = aUnsigned.minus(bUnsigned);
                UnsignedIntegerTest.assertEquals((int)expected, (int)unsignedSub.intValue());
            }
        }
    }

    @GwtIncompatible(value="multiply")
    public void testTimes() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                int expected = UnsignedIntegerTest.force32(aUnsigned.bigIntegerValue().multiply(bUnsigned.bigIntegerValue()).intValue());
                UnsignedInteger unsignedMul = aUnsigned.times(bUnsigned);
                String string = String.valueOf(String.valueOf(aUnsigned));
                String string2 = String.valueOf(String.valueOf(bUnsigned));
                UnsignedIntegerTest.assertEquals((String)new StringBuilder(3 + string.length() + string2.length()).append(string).append(" * ").append(string2).toString(), (int)expected, (int)unsignedMul.intValue());
            }
        }
    }

    public void testDividedBy() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                if (b == 0) continue;
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                int expected = aUnsigned.bigIntegerValue().divide(bUnsigned.bigIntegerValue()).intValue();
                UnsignedInteger unsignedDiv = aUnsigned.dividedBy(bUnsigned);
                UnsignedIntegerTest.assertEquals((int)expected, (int)unsignedDiv.intValue());
            }
        }
    }

    public void testDivideByZeroThrows() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            try {
                UnsignedInteger ignored = UnsignedInteger.fromIntBits((int)a).dividedBy(UnsignedInteger.ZERO);
                UnsignedIntegerTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    public void testMod() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                if (b == 0) continue;
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                int expected = aUnsigned.bigIntegerValue().mod(bUnsigned.bigIntegerValue()).intValue();
                UnsignedInteger unsignedRem = aUnsigned.mod(bUnsigned);
                UnsignedIntegerTest.assertEquals((int)expected, (int)unsignedRem.intValue());
            }
        }
    }

    public void testModByZero() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            try {
                UnsignedInteger.fromIntBits((int)a).mod(UnsignedInteger.ZERO);
                UnsignedIntegerTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    public void testCompare() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            Iterator i$2 = TEST_INTS.iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
                UnsignedInteger bUnsigned = UnsignedInteger.fromIntBits((int)b);
                UnsignedIntegerTest.assertEquals((int)aUnsigned.bigIntegerValue().compareTo(bUnsigned.bigIntegerValue()), (int)aUnsigned.compareTo(bUnsigned));
            }
        }
    }

    @GwtIncompatible(value="too slow")
    public void testEquals() {
        EqualsTester equalsTester = new EqualsTester();
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            long value = (long)a & 0xFFFFFFFFL;
            equalsTester.addEqualityGroup(new Object[]{UnsignedInteger.fromIntBits((int)a), UnsignedInteger.valueOf((long)value), UnsignedInteger.valueOf((String)Long.toString(value)), UnsignedInteger.valueOf((String)Long.toString(value, 16), (int)16)});
        }
        equalsTester.testEquals();
    }

    public void testIntValue() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            UnsignedInteger aUnsigned = UnsignedInteger.fromIntBits((int)a);
            int intValue = aUnsigned.bigIntegerValue().intValue();
            UnsignedIntegerTest.assertEquals((int)intValue, (int)aUnsigned.intValue());
        }
    }

    @GwtIncompatible(value="serialization")
    public void testSerialization() {
        Iterator i$ = TEST_INTS.iterator();
        while (i$.hasNext()) {
            int a = (Integer)i$.next();
            SerializableTester.reserializeAndAssert((Object)UnsignedInteger.fromIntBits((int)a));
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedInteger.class);
    }

    static {
        ImmutableSet.Builder testIntsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder testLongsBuilder = ImmutableSet.builder();
        for (int i = -3; i <= 3; ++i) {
            testIntsBuilder.add((Object)i).add((Object)UnsignedIntegerTest.force32(Integer.MIN_VALUE + i)).add((Object)UnsignedIntegerTest.force32(Integer.MAX_VALUE + i));
            testLongsBuilder.add((Object)i).add((Object)(Integer.MIN_VALUE + (long)i)).add((Object)(Integer.MAX_VALUE + (long)i)).add((Object)(0x100000000L + (long)i));
        }
        TEST_INTS = testIntsBuilder.build();
        TEST_LONGS = testLongsBuilder.build();
    }
}

