/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.Element;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ElementTest
extends TestCase {
    public void testPrivateField() throws Exception {
        Element element = A.field("privateField");
        ElementTest.assertTrue((boolean)element.isPrivate());
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isProtected());
        ElementTest.assertFalse((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testPackagePrivateField() throws Exception {
        Element element = A.field("packagePrivateField");
        ElementTest.assertFalse((boolean)element.isPrivate());
        ElementTest.assertTrue((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isProtected());
        ElementTest.assertFalse((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testProtectedField() throws Exception {
        Element element = A.field("protectedField");
        ElementTest.assertFalse((boolean)element.isPrivate());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertTrue((boolean)element.isProtected());
        ElementTest.assertFalse((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testPublicField() throws Exception {
        Element element = A.field("publicField");
        ElementTest.assertFalse((boolean)element.isPrivate());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isProtected());
        ElementTest.assertTrue((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testFinalField() throws Exception {
        Element element = A.field("finalField");
        ElementTest.assertTrue((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testStaticField() throws Exception {
        Element element = A.field("staticField");
        ElementTest.assertTrue((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testVolatileField() throws Exception {
        Element element = A.field("volatileField");
        ElementTest.assertTrue((boolean)element.isVolatile());
    }

    public void testTransientField() throws Exception {
        Element element = A.field("transientField");
        ElementTest.assertTrue((boolean)element.isTransient());
    }

    public void testConstructor() throws Exception {
        Element element = A.constructor();
        ElementTest.assertTrue((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isStatic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testAbstractMethod() throws Exception {
        Element element = A.method("abstractMethod", new Class[0]);
        ElementTest.assertTrue((boolean)element.isPackagePrivate());
        ElementTest.assertTrue((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testOverridableMethod() throws Exception {
        Element element = A.method("overridableMethod", new Class[0]);
        ElementTest.assertTrue((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testPrivateMethod() throws Exception {
        Element element = A.method("privateMethod", new Class[0]);
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertTrue((boolean)element.isPrivate());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isPublic());
        ElementTest.assertFalse((boolean)element.isProtected());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testProtectedMethod() throws Exception {
        Element element = A.method("protectedMethod", new Class[0]);
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isPrivate());
        ElementTest.assertFalse((boolean)element.isPackagePrivate());
        ElementTest.assertFalse((boolean)element.isFinal());
        ElementTest.assertFalse((boolean)element.isPublic());
        ElementTest.assertTrue((boolean)element.isProtected());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testFinalMethod() throws Exception {
        Element element = A.method("publicFinalMethod", new Class[0]);
        ElementTest.assertFalse((boolean)element.isAbstract());
        ElementTest.assertFalse((boolean)element.isPrivate());
        ElementTest.assertTrue((boolean)element.isFinal());
        ElementTest.assertTrue((boolean)element.isPublic());
        ElementTest.assertTrue((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testNativeMethod() throws Exception {
        Element element = A.method("nativeMethod", new Class[0]);
        ElementTest.assertTrue((boolean)element.isNative());
        ElementTest.assertTrue((boolean)element.isPackagePrivate());
    }

    public void testSynchronizedMethod() throws Exception {
        Element element = A.method("synchronizedMethod", new Class[0]);
        ElementTest.assertTrue((boolean)element.isSynchronized());
    }

    public void testUnannotatedMethod() throws Exception {
        Element element = A.method("notAnnotatedMethod", new Class[0]);
        ElementTest.assertFalse((boolean)element.isAnnotationPresent(Tested.class));
    }

    public void testEquals() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{A.field("privateField"), A.field("privateField")}).addEqualityGroup(new Object[]{A.field("publicField")}).addEqualityGroup(new Object[]{A.constructor(), A.constructor()}).addEqualityGroup(new Object[]{A.method("privateMethod", new Class[0]), A.method("privateMethod", new Class[0])}).addEqualityGroup(new Object[]{A.method("publicFinalMethod", new Class[0])}).testEquals();
    }

    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Element.class);
    }

    private static abstract class A {
        @Tested
        private boolean privateField;
        @Tested
        int packagePrivateField;
        @Tested
        protected int protectedField;
        @Tested
        public String publicField;
        @Tested
        private static Iterable<String> staticField;
        @Tested
        private final Object finalField;
        private volatile char volatileField;
        private transient long transientField;

        @Tested
        public A(Object finalField) {
            this.finalField = finalField;
        }

        @Tested
        abstract void abstractMethod();

        @Tested
        void overridableMethod() {
        }

        @Tested
        protected void protectedMethod() {
        }

        @Tested
        private void privateMethod() {
        }

        @Tested
        public final void publicFinalMethod() {
        }

        void notAnnotatedMethod() {
        }

        static Element field(String name) throws Exception {
            Element element = new Element((AccessibleObject)A.class.getDeclaredField(name));
            Assert.assertEquals((String)name, (String)element.getName());
            Assert.assertEquals(A.class, (Object)element.getDeclaringClass());
            return element;
        }

        static Element constructor() throws Exception {
            Constructor constructor = A.class.getDeclaredConstructor(Object.class);
            Element element = new Element(constructor);
            Assert.assertEquals((String)constructor.getName(), (String)element.getName());
            Assert.assertEquals(A.class, (Object)element.getDeclaringClass());
            return element;
        }

        static Element method(String name, Class<?> ... parameterTypes) throws Exception {
            Element element = new Element((AccessibleObject)A.class.getDeclaredMethod(name, parameterTypes));
            Assert.assertEquals((String)name, (String)element.getName());
            Assert.assertEquals(A.class, (Object)element.getDeclaringClass());
            return element;
        }

        native void nativeMethod();

        synchronized void synchronizedMethod() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Tested {
    }
}

