/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.Types;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TypesTest
extends TestCase {
    public void testNewParameterizedType_ownerTypeImplied() throws Exception {
        ParameterizedType jvmType = (ParameterizedType)new TypeCapture<Map.Entry<String, Integer>>(){}.capture();
        ParameterizedType ourType = Types.newParameterizedType(Map.Entry.class, (Type[])new Type[]{String.class, Integer.class});
        TypesTest.assertEquals((Object)jvmType, (Object)ourType);
        TypesTest.assertEquals(Map.class, (Object)ourType.getOwnerType());
    }

    public void testNewParameterizedType() {
        ParameterizedType jvmType = (ParameterizedType)new TypeCapture<HashMap<String, int[][]>>(){}.capture();
        ParameterizedType ourType = Types.newParameterizedType(HashMap.class, (Type[])new Type[]{String.class, int[][].class});
        new EqualsTester().addEqualityGroup(new Object[]{jvmType, ourType}).testEquals();
        TypesTest.assertEquals((String)jvmType.toString(), (String)ourType.toString());
        TypesTest.assertEquals((int)jvmType.hashCode(), (int)ourType.hashCode());
        TypesTest.assertEquals(HashMap.class, (Object)ourType.getRawType());
        Truth.assertThat((Object[])ourType.getActualTypeArguments()).asList().has().exactlyAs(Arrays.asList(jvmType.getActualTypeArguments())).inOrder();
        TypesTest.assertEquals(Arrays.asList(String.class, Types.newArrayType((Type)Types.newArrayType(Integer.TYPE))), Arrays.asList(ourType.getActualTypeArguments()));
        TypesTest.assertEquals(null, (Object)ourType.getOwnerType());
    }

    public void testNewParameterizedType_nonStaticLocalClass() {
        Type jvmType = new LocalClass<String>(){
            {
                class LocalClass<T> {
                    LocalClass() {
                    }
                }
            }
        }.getClass().getGenericSuperclass();
        ParameterizedType ourType = Types.newParameterizedType(LocalClass.class, (Type[])new Type[]{String.class});
        TypesTest.assertEquals((Object)jvmType, (Object)ourType);
    }

    public void testNewParameterizedType_staticLocalClass() {
        TypesTest.doTestNewParameterizedType_staticLocalClass();
    }

    private static void doTestNewParameterizedType_staticLocalClass() {
        Type jvmType = new LocalClass<String>(){
            {
                class LocalClass<T> {
                    LocalClass() {
                    }
                }
            }
        }.getClass().getGenericSuperclass();
        ParameterizedType ourType = Types.newParameterizedType(LocalClass.class, (Type[])new Type[]{String.class});
        TypesTest.assertEquals((Object)jvmType, (Object)ourType);
    }

    public void testNewParameterizedTypeWithOwner() {
        ParameterizedType jvmType = (ParameterizedType)new TypeCapture<Map.Entry<String, int[][]>>(){}.capture();
        ParameterizedType ourType = Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{String.class, int[][].class});
        new EqualsTester().addEqualityGroup(new Object[]{jvmType, ourType}).addEqualityGroup(new Object[]{new TypeCapture<Map.Entry<String, String>>(){}.capture()}).addEqualityGroup(new Object[]{new TypeCapture<Map<String, Integer>>(){}.capture()}).testEquals();
        TypesTest.assertEquals((String)jvmType.toString(), (String)ourType.toString());
        TypesTest.assertEquals(Map.class, (Object)ourType.getOwnerType());
        TypesTest.assertEquals(Map.Entry.class, (Object)ourType.getRawType());
        Truth.assertThat((Object[])ourType.getActualTypeArguments()).asList().has().exactlyAs(Arrays.asList(jvmType.getActualTypeArguments())).inOrder();
    }

    public void testNewParameterizedType_serializable() {
        SerializableTester.reserializeAndAssert((Object)Types.newParameterizedType(Map.Entry.class, (Type[])new Type[]{String.class, Integer.class}));
    }

    public void testNewParameterizedType_ownerMismatch() {
        try {
            Types.newParameterizedTypeWithOwner(Number.class, List.class, (Type[])new Type[]{String.class});
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewParameterizedType_ownerMissing() {
        TypesTest.assertEquals((Object)Types.newParameterizedType(Map.Entry.class, (Type[])new Type[]{String.class, Integer.class}), (Object)Types.newParameterizedTypeWithOwner(null, Map.Entry.class, (Type[])new Type[]{String.class, Integer.class}));
    }

    public void testNewParameterizedType_invalidTypeParameters() {
        try {
            Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{String.class});
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewParameterizedType_primitiveTypeParameters() {
        try {
            Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{Integer.TYPE, Integer.TYPE});
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewArrayType() {
        Type jvmType1 = new TypeCapture<List<String>[]>(){}.capture();
        GenericArrayType ourType1 = (GenericArrayType)Types.newArrayType((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{String.class}));
        Type jvmType2 = new TypeCapture<List[]>(){}.capture();
        Type ourType2 = Types.newArrayType(List.class);
        new EqualsTester().addEqualityGroup(new Object[]{jvmType1, ourType1}).addEqualityGroup(new Object[]{jvmType2, ourType2}).testEquals();
        TypesTest.assertEquals((Object)new TypeCapture<List<String>>(){}.capture(), (Object)ourType1.getGenericComponentType());
        TypesTest.assertEquals((String)jvmType1.toString(), (String)ourType1.toString());
        TypesTest.assertEquals((String)jvmType2.toString(), (String)ourType2.toString());
    }

    public void testNewArrayTypeOfArray() {
        Type jvmType = new TypeCapture<int[][]>(){}.capture();
        Type ourType = Types.newArrayType(int[].class);
        TypesTest.assertEquals((String)jvmType.toString(), (String)ourType.toString());
        new EqualsTester().addEqualityGroup(new Object[]{jvmType, ourType}).testEquals();
    }

    public void testNewArrayType_primitive() {
        Type jvmType = new TypeCapture<int[]>(){}.capture();
        Type ourType = Types.newArrayType(Integer.TYPE);
        TypesTest.assertEquals((String)jvmType.toString(), (String)ourType.toString());
        new EqualsTester().addEqualityGroup(new Object[]{jvmType, ourType}).testEquals();
    }

    public void testNewArrayType_upperBoundedWildcard() {
        WildcardType wildcard = Types.subtypeOf(Number.class);
        TypesTest.assertEquals((Object)Types.subtypeOf(Number[].class), (Object)Types.newArrayType((Type)wildcard));
    }

    public void testNewArrayType_lowerBoundedWildcard() {
        WildcardType wildcard = Types.supertypeOf(Number.class);
        TypesTest.assertEquals((Object)Types.supertypeOf(Number[].class), (Object)Types.newArrayType((Type)wildcard));
    }

    public void testNewArrayType_serializable() {
        SerializableTester.reserializeAndAssert((Object)Types.newArrayType(int[].class));
    }

    public void testNewWildcardType() throws Exception {
        WildcardType noBoundJvmType = WithWildcardType.getWildcardType("withoutBound");
        WildcardType objectBoundJvmType = WithWildcardType.getWildcardType("withObjectBound");
        WildcardType upperBoundJvmType = WithWildcardType.getWildcardType("withUpperBound");
        WildcardType lowerBoundJvmType = WithWildcardType.getWildcardType("withLowerBound");
        WildcardType objectBound = Types.subtypeOf(Object.class);
        WildcardType upperBound = Types.subtypeOf(int[][].class);
        WildcardType lowerBound = Types.supertypeOf(String[][].class);
        TypesTest.assertEqualWildcardType(noBoundJvmType, objectBound);
        TypesTest.assertEqualWildcardType(objectBoundJvmType, objectBound);
        TypesTest.assertEqualWildcardType(upperBoundJvmType, upperBound);
        TypesTest.assertEqualWildcardType(lowerBoundJvmType, lowerBound);
        new EqualsTester().addEqualityGroup(new Object[]{noBoundJvmType, objectBoundJvmType, objectBound}).addEqualityGroup(new Object[]{upperBoundJvmType, upperBound}).addEqualityGroup(new Object[]{lowerBoundJvmType, lowerBound}).testEquals();
    }

    public void testNewWildcardType_primitiveTypeBound() {
        try {
            Types.subtypeOf(Integer.TYPE);
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewWildcardType_serializable() {
        SerializableTester.reserializeAndAssert((Object)Types.supertypeOf(String.class));
        SerializableTester.reserializeAndAssert((Object)Types.subtypeOf(String.class));
        SerializableTester.reserializeAndAssert((Object)Types.subtypeOf(Object.class));
    }

    private static void assertEqualWildcardType(WildcardType expected, WildcardType actual) {
        TypesTest.assertEquals((String)expected.toString(), (String)actual.toString());
        TypesTest.assertEquals((String)actual.toString(), (int)expected.hashCode(), (int)actual.hashCode());
        Truth.assertThat((Object[])actual.getLowerBounds()).asList().has().exactlyAs(Arrays.asList(expected.getLowerBounds())).inOrder();
        Truth.assertThat((Object[])actual.getUpperBounds()).asList().has().exactlyAs(Arrays.asList(expected.getUpperBounds())).inOrder();
    }

    public void testNewTypeVariable() throws Exception {
        TypeVariable<?> noBoundJvmType = WithTypeVariable.getTypeVariable("withoutBound");
        TypeVariable<?> objectBoundJvmType = WithTypeVariable.getTypeVariable("withObjectBound");
        TypeVariable<?> upperBoundJvmType = WithTypeVariable.getTypeVariable("withUpperBound");
        TypeVariable<?> noBound = TypesTest.withBounds(noBoundJvmType, new Type[0]);
        TypeVariable<?> objectBound = TypesTest.withBounds(objectBoundJvmType, new Type[]{Object.class});
        TypeVariable<?> upperBound = TypesTest.withBounds(upperBoundJvmType, new Type[]{Number.class, CharSequence.class});
        TypesTest.assertEqualTypeVariable(noBoundJvmType, noBound);
        TypesTest.assertEqualTypeVariable(noBoundJvmType, TypesTest.withBounds(noBoundJvmType, new Type[]{Object.class}));
        TypesTest.assertEqualTypeVariable(objectBoundJvmType, objectBound);
        TypesTest.assertEqualTypeVariable(upperBoundJvmType, upperBound);
        new TypeVariableEqualsTester().addEqualityGroup(noBoundJvmType, noBound).addEqualityGroup(objectBoundJvmType, objectBound).addEqualityGroup(upperBoundJvmType, upperBound).testEquals();
    }

    public void testNewTypeVariable_primitiveTypeBound() {
        try {
            Types.newArtificialTypeVariable(List.class, (String)"E", (Type[])new Type[]{Integer.TYPE});
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewTypeVariable_serializable() throws Exception {
        try {
            SerializableTester.reserialize((Object)Types.newArtificialTypeVariable(List.class, (String)"E", (Type[])new Type[0]));
            TypesTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static <D extends GenericDeclaration> TypeVariable<D> withBounds(TypeVariable<D> typeVariable, Type ... bounds) {
        return Types.newArtificialTypeVariable(typeVariable.getGenericDeclaration(), (String)typeVariable.getName(), (Type[])bounds);
    }

    private static void assertEqualTypeVariable(TypeVariable<?> expected, TypeVariable<?> actual) {
        TypesTest.assertEquals((String)expected.toString(), (String)actual.toString());
        TypesTest.assertEquals((String)expected.getName(), (String)actual.getName());
        TypesTest.assertEquals(expected.getGenericDeclaration(), actual.getGenericDeclaration());
        if (!Types.NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY) {
            TypesTest.assertEquals((String)actual.toString(), (int)expected.hashCode(), (int)actual.hashCode());
        }
        Truth.assertThat((Object[])actual.getBounds()).asList().has().exactlyAs(Arrays.asList(expected.getBounds())).inOrder();
    }

    public void testNewParameterizedTypeImmutability() {
        Type[] typesIn = new Type[]{String.class, Integer.class};
        ParameterizedType parameterizedType = Types.newParameterizedType(Map.class, (Type[])typesIn);
        typesIn[0] = null;
        typesIn[1] = null;
        Type[] typesOut = parameterizedType.getActualTypeArguments();
        typesOut[0] = null;
        typesOut[1] = null;
        TypesTest.assertEquals(String.class, (Object)parameterizedType.getActualTypeArguments()[0]);
        TypesTest.assertEquals(Integer.class, (Object)parameterizedType.getActualTypeArguments()[1]);
    }

    public void testNewParameterizedTypeWithWrongNumberOfTypeArguments() {
        try {
            Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Integer.class, Long.class});
            TypesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        TypesTest.assertEquals((String)int[].class.getName(), (String)Types.toString(int[].class));
        TypesTest.assertEquals((String)int[][].class.getName(), (String)Types.toString(int[][].class));
        TypesTest.assertEquals((String)String[].class.getName(), (String)Types.toString(String[].class));
        TypeVariable elementType = List.class.getTypeParameters()[0];
        TypesTest.assertEquals((String)elementType.toString(), (String)Types.toString(elementType));
    }

    public void testNullPointers() {
        new NullPointerTester().testStaticMethods(Types.class, NullPointerTester.Visibility.PACKAGE);
    }

    private static class TypeVariableEqualsTester {
        private final EqualsTester tester = new EqualsTester();

        private TypeVariableEqualsTester() {
        }

        TypeVariableEqualsTester addEqualityGroup(Type jvmType, Type ... types) {
            if (Types.NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY) {
                this.tester.addEqualityGroup(new Object[]{jvmType});
                this.tester.addEqualityGroup((Object[])types);
            } else {
                this.tester.addEqualityGroup(Lists.asList((Object)jvmType, (Object[])types).toArray());
            }
            return this;
        }

        void testEquals() {
            this.tester.testEquals();
        }
    }

    private static class WithTypeVariable {
        private WithTypeVariable() {
        }

        <T> void withoutBound(List<T> list) {
        }

        <T> void withObjectBound(List<T> list) {
        }

        <T extends Number> void withUpperBound(List<T> list) {
        }

        static TypeVariable<?> getTypeVariable(String methodName) throws Exception {
            ParameterizedType parameterType = (ParameterizedType)WithTypeVariable.class.getDeclaredMethod(methodName, List.class).getGenericParameterTypes()[0];
            return (TypeVariable)parameterType.getActualTypeArguments()[0];
        }
    }

    private static class WithWildcardType {
        private WithWildcardType() {
        }

        void withoutBound(List<?> list) {
        }

        void withObjectBound(List<? extends Object> list) {
        }

        void withUpperBound(List<? extends int[][]> list) {
        }

        void withLowerBound(List<? super String[][]> list) {
        }

        static WildcardType getWildcardType(String methodName) throws Exception {
            ParameterizedType parameterType = (ParameterizedType)WithWildcardType.class.getDeclaredMethod(methodName, List.class).getGenericParameterTypes()[0];
            return (WildcardType)parameterType.getActualTypeArguments()[0];
        }
    }
}

