/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.testing.ClassSanityTester;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.JSR166TestCase;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MoreExecutorsTest
extends JSR166TestCase {
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final long HALF_SECOND_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS) / 2L;

    public void testDirectExecutorServiceServiceInThreadExecution() throws Exception {
        final ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        final ThreadLocal<Integer> threadLocalCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        final AtomicReference<Object> throwableFromOtherThread = new AtomicReference<Object>(null);
        final Runnable incrementTask = new Runnable(){

            @Override
            public void run() {
                threadLocalCount.set((Integer)threadLocalCount.get() + 1);
            }
        };
        Thread otherThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenableFuture future = executor.submit(incrementTask);
                    Assert.assertTrue((boolean)future.isDone());
                    Assert.assertEquals((int)1, (int)((Integer)threadLocalCount.get()));
                }
                catch (Throwable t) {
                    throwableFromOtherThread.set(t);
                }
            }
        });
        otherThread.start();
        ListenableFuture future = executor.submit(incrementTask);
        MoreExecutorsTest.assertTrue((boolean)future.isDone());
        MoreExecutorsTest.assertListenerRunImmediately(future);
        MoreExecutorsTest.assertEquals((int)1, (int)((Integer)threadLocalCount.get()));
        otherThread.join(1000L);
        MoreExecutorsTest.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)otherThread.getState()));
        Throwable throwable = throwableFromOtherThread.get();
        String string = String.valueOf(throwable == null ? null : Throwables.getStackTraceAsString((Throwable)throwable));
        MoreExecutorsTest.assertNull((String)(string.length() != 0 ? "Throwable from other thread: ".concat(string) : new String("Throwable from other thread: ")), throwableFromOtherThread.get());
    }

    public void testDirectExecutorServiceInvokeAll() throws Exception {
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        final ThreadLocal<Integer> threadLocalCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        Callable<Integer> incrementTask = new Callable<Integer>(){

            @Override
            public Integer call() {
                int i = (Integer)threadLocalCount.get();
                threadLocalCount.set(i + 1);
                return i;
            }
        };
        List futures = executor.invokeAll(Collections.nCopies(10, incrementTask));
        for (int i = 0; i < 10; ++i) {
            Future future = futures.get(i);
            MoreExecutorsTest.assertTrue((String)"Task should have been run before being returned", (boolean)future.isDone());
            MoreExecutorsTest.assertEquals((int)i, (int)((Integer)future.get()));
        }
        MoreExecutorsTest.assertEquals((int)10, (int)((Integer)threadLocalCount.get()));
    }

    public void testDirectExecutorServiceServiceTermination() throws Exception {
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        CyclicBarrier barrier = new CyclicBarrier(2);
        AtomicReference<Object> throwableFromOtherThread = new AtomicReference<Object>(null);
        Runnable doNothingRunnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        Thread otherThread = new Thread(new Runnable((ExecutorService)executor, barrier, throwableFromOtherThread){
            final /* synthetic */ ExecutorService val$executor;
            final /* synthetic */ CyclicBarrier val$barrier;
            final /* synthetic */ AtomicReference val$throwableFromOtherThread;
            {
                this.val$executor = executorService;
                this.val$barrier = cyclicBarrier;
                this.val$throwableFromOtherThread = atomicReference;
            }

            @Override
            public void run() {
                try {
                    Future<Void> future = this.val$executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            val$barrier.await(1L, TimeUnit.SECONDS);
                            val$barrier.await(1L, TimeUnit.SECONDS);
                            Assert.assertTrue((boolean)val$executor.isShutdown());
                            Assert.assertFalse((boolean)val$executor.isTerminated());
                            val$barrier.await(1L, TimeUnit.SECONDS);
                            return null;
                        }
                    });
                    Assert.assertTrue((boolean)future.isDone());
                    Assert.assertTrue((boolean)this.val$executor.isShutdown());
                    Assert.assertTrue((boolean)this.val$executor.isTerminated());
                }
                catch (Throwable t) {
                    this.val$throwableFromOtherThread.set(t);
                }
            }
        });
        otherThread.start();
        barrier.await(1L, TimeUnit.SECONDS);
        MoreExecutorsTest.assertFalse((boolean)executor.isShutdown());
        MoreExecutorsTest.assertFalse((boolean)executor.isTerminated());
        executor.shutdown();
        MoreExecutorsTest.assertTrue((boolean)executor.isShutdown());
        try {
            executor.submit(doNothingRunnable);
            MoreExecutorsTest.fail((String)"Should have encountered RejectedExecutionException");
        }
        catch (RejectedExecutionException ex) {
            // empty catch block
        }
        MoreExecutorsTest.assertFalse((boolean)executor.isTerminated());
        barrier.await(1L, TimeUnit.SECONDS);
        MoreExecutorsTest.assertFalse((boolean)executor.awaitTermination(20L, TimeUnit.MILLISECONDS));
        barrier.await(1L, TimeUnit.SECONDS);
        MoreExecutorsTest.assertTrue((boolean)executor.awaitTermination(1L, TimeUnit.SECONDS));
        MoreExecutorsTest.assertTrue((boolean)executor.awaitTermination(0L, TimeUnit.SECONDS));
        MoreExecutorsTest.assertTrue((boolean)executor.isShutdown());
        try {
            executor.submit(doNothingRunnable);
            MoreExecutorsTest.fail((String)"Should have encountered RejectedExecutionException");
        }
        catch (RejectedExecutionException ex) {
            // empty catch block
        }
        MoreExecutorsTest.assertTrue((boolean)executor.isTerminated());
        otherThread.join(1000L);
        MoreExecutorsTest.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)otherThread.getState()));
        Throwable throwable = throwableFromOtherThread.get();
        String string = String.valueOf(throwable == null ? null : Throwables.getStackTraceAsString((Throwable)throwable));
        MoreExecutorsTest.assertNull((String)(string.length() != 0 ? "Throwable from other thread: ".concat(string) : new String("Throwable from other thread: ")), throwableFromOtherThread.get());
    }

    public void testDirectExecutorService_shutdownNow() {
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        MoreExecutorsTest.assertEquals((Object)ImmutableList.of(), executor.shutdownNow());
        MoreExecutorsTest.assertTrue((boolean)executor.isShutdown());
    }

    public void testExecuteAfterShutdown() {
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        executor.shutdown();
        try {
            executor.execute(EMPTY_RUNNABLE);
            MoreExecutorsTest.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public <T> void testListeningExecutorServiceInvokeAllJavadocCodeCompiles() throws Exception {
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        ImmutableList tasks = ImmutableList.of();
        List futures = executor.invokeAll((Collection)tasks);
    }

    public void testListeningDecorator() throws Exception {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.newDirectExecutorService());
        MoreExecutorsTest.assertSame((Object)service, (Object)MoreExecutors.listeningDecorator((ExecutorService)service));
        ImmutableList callables = ImmutableList.of((Object)Callables.returning((Object)"x"));
        List results = service.invokeAll((Collection)callables);
        Truth.assertThat((Object)Iterables.getOnlyElement((Iterable)results)).isA(ListenableFutureTask.class);
        results = service.invokeAll((Collection)callables, 1L, TimeUnit.SECONDS);
        Truth.assertThat((Object)Iterables.getOnlyElement((Iterable)results)).isA(ListenableFutureTask.class);
    }

    public void testListeningDecorator_noWrapExecuteTask() {
        ExecutorService delegate = (ExecutorService)Mockito.mock(ExecutorService.class);
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)delegate);
        Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        service.execute(task);
        ((ExecutorService)Mockito.verify((Object)delegate)).execute(task);
    }

    public void testListeningDecorator_scheduleSuccess() throws Exception {
        final CountDownLatch completed = new CountDownLatch(1);
        ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                completed.countDown();
            }
        };
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)delegate);
        ListenableScheduledFuture future = service.schedule(Callables.returning(null), 1L, TimeUnit.MILLISECONDS);
        completed.await();
        MoreExecutorsTest.assertTrue((boolean)future.isDone());
        MoreExecutorsTest.assertListenerRunImmediately(future);
        MoreExecutorsTest.assertEquals((int)0, (int)delegate.getQueue().size());
    }

    public void testListeningDecorator_scheduleFailure() throws Exception {
        ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(1);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)delegate);
        RuntimeException ex = new RuntimeException();
        ListenableScheduledFuture future = service.schedule((Runnable)new ThrowingRunnable(0, ex), 1L, TimeUnit.MILLISECONDS);
        MoreExecutorsTest.assertExecutionException(future, ex);
        MoreExecutorsTest.assertEquals((int)0, (int)delegate.getQueue().size());
    }

    public void testListeningDecorator_schedulePeriodic() throws Exception {
        ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(1);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)delegate);
        RuntimeException ex = new RuntimeException();
        ThrowingRunnable runnable = new ThrowingRunnable(5, ex);
        ListenableScheduledFuture future = service.scheduleAtFixedRate((Runnable)runnable, 1L, 1L, TimeUnit.MILLISECONDS);
        MoreExecutorsTest.assertExecutionException(future, ex);
        MoreExecutorsTest.assertEquals((int)5, (int)runnable.count);
        MoreExecutorsTest.assertEquals((int)0, (int)delegate.getQueue().size());
        runnable = new ThrowingRunnable(5, ex);
        future = service.scheduleWithFixedDelay((Runnable)runnable, 1L, 1L, TimeUnit.MILLISECONDS);
        MoreExecutorsTest.assertExecutionException(future, ex);
        MoreExecutorsTest.assertEquals((int)5, (int)runnable.count);
        MoreExecutorsTest.assertEquals((int)0, (int)delegate.getQueue().size());
    }

    public void testListeningDecorator_cancelled() throws Exception {
        ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(1);
        BlockingQueue<Runnable> delegateQueue = delegate.getQueue();
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)delegate);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        ListenableScheduledFuture future = service.schedule(runnable, 5L, TimeUnit.MINUTES);
        future.cancel(true);
        MoreExecutorsTest.assertTrue((boolean)future.isCancelled());
        ScheduledFuture delegateFuture = (ScheduledFuture)delegateQueue.element();
        MoreExecutorsTest.assertTrue((boolean)delegateFuture.isCancelled());
        delegateQueue.clear();
        future = service.scheduleAtFixedRate(runnable, 5L, 5L, TimeUnit.MINUTES);
        future.cancel(true);
        MoreExecutorsTest.assertTrue((boolean)future.isCancelled());
        delegateFuture = (ScheduledFuture)delegateQueue.element();
        MoreExecutorsTest.assertTrue((boolean)delegateFuture.isCancelled());
        delegateQueue.clear();
        future = service.scheduleWithFixedDelay(runnable, 5L, 5L, TimeUnit.MINUTES);
        future.cancel(true);
        MoreExecutorsTest.assertTrue((boolean)future.isCancelled());
        delegateFuture = (ScheduledFuture)delegateQueue.element();
        MoreExecutorsTest.assertTrue((boolean)delegateFuture.isCancelled());
    }

    private static void assertExecutionException(Future<?> future, Exception expectedCause) throws Exception {
        try {
            future.get();
            MoreExecutorsTest.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException e) {
            MoreExecutorsTest.assertSame((Object)expectedCause, (Object)e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAnyImpl_nullTasks() throws Exception {
        ListeningExecutorService e = MoreExecutors.newDirectExecutorService();
        try {
            MoreExecutors.invokeAnyImpl((ListeningExecutorService)e, null, (boolean)false, (long)0L);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool((ExecutorService)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAnyImpl_emptyTasks() throws Exception {
        ListeningExecutorService e = MoreExecutors.newDirectExecutorService();
        try {
            MoreExecutors.invokeAnyImpl((ListeningExecutorService)e, new ArrayList(), (boolean)false, (long)0L);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool((ExecutorService)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAnyImpl_nullElement() throws Exception {
        ListeningExecutorService e = MoreExecutors.newDirectExecutorService();
        ArrayList<12> l = new ArrayList<12>();
        l.add(new Callable<Integer>(){

            @Override
            public Integer call() {
                throw new ArithmeticException("/ by zero");
            }
        });
        l.add(null);
        try {
            MoreExecutors.invokeAnyImpl((ListeningExecutorService)e, l, (boolean)false, (long)0L);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool((ExecutorService)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAnyImpl_noTaskCompletes() throws Exception {
        ListeningExecutorService e = MoreExecutors.newDirectExecutorService();
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            MoreExecutors.invokeAnyImpl((ListeningExecutorService)e, l, (boolean)false, (long)0L);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            MoreExecutorsTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool((ExecutorService)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAnyImpl() throws Exception {
        ListeningExecutorService e = MoreExecutors.newDirectExecutorService();
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)MoreExecutors.invokeAnyImpl((ListeningExecutorService)e, l, (boolean)false, (long)0L);
            MoreExecutorsTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool((ExecutorService)e);
        }
    }

    private static void assertListenerRunImmediately(ListenableFuture<?> future) {
        CountingRunnable listener = new CountingRunnable();
        future.addListener((Runnable)listener, MoreExecutors.directExecutor());
        MoreExecutorsTest.assertEquals((int)1, (int)listener.count);
    }

    public void testAddDelayedShutdownHook_success() throws InterruptedException {
        TestApplication application = new TestApplication();
        ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        application.addDelayedShutdownHook(service, 2L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)service, (VerificationMode)Mockito.never())).shutdown();
        application.shutdown();
        InOrder shutdownFirst = Mockito.inOrder((Object[])new Object[]{service});
        ((ExecutorService)shutdownFirst.verify((Object)service)).shutdown();
        ((ExecutorService)shutdownFirst.verify((Object)service)).awaitTermination(2L, TimeUnit.SECONDS);
    }

    public void testAddDelayedShutdownHook_interrupted() throws InterruptedException {
        TestApplication application = new TestApplication();
        ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        application.addDelayedShutdownHook(service, 2L, TimeUnit.SECONDS);
        Mockito.when((Object)service.awaitTermination(2L, TimeUnit.SECONDS)).thenThrow(new Throwable[]{new InterruptedException()});
        application.shutdown();
        ((ExecutorService)Mockito.verify((Object)service)).shutdown();
    }

    public void testGetExitingExcutorService_executorSetToUseDaemonThreads() {
        TestApplication application = new TestApplication();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 2, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1));
        MoreExecutorsTest.assertNotNull((Object)application.getExitingExecutorService(executor));
        MoreExecutorsTest.assertTrue((boolean)executor.getThreadFactory().newThread(EMPTY_RUNNABLE).isDaemon());
    }

    public void testGetExitingExcutorService_executorDelegatesToOriginal() {
        TestApplication application = new TestApplication();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ThreadFactory threadFactory = (ThreadFactory)Mockito.mock(ThreadFactory.class);
        Mockito.when((Object)executor.getThreadFactory()).thenReturn((Object)threadFactory);
        application.getExitingExecutorService(executor).execute(EMPTY_RUNNABLE);
        ((ThreadPoolExecutor)Mockito.verify((Object)executor)).execute(EMPTY_RUNNABLE);
    }

    public void testGetExitingExcutorService_shutdownHookRegistered() throws InterruptedException {
        TestApplication application = new TestApplication();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        ThreadFactory threadFactory = (ThreadFactory)Mockito.mock(ThreadFactory.class);
        Mockito.when((Object)executor.getThreadFactory()).thenReturn((Object)threadFactory);
        application.getExitingExecutorService(executor);
        application.shutdown();
        ((ThreadPoolExecutor)Mockito.verify((Object)executor)).shutdown();
    }

    public void testGetExitingScheduledExcutorService_executorSetToUseDaemonThreads() {
        TestApplication application = new TestApplication();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        MoreExecutorsTest.assertNotNull((Object)application.getExitingScheduledExecutorService(executor));
        MoreExecutorsTest.assertTrue((boolean)executor.getThreadFactory().newThread(EMPTY_RUNNABLE).isDaemon());
    }

    public void testGetExitingScheduledExcutorService_executorDelegatesToOriginal() {
        TestApplication application = new TestApplication();
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class);
        ThreadFactory threadFactory = (ThreadFactory)Mockito.mock(ThreadFactory.class);
        Mockito.when((Object)executor.getThreadFactory()).thenReturn((Object)threadFactory);
        application.getExitingScheduledExecutorService(executor).execute(EMPTY_RUNNABLE);
        ((ScheduledThreadPoolExecutor)Mockito.verify((Object)executor)).execute(EMPTY_RUNNABLE);
    }

    public void testGetScheduledExitingExcutorService_shutdownHookRegistered() throws InterruptedException {
        TestApplication application = new TestApplication();
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class);
        ThreadFactory threadFactory = (ThreadFactory)Mockito.mock(ThreadFactory.class);
        Mockito.when((Object)executor.getThreadFactory()).thenReturn((Object)threadFactory);
        application.getExitingScheduledExecutorService(executor);
        application.shutdown();
        ((ScheduledThreadPoolExecutor)Mockito.verify((Object)executor)).shutdown();
    }

    public void testPlatformThreadFactory_default() {
        ThreadFactory factory = MoreExecutors.platformThreadFactory();
        MoreExecutorsTest.assertNotNull((Object)factory);
        MoreExecutorsTest.assertEquals(factory.getClass(), Executors.defaultThreadFactory().getClass());
    }

    public void testThreadRenaming() {
        ExecutorService renamingExecutor = MoreExecutors.renamingDecorator((ExecutorService)MoreExecutors.newDirectExecutorService(), (Supplier)Suppliers.ofInstance((Object)"FooBar"));
        String oldName = Thread.currentThread().getName();
        renamingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((String)"FooBar", (String)Thread.currentThread().getName());
            }
        });
        MoreExecutorsTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
    }

    public void testExecutors_nullCheck() throws Exception {
        new ClassSanityTester().setDefault(RateLimiter.class, (Object)RateLimiter.create((double)1.0)).forAllPublicStaticMethods(MoreExecutors.class).thatReturn(Executor.class).testNulls();
    }

    public void testShutdownAndAwaitTermination_immediateShutdown() throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MoreExecutorsTest.assertTrue((boolean)MoreExecutors.shutdownAndAwaitTermination((ExecutorService)service, (long)1L, (TimeUnit)TimeUnit.SECONDS));
        MoreExecutorsTest.assertTrue((boolean)service.isTerminated());
    }

    public void testShutdownAndAwaitTermination_immediateShutdownInternal() throws Exception {
        ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)service.awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS)).thenReturn((Object)true);
        Mockito.when((Object)service.isTerminated()).thenReturn((Object)true);
        MoreExecutorsTest.assertTrue((boolean)MoreExecutors.shutdownAndAwaitTermination((ExecutorService)service, (long)1L, (TimeUnit)TimeUnit.SECONDS));
        ((ExecutorService)Mockito.verify((Object)service)).shutdown();
        ((ExecutorService)Mockito.verify((Object)service)).awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS);
    }

    public void testShutdownAndAwaitTermination_forcedShutDownInternal() throws Exception {
        ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)service.awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS)).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)service.isTerminated()).thenReturn((Object)true);
        MoreExecutorsTest.assertTrue((boolean)MoreExecutors.shutdownAndAwaitTermination((ExecutorService)service, (long)1L, (TimeUnit)TimeUnit.SECONDS));
        ((ExecutorService)Mockito.verify((Object)service)).shutdown();
        ((ExecutorService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)2))).awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS);
        ((ExecutorService)Mockito.verify((Object)service)).shutdownNow();
    }

    public void testShutdownAndAwaitTermination_nonTerminationInternal() throws Exception {
        ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)service.awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS)).thenReturn((Object)false).thenReturn((Object)false);
        MoreExecutorsTest.assertFalse((boolean)MoreExecutors.shutdownAndAwaitTermination((ExecutorService)service, (long)1L, (TimeUnit)TimeUnit.SECONDS));
        ((ExecutorService)Mockito.verify((Object)service)).shutdown();
        ((ExecutorService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)2))).awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS);
        ((ExecutorService)Mockito.verify((Object)service)).shutdownNow();
    }

    public void testShutdownAndAwaitTermination_interruptedInternal() throws Exception {
        final ExecutorService service = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)service.awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS)).thenThrow(new Throwable[]{new InterruptedException()});
        final AtomicBoolean terminated = new AtomicBoolean();
        final AtomicBoolean interrupted = new AtomicBoolean();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                terminated.set(MoreExecutors.shutdownAndAwaitTermination((ExecutorService)service, (long)1L, (TimeUnit)TimeUnit.SECONDS));
                interrupted.set(Thread.currentThread().isInterrupted());
            }
        });
        thread.start();
        thread.join();
        ((ExecutorService)Mockito.verify((Object)service)).shutdown();
        ((ExecutorService)Mockito.verify((Object)service)).awaitTermination(HALF_SECOND_NANOS, TimeUnit.NANOSECONDS);
        ((ExecutorService)Mockito.verify((Object)service)).shutdownNow();
        MoreExecutorsTest.assertTrue((boolean)interrupted.get());
        MoreExecutorsTest.assertFalse((boolean)terminated.get());
    }

    private static class TestApplication
    extends MoreExecutors.Application {
        private final List<Thread> hooks = Lists.newArrayList();

        private TestApplication() {
        }

        synchronized void addShutdownHook(Thread hook) {
            this.hooks.add(hook);
        }

        synchronized void shutdown() throws InterruptedException {
            for (Thread hook : this.hooks) {
                hook.start();
            }
            for (Thread hook : this.hooks) {
                hook.join();
            }
        }
    }

    private static final class CountingRunnable
    implements Runnable {
        int count;

        private CountingRunnable() {
        }

        @Override
        public void run() {
            ++this.count;
        }
    }

    private static final class ThrowingRunnable
    implements Runnable {
        final int throwAfterCount;
        final RuntimeException thrown;
        int count;

        ThrowingRunnable(int throwAfterCount, RuntimeException thrown) {
            this.throwAfterCount = throwAfterCount;
            this.thrown = thrown;
        }

        @Override
        public void run() {
            if (++this.count >= this.throwAfterCount) {
                throw this.thrown;
            }
        }
    }
}

