/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.testing.TearDown;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public final class TestThread<L>
extends Thread
implements TearDown {
    private static final long DUE_DILIGENCE_MILLIS = 50L;
    private static final long TIMEOUT_MILLIS = 5000L;
    private final L lockLikeObject;
    private final SynchronousQueue<Request> requestQueue = new SynchronousQueue();
    private final SynchronousQueue<Response> responseQueue = new SynchronousQueue();
    private Throwable uncaughtThrowable = null;

    public TestThread(L lockLikeObject, String threadName) {
        super(threadName);
        this.lockLikeObject = Preconditions.checkNotNull(lockLikeObject);
        this.start();
    }

    public void tearDown() throws Exception {
        this.stop();
        this.join();
        if (this.uncaughtThrowable != null) {
            String string = String.valueOf(this.getName());
            throw (AssertionFailedError)new AssertionFailedError(string.length() != 0 ? "Uncaught throwable in ".concat(string) : new String("Uncaught throwable in ")).initCause(this.uncaughtThrowable);
        }
    }

    public void callAndAssertReturns(String methodName, Object ... arguments) throws Exception {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)arguments);
        this.sendRequest(methodName, arguments);
        Assert.assertSame(null, (Object)this.getResponse(methodName).getResult());
    }

    public void callAndAssertReturns(boolean expected, String methodName, Object ... arguments) throws Exception {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)arguments);
        this.sendRequest(methodName, arguments);
        Assert.assertEquals((Object)expected, (Object)this.getResponse(methodName).getResult());
    }

    public void callAndAssertReturns(int expected, String methodName, Object ... arguments) throws Exception {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)arguments);
        this.sendRequest(methodName, arguments);
        Assert.assertEquals((Object)expected, (Object)this.getResponse(methodName).getResult());
    }

    public void callAndAssertThrows(Class<? extends Throwable> expected, String methodName, Object ... arguments) throws Exception {
        Preconditions.checkNotNull(expected);
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)arguments);
        this.sendRequest(methodName, arguments);
        Assert.assertEquals(expected, this.getResponse(methodName).getThrowable().getClass());
    }

    public void callAndAssertBlocks(String methodName, Object ... arguments) throws Exception {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)arguments);
        Assert.assertEquals((Object)false, (Object)this.invokeMethod("hasQueuedThread", this));
        this.sendRequest(methodName, arguments);
        Thread.sleep(50L);
        Assert.assertEquals((Object)true, (Object)this.invokeMethod("hasQueuedThread", this));
        Assert.assertNull((Object)this.responseQueue.poll());
    }

    public void callAndAssertWaits(String methodName, Object conditionLikeObject) throws Exception {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)conditionLikeObject);
        this.sendRequest(methodName, conditionLikeObject);
        Thread.sleep(50L);
        Assert.assertEquals((Object)true, (Object)this.invokeMethod("hasWaiters", conditionLikeObject));
        Assert.assertNull((Object)this.responseQueue.poll());
    }

    public void assertPriorCallReturns(@Nullable String methodName) throws Exception {
        Assert.assertEquals(null, (Object)this.getResponse(methodName).getResult());
    }

    public void assertPriorCallReturns(boolean expected, @Nullable String methodName) throws Exception {
        Assert.assertEquals((Object)expected, (Object)this.getResponse(methodName).getResult());
    }

    private void sendRequest(String methodName, Object ... arguments) throws Exception {
        if (!this.requestQueue.offer(new Request(methodName, arguments), 5000L, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
    }

    private Response getResponse(String methodName) throws Exception {
        Response response = this.responseQueue.poll(5000L, TimeUnit.MILLISECONDS);
        if (response == null) {
            throw new TimeoutException();
        }
        Assert.assertEquals((String)methodName, (String)response.methodName);
        return response;
    }

    private Object invokeMethod(String methodName, Object ... arguments) throws Exception {
        return this.getMethod(methodName, arguments).invoke(this.lockLikeObject, arguments);
    }

    private Method getMethod(String methodName, Object ... arguments) throws Exception {
        block0: for (Method method : this.lockLikeObject.getClass().getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || parameterTypes.length != arguments.length) continue;
            for (int i = 0; i < arguments.length; ++i) {
                if (!parameterTypes[i].isAssignableFrom(arguments[i].getClass())) continue block0;
            }
            return method;
        }
        throw new NoSuchMethodError(methodName);
    }

    @Override
    public void run() {
        Assert.assertSame((Object)this, (Object)Thread.currentThread());
        try {
            while (true) {
                Object result;
                Request request = this.requestQueue.take();
                try {
                    result = this.invokeMethod(request.methodName, request.arguments);
                }
                catch (ThreadDeath death) {
                    return;
                }
                catch (InvocationTargetException exception) {
                    this.responseQueue.put(new Response(request.methodName, null, exception.getTargetException()));
                    continue;
                }
                catch (Throwable throwable) {
                    this.responseQueue.put(new Response(request.methodName, null, throwable));
                    continue;
                }
                this.responseQueue.put(new Response(request.methodName, result, null));
            }
        }
        catch (ThreadDeath death) {
            return;
        }
        catch (InterruptedException ignored) {
        }
        catch (Throwable uncaught) {
            this.uncaughtThrowable = uncaught;
        }
    }

    private static class Response {
        final String methodName;
        final Object result;
        final Throwable throwable;

        Response(String methodName, Object result, Throwable throwable) {
            this.methodName = methodName;
            this.result = result;
            this.throwable = throwable;
        }

        Object getResult() {
            if (this.throwable != null) {
                throw (AssertionFailedError)new AssertionFailedError().initCause(this.throwable);
            }
            return this.result;
        }

        Throwable getThrowable() {
            Assert.assertNotNull((Object)this.throwable);
            return this.throwable;
        }
    }

    private static class Request {
        final String methodName;
        final Object[] arguments;

        Request(String methodName, Object[] arguments) {
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
            this.arguments = (Object[])Preconditions.checkNotNull((Object)arguments);
        }
    }
}

