/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Strings;

public class StringsRepeatBenchmark {
    @Param(value={"1", "5", "25", "125"})
    int count;
    @Param(value={"1", "10"})
    int length;
    private String originalString;

    @BeforeExperiment
    void setUp() {
        this.originalString = Strings.repeat((String)"x", (int)this.length);
    }

    @Benchmark
    void oldRepeat(int reps) {
        for (int i = 0; i < reps; ++i) {
            String x = StringsRepeatBenchmark.oldRepeat(this.originalString, this.count);
            if (x.length() == this.originalString.length() * this.count) continue;
            throw new RuntimeException("Wrong length: " + x);
        }
    }

    @Benchmark
    void mikeRepeat(int reps) {
        for (int i = 0; i < reps; ++i) {
            String x = StringsRepeatBenchmark.mikeRepeat(this.originalString, this.count);
            if (x.length() == this.originalString.length() * this.count) continue;
            throw new RuntimeException("Wrong length: " + x);
        }
    }

    @Benchmark
    void martinRepeat(int reps) {
        for (int i = 0; i < reps; ++i) {
            String x = StringsRepeatBenchmark.martinRepeat(this.originalString, this.count);
            if (x.length() == this.originalString.length() * this.count) continue;
            throw new RuntimeException("Wrong length: " + x);
        }
    }

    private static String mikeRepeat(String string, int count) {
        int len = string.length();
        char[] strCopy = new char[len * Integer.highestOneBit(count)];
        string.getChars(0, len, strCopy, 0);
        char[] array = new char[len * count];
        int strCopyLen = len;
        int pos = 0;
        while (count != 0) {
            if ((count & 1) != 0) {
                System.arraycopy(strCopy, 0, array, pos, strCopyLen);
                pos += strCopyLen;
            }
            if ((count >>= 1) == 0) continue;
            System.arraycopy(strCopy, 0, strCopy, strCopyLen, strCopyLen);
            strCopyLen <<= 1;
        }
        return new String(array);
    }

    private static String oldRepeat(String string, int count) {
        int len = string.length();
        int size = len * count;
        char[] array = new char[size];
        for (int i = 0; i < size; i += len) {
            string.getChars(0, len, array, i);
        }
        return new String(array);
    }

    private static String martinRepeat(String string, int count) {
        int n;
        int len = string.length();
        int size = len * count;
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }
}

