/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Strings;
import com.google.common.testing.NullPointerTester;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class StringsTest
extends TestCase {
    public void testNullToEmpty() {
        StringsTest.assertEquals((String)"", (String)Strings.nullToEmpty(null));
        StringsTest.assertEquals((String)"", (String)Strings.nullToEmpty((String)""));
        StringsTest.assertEquals((String)"a", (String)Strings.nullToEmpty((String)"a"));
    }

    public void testEmptyToNull() {
        StringsTest.assertNull((Object)Strings.emptyToNull(null));
        StringsTest.assertNull((Object)Strings.emptyToNull((String)""));
        StringsTest.assertEquals((String)"a", (String)Strings.emptyToNull((String)"a"));
    }

    public void testIsNullOrEmpty() {
        StringsTest.assertTrue((boolean)Strings.isNullOrEmpty(null));
        StringsTest.assertTrue((boolean)Strings.isNullOrEmpty((String)""));
        StringsTest.assertFalse((boolean)Strings.isNullOrEmpty((String)"a"));
    }

    public void testPadStart_noPadding() {
        StringsTest.assertSame((Object)"", (Object)Strings.padStart((String)"", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"x", (Object)Strings.padStart((String)"x", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"x", (Object)Strings.padStart((String)"x", (int)1, (char)'-'));
        StringsTest.assertSame((Object)"xx", (Object)Strings.padStart((String)"xx", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"xx", (Object)Strings.padStart((String)"xx", (int)2, (char)'-'));
    }

    public void testPadStart_somePadding() {
        StringsTest.assertEquals((String)"-", (String)Strings.padStart((String)"", (int)1, (char)'-'));
        StringsTest.assertEquals((String)"--", (String)Strings.padStart((String)"", (int)2, (char)'-'));
        StringsTest.assertEquals((String)"-x", (String)Strings.padStart((String)"x", (int)2, (char)'-'));
        StringsTest.assertEquals((String)"--x", (String)Strings.padStart((String)"x", (int)3, (char)'-'));
        StringsTest.assertEquals((String)"-xx", (String)Strings.padStart((String)"xx", (int)3, (char)'-'));
    }

    public void testPadStart_negativeMinLength() {
        StringsTest.assertSame((Object)"x", (Object)Strings.padStart((String)"x", (int)-1, (char)'-'));
    }

    public void testPadStart_null() {
        try {
            Strings.padStart(null, (int)5, (char)'0');
            StringsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPadEnd_noPadding() {
        StringsTest.assertSame((Object)"", (Object)Strings.padEnd((String)"", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"x", (Object)Strings.padEnd((String)"x", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"x", (Object)Strings.padEnd((String)"x", (int)1, (char)'-'));
        StringsTest.assertSame((Object)"xx", (Object)Strings.padEnd((String)"xx", (int)0, (char)'-'));
        StringsTest.assertSame((Object)"xx", (Object)Strings.padEnd((String)"xx", (int)2, (char)'-'));
    }

    public void testPadEnd_somePadding() {
        StringsTest.assertEquals((String)"-", (String)Strings.padEnd((String)"", (int)1, (char)'-'));
        StringsTest.assertEquals((String)"--", (String)Strings.padEnd((String)"", (int)2, (char)'-'));
        StringsTest.assertEquals((String)"x-", (String)Strings.padEnd((String)"x", (int)2, (char)'-'));
        StringsTest.assertEquals((String)"x--", (String)Strings.padEnd((String)"x", (int)3, (char)'-'));
        StringsTest.assertEquals((String)"xx-", (String)Strings.padEnd((String)"xx", (int)3, (char)'-'));
    }

    public void testPadEnd_negativeMinLength() {
        StringsTest.assertSame((Object)"x", (Object)Strings.padEnd((String)"x", (int)-1, (char)'-'));
    }

    public void testPadEnd_null() {
        try {
            Strings.padEnd(null, (int)5, (char)'0');
            StringsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRepeat() {
        String input = "20";
        StringsTest.assertEquals((String)"", (String)Strings.repeat((String)input, (int)0));
        StringsTest.assertEquals((String)"20", (String)Strings.repeat((String)input, (int)1));
        StringsTest.assertEquals((String)"2020", (String)Strings.repeat((String)input, (int)2));
        StringsTest.assertEquals((String)"202020", (String)Strings.repeat((String)input, (int)3));
        StringsTest.assertEquals((String)"", (String)Strings.repeat((String)"", (int)4));
        for (int i = 0; i < 100; ++i) {
            StringsTest.assertEquals((int)(2 * i), (int)Strings.repeat((String)input, (int)i).length());
        }
        try {
            Strings.repeat((String)"x", (int)-1);
            StringsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Strings.repeat((String)"12345678", (int)0x40000003);
            StringsTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRepeat_null() {
        try {
            Strings.repeat(null, (int)5);
            StringsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCommonPrefix() {
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"", (CharSequence)""));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"abc", (CharSequence)""));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"", (CharSequence)"abc"));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"abcde", (CharSequence)"xyz"));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"xyz", (CharSequence)"abcde"));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"xyz", (CharSequence)"abcxyz"));
        StringsTest.assertEquals((String)"a", (String)Strings.commonPrefix((CharSequence)"abc", (CharSequence)"aaaaa"));
        StringsTest.assertEquals((String)"aa", (String)Strings.commonPrefix((CharSequence)"aa", (CharSequence)"aaaaa"));
        StringsTest.assertEquals((String)"abc", (String)Strings.commonPrefix((CharSequence)new StringBuffer("abcdef"), (CharSequence)"abcxyz"));
        StringsTest.assertEquals((String)"abc\ud8ab\udcab", (String)Strings.commonPrefix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"abc\ud8ab\udcabxyz"));
        StringsTest.assertEquals((String)"abc", (String)Strings.commonPrefix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"abc\ud8ab\udcacxyz"));
        StringsTest.assertEquals((String)"abc", (String)Strings.commonPrefix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"abc\ud8ab\ud8abxyz"));
        StringsTest.assertEquals((String)"abc\ud8ab\ud8ac", (String)Strings.commonPrefix((CharSequence)"abc\ud8ab\ud8acdef", (CharSequence)"abc\ud8ab\ud8acxyz"));
        StringsTest.assertEquals((String)"abc\ud8ab", (String)Strings.commonPrefix((CharSequence)"abc\ud8ab\ud8abdef", (CharSequence)"abc\ud8ab\ud8acxyz"));
        StringsTest.assertEquals((String)"", (String)Strings.commonPrefix((CharSequence)"\ud8ab\udcab", (CharSequence)"\ud8ab"));
        StringsTest.assertEquals((String)"\ud8ab", (String)Strings.commonPrefix((CharSequence)"\ud8ab", (CharSequence)"\ud8ab"));
    }

    public void testCommonSuffix() {
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"", (CharSequence)""));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"abc", (CharSequence)""));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"", (CharSequence)"abc"));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"abcde", (CharSequence)"xyz"));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"xyz", (CharSequence)"abcde"));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"xyz", (CharSequence)"xyzabc"));
        StringsTest.assertEquals((String)"c", (String)Strings.commonSuffix((CharSequence)"abc", (CharSequence)"ccccc"));
        StringsTest.assertEquals((String)"aa", (String)Strings.commonSuffix((CharSequence)"aa", (CharSequence)"aaaaa"));
        StringsTest.assertEquals((String)"abc", (String)Strings.commonSuffix((CharSequence)new StringBuffer("xyzabc"), (CharSequence)"xxxabc"));
        StringsTest.assertEquals((String)"\ud8ab\udcabdef", (String)Strings.commonSuffix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"xyz\ud8ab\udcabdef"));
        StringsTest.assertEquals((String)"def", (String)Strings.commonSuffix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"abc\ud8ac\udcabdef"));
        StringsTest.assertEquals((String)"def", (String)Strings.commonSuffix((CharSequence)"abc\ud8ab\udcabdef", (CharSequence)"xyz\udcab\udcabdef"));
        StringsTest.assertEquals((String)"\ud8ab\ud8abdef", (String)Strings.commonSuffix((CharSequence)"abc\ud8ab\ud8abdef", (CharSequence)"xyz\ud8ab\ud8abdef"));
        StringsTest.assertEquals((String)"\udcabdef", (String)Strings.commonSuffix((CharSequence)"abc\udcab\udcabdef", (CharSequence)"abc\udcac\udcabdef"));
        StringsTest.assertEquals((String)"", (String)Strings.commonSuffix((CharSequence)"x\ud8ab\udcab", (CharSequence)"\udcab"));
        StringsTest.assertEquals((String)"\udcab", (String)Strings.commonSuffix((CharSequence)"\udcab", (CharSequence)"\udcab"));
    }

    public void testValidSurrogatePairAt() {
        StringsTest.assertTrue((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\udcab", (int)0));
        StringsTest.assertTrue((boolean)Strings.validSurrogatePairAt((CharSequence)"abc\ud8ab\udcab", (int)3));
        StringsTest.assertTrue((boolean)Strings.validSurrogatePairAt((CharSequence)"abc\ud8ab\udcabxyz", (int)3));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\ud8ab", (int)0));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\udcab\udcab", (int)0));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\udcab", (int)-1));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\udcab", (int)1));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\udcab", (int)-2));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8ab\udcab", (int)2));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"x\udcab", (int)0));
        StringsTest.assertFalse((boolean)Strings.validSurrogatePairAt((CharSequence)"\ud8abx", (int)0));
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Strings.class);
    }
}

