/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LocalCache;

public class ChainBenchmark {
    @Param(value={"1", "2", "3", "4", "5", "6"})
    int length;
    private LocalCache.Segment<Object, Object> segment;
    private LocalCache.ReferenceEntry<Object, Object> head;
    private LocalCache.ReferenceEntry<Object, Object> chain;

    @BeforeExperiment
    void setUp() {
        LocalCache cache = new LocalCache(CacheBuilder.newBuilder().concurrencyLevel(1), null);
        this.segment = cache.segments[0];
        this.chain = null;
        for (int i = 0; i < this.length; ++i) {
            Object key = new Object();
            this.chain = this.segment.newEntry(key, cache.hash(key), this.chain);
            if (i != 0) continue;
            this.head = this.chain;
        }
    }

    @Benchmark
    int time(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            this.segment.removeEntryFromChain(this.chain, this.head);
            dummy += this.segment.count;
        }
        return dummy;
    }
}

