/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class ForwardingLoadingCacheTest
extends TestCase {
    private LoadingCache<String, Boolean> forward;
    private LoadingCache<String, Boolean> mock;

    public void setUp() throws Exception {
        super.setUp();
        this.mock = (LoadingCache)Mockito.mock(LoadingCache.class);
        this.forward = new ForwardingLoadingCache<String, Boolean>(){

            protected LoadingCache<String, Boolean> delegate() {
                return ForwardingLoadingCacheTest.this.mock;
            }
        };
    }

    public void testGet() throws ExecutionException {
        Mockito.when((Object)this.mock.get((Object)"key")).thenReturn((Object)Boolean.TRUE);
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.get((Object)"key"));
    }

    public void testGetUnchecked() {
        Mockito.when((Object)this.mock.getUnchecked((Object)"key")).thenReturn((Object)Boolean.TRUE);
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.getUnchecked((Object)"key"));
    }

    public void testGetAll() throws ExecutionException {
        Mockito.when((Object)this.mock.getAll((Iterable)ImmutableList.of((Object)"key"))).thenReturn((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE));
        ForwardingLoadingCacheTest.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE), (Object)this.forward.getAll((Iterable)ImmutableList.of((Object)"key")));
    }

    public void testApply() {
        Mockito.when((Object)this.mock.apply((Object)"key")).thenReturn((Object)Boolean.TRUE);
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.apply((Object)"key"));
    }

    public void testInvalidate() {
        this.forward.invalidate((Object)"key");
        ((LoadingCache)Mockito.verify(this.mock)).invalidate((Object)"key");
    }

    public void testRefresh() throws ExecutionException {
        this.forward.refresh((Object)"key");
        ((LoadingCache)Mockito.verify(this.mock)).refresh((Object)"key");
    }

    public void testInvalidateAll() {
        this.forward.invalidateAll();
        ((LoadingCache)Mockito.verify(this.mock)).invalidateAll();
    }

    public void testSize() {
        Mockito.when((Object)this.mock.size()).thenReturn((Object)0L);
        this.forward.size();
    }

    public void testStats() {
        Mockito.when((Object)this.mock.stats()).thenReturn(null);
        ForwardingLoadingCacheTest.assertNull((Object)this.forward.stats());
    }

    public void testAsMap() {
        Mockito.when((Object)this.mock.asMap()).thenReturn(null);
        ForwardingLoadingCacheTest.assertNull((Object)this.forward.asMap());
    }

    public void testCleanUp() {
        this.forward.cleanUp();
        ((LoadingCache)Mockito.verify(this.mock)).cleanUp();
    }

    private static class OnlyGet<K, V>
    extends ForwardingLoadingCache<K, V> {
        private OnlyGet() {
        }

        protected LoadingCache<K, V> delegate() {
            return null;
        }
    }
}

