/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.MapMaker;
import java.util.Map;

public class MapMakerComparisonBenchmark {
    private static final String TEST_KEY = "test key";
    private static final String TEST_VALUE = "test value";
    private final Map<Object, Object> map = new MapMaker().makeMap();
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().recordStats().build();
    private final Cache<Object, Object> cacheNoStats = CacheBuilder.newBuilder().build();

    @BeforeExperiment
    void setUp() {
        this.map.put(TEST_KEY, TEST_VALUE);
        this.cache.put((Object)TEST_KEY, (Object)TEST_VALUE);
        this.cacheNoStats.put((Object)TEST_KEY, (Object)TEST_VALUE);
    }

    @Benchmark
    void concurrentHashMap(int rep) {
        for (int i = 0; i < rep; ++i) {
            this.map.get(TEST_KEY);
        }
    }

    @Benchmark
    void cacheBuilder_stats(int rep) {
        for (int i = 0; i < rep; ++i) {
            this.cache.getIfPresent((Object)TEST_KEY);
        }
    }

    @Benchmark
    void cacheBuilder(int rep) {
        for (int i = 0; i < rep; ++i) {
            this.cacheNoStats.getIfPresent((Object)TEST_KEY);
        }
    }
}

