/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class NullCacheTest
extends TestCase {
    TestingRemovalListeners.QueuingRemovalListener<Object, Object> listener;

    protected void setUp() {
        this.listener = TestingRemovalListeners.queuingRemovalListener();
    }

    public void testGet() {
        Object computed = new Object();
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(0L).removalListener(this.listener).build(TestingCacheLoaders.constantLoader(computed));
        Object key = new Object();
        NullCacheTest.assertSame((Object)computed, (Object)cache.getUnchecked(key));
        RemovalNotification notification = (RemovalNotification)this.listener.remove();
        NullCacheTest.assertSame((Object)key, (Object)notification.getKey());
        NullCacheTest.assertSame((Object)computed, (Object)notification.getValue());
        NullCacheTest.assertSame((Object)RemovalCause.SIZE, (Object)notification.getCause());
        NullCacheTest.assertTrue((boolean)this.listener.isEmpty());
        CacheTesting.checkEmpty(cache);
    }

    public void testGet_expireAfterWrite() {
        Object computed = new Object();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite(0L, TimeUnit.SECONDS).removalListener(this.listener).build(TestingCacheLoaders.constantLoader(computed));
        Object key = new Object();
        NullCacheTest.assertSame((Object)computed, (Object)cache.getUnchecked(key));
        RemovalNotification notification = (RemovalNotification)this.listener.remove();
        NullCacheTest.assertSame((Object)key, (Object)notification.getKey());
        NullCacheTest.assertSame((Object)computed, (Object)notification.getValue());
        NullCacheTest.assertSame((Object)RemovalCause.SIZE, (Object)notification.getCause());
        NullCacheTest.assertTrue((boolean)this.listener.isEmpty());
        CacheTesting.checkEmpty(cache);
    }

    public void testGet_expireAfterAccess() {
        Object computed = new Object();
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(0L, TimeUnit.SECONDS).removalListener(this.listener).build(TestingCacheLoaders.constantLoader(computed));
        Object key = new Object();
        NullCacheTest.assertSame((Object)computed, (Object)cache.getUnchecked(key));
        RemovalNotification notification = (RemovalNotification)this.listener.remove();
        NullCacheTest.assertSame((Object)key, (Object)notification.getKey());
        NullCacheTest.assertSame((Object)computed, (Object)notification.getValue());
        NullCacheTest.assertSame((Object)RemovalCause.SIZE, (Object)notification.getCause());
        NullCacheTest.assertTrue((boolean)this.listener.isEmpty());
        CacheTesting.checkEmpty(cache);
    }

    public void testGet_computeNull() {
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(0L).removalListener(this.listener).build(TestingCacheLoaders.constantLoader(null));
        try {
            cache.getUnchecked(new Object());
            NullCacheTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        NullCacheTest.assertTrue((boolean)this.listener.isEmpty());
        CacheTesting.checkEmpty(cache);
    }

    public void testGet_runtimeException() {
        RuntimeException e = new RuntimeException();
        LoadingCache map = CacheBuilder.newBuilder().maximumSize(0L).removalListener(this.listener).build(TestingCacheLoaders.exceptionLoader(e));
        try {
            map.getUnchecked(new Object());
            NullCacheTest.fail();
        }
        catch (UncheckedExecutionException uee) {
            NullCacheTest.assertSame((Object)e, (Object)uee.getCause());
        }
        NullCacheTest.assertTrue((boolean)this.listener.isEmpty());
        CacheTesting.checkEmpty(map);
    }
}

