/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractTableReadTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.Map;

@GwtCompatible
public abstract class AbstractTableTest
extends AbstractTableReadTest {
    protected void populate(Table<String, Integer, Character> table, Object ... data) {
        Preconditions.checkArgument((data.length % 3 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < data.length; i += 3) {
            table.put((Object)((String)data[i]), (Object)((Integer)data[i + 1]), (Object)((Character)data[i + 2]));
        }
    }

    protected boolean supportsRemove() {
        return true;
    }

    protected boolean supportsNullValues() {
        return false;
    }

    public void testClear() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        if (this.supportsRemove()) {
            this.table.clear();
            AbstractTableTest.assertEquals((int)0, (int)this.table.size());
            AbstractTableTest.assertFalse((boolean)this.table.containsRow((Object)"foo"));
        } else {
            try {
                this.table.clear();
                AbstractTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void testPut() {
        AbstractTableTest.assertNull((Object)this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a')));
        AbstractTableTest.assertNull((Object)this.table.put((Object)"bar", (Object)1, (Object)Character.valueOf('b')));
        AbstractTableTest.assertNull((Object)this.table.put((Object)"foo", (Object)3, (Object)Character.valueOf('c')));
        AbstractTableTest.assertEquals((Object)Character.valueOf('a'), (Object)this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('d')));
        AbstractTableTest.assertEquals((Object)Character.valueOf('d'), (Object)this.table.get((Object)"foo", (Object)1));
        AbstractTableTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.get((Object)"bar", (Object)1));
        this.assertSize(3);
        AbstractTableTest.assertEquals((Object)Character.valueOf('d'), (Object)this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('d')));
        AbstractTableTest.assertEquals((Object)Character.valueOf('d'), (Object)this.table.get((Object)"foo", (Object)1));
        this.assertSize(3);
    }

    public void testPutNull() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        this.assertSize(3);
        try {
            this.table.put(null, (Object)2, (Object)Character.valueOf('d'));
            AbstractTableTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.table.put((Object)"cat", null, (Object)Character.valueOf('d'));
            AbstractTableTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        if (this.supportsNullValues()) {
            AbstractTableTest.assertNull((Object)this.table.put((Object)"cat", (Object)2, null));
            AbstractTableTest.assertTrue((boolean)this.table.contains((Object)"cat", (Object)2));
        } else {
            try {
                this.table.put((Object)"cat", (Object)2, null);
                AbstractTableTest.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertSize(3);
    }

    public void testPutNullReplace() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        if (this.supportsNullValues()) {
            AbstractTableTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.put((Object)"bar", (Object)1, null));
            AbstractTableTest.assertNull((Object)this.table.get((Object)"bar", (Object)1));
        } else {
            try {
                this.table.put((Object)"bar", (Object)1, null);
                AbstractTableTest.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void testPutAllTable() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable other = HashBasedTable.create();
        other.put((Object)"foo", (Object)1, (Object)Character.valueOf('d'));
        other.put((Object)"bar", (Object)2, (Object)Character.valueOf('e'));
        other.put((Object)"cat", (Object)2, (Object)Character.valueOf('f'));
        this.table.putAll((Table)other);
        AbstractTableTest.assertEquals((Object)Character.valueOf('d'), (Object)this.table.get((Object)"foo", (Object)1));
        AbstractTableTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.get((Object)"bar", (Object)1));
        AbstractTableTest.assertEquals((Object)Character.valueOf('c'), (Object)this.table.get((Object)"foo", (Object)3));
        AbstractTableTest.assertEquals((Object)Character.valueOf('e'), (Object)this.table.get((Object)"bar", (Object)2));
        AbstractTableTest.assertEquals((Object)Character.valueOf('f'), (Object)this.table.get((Object)"cat", (Object)2));
        this.assertSize(5);
    }

    public void testRemove() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        if (this.supportsRemove()) {
            AbstractTableTest.assertNull((Object)this.table.remove((Object)"cat", (Object)1));
            AbstractTableTest.assertNull((Object)this.table.remove((Object)"bar", (Object)3));
            AbstractTableTest.assertEquals((int)3, (int)this.table.size());
            AbstractTableTest.assertEquals((Object)Character.valueOf('c'), (Object)this.table.remove((Object)"foo", (Object)3));
            AbstractTableTest.assertEquals((int)2, (int)this.table.size());
            AbstractTableTest.assertEquals((Object)Character.valueOf('a'), (Object)this.table.get((Object)"foo", (Object)1));
            AbstractTableTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.get((Object)"bar", (Object)1));
            AbstractTableTest.assertNull((Object)this.table.get((Object)"foo", (Object)3));
            AbstractTableTest.assertNull((Object)this.table.remove(null, (Object)1));
            AbstractTableTest.assertNull((Object)this.table.remove((Object)"foo", null));
            AbstractTableTest.assertNull((Object)this.table.remove(null, null));
            this.assertSize(2);
        } else {
            try {
                this.table.remove((Object)"foo", (Object)3);
                AbstractTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            AbstractTableTest.assertEquals((Object)Character.valueOf('c'), (Object)this.table.get((Object)"foo", (Object)3));
        }
    }

    public void testRowClearAndPut() {
        if (this.supportsRemove()) {
            this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
            Map row = this.table.row((Object)"foo");
            AbstractTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a'), (Object)3, (Object)Character.valueOf('c')), (Object)row);
            this.table.remove((Object)"foo", (Object)3);
            AbstractTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a')), (Object)row);
            this.table.remove((Object)"foo", (Object)1);
            AbstractTableTest.assertEquals((Object)ImmutableMap.of(), (Object)row);
            this.table.put((Object)"foo", (Object)2, (Object)Character.valueOf('b'));
            AbstractTableTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)Character.valueOf('b')), (Object)row);
            row.clear();
            AbstractTableTest.assertEquals((Object)ImmutableMap.of(), (Object)row);
            this.table.put((Object)"foo", (Object)5, (Object)Character.valueOf('x'));
            AbstractTableTest.assertEquals((Object)ImmutableMap.of((Object)5, (Object)Character.valueOf('x')), (Object)row);
        }
    }
}

