/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.SpecialRandom;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class CollectionBenchmarkSampleData {
    private final boolean isUserTypeFast;
    private final SpecialRandom random;
    private final double hitRate;
    private final int size;
    private final Set<Element> valuesInSet;
    private final Element[] queries;

    CollectionBenchmarkSampleData(int size) {
        this(true, new SpecialRandom(), 1.0, size);
    }

    CollectionBenchmarkSampleData(boolean isUserTypeFast, SpecialRandom random, double hitRate, int size) {
        this.isUserTypeFast = isUserTypeFast;
        this.random = (SpecialRandom)Preconditions.checkNotNull((Object)random);
        this.hitRate = hitRate;
        this.size = size;
        this.valuesInSet = this.createData();
        this.queries = this.createQueries(this.valuesInSet, 1024);
    }

    Set<Element> getValuesInSet() {
        return this.valuesInSet;
    }

    Element[] getQueries() {
        return this.queries;
    }

    private Element[] createQueries(Set<Element> elementsInSet, int numQueries) {
        ArrayList queryList = Lists.newArrayListWithCapacity((int)numQueries);
        int numGoodQueries = (int)((double)numQueries * this.hitRate + 0.5);
        int size = elementsInSet.size();
        if (size > 0) {
            int minCopiesOfEachGoodQuery = numGoodQueries / size;
            int extras = numGoodQueries % size;
            for (int i = 0; i < minCopiesOfEachGoodQuery; ++i) {
                queryList.addAll(elementsInSet);
            }
            ArrayList tmp = Lists.newArrayList(elementsInSet);
            Collections.shuffle(tmp, this.random);
            queryList.addAll(tmp.subList(0, extras));
        }
        while (queryList.size() < numQueries) {
            Element candidate = this.newElement();
            if (elementsInSet.contains(candidate)) continue;
            queryList.add(candidate);
        }
        Collections.shuffle(queryList, this.random);
        return queryList.toArray(new Element[0]);
    }

    private Set<Element> createData() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)this.size);
        while (set.size() < this.size) {
            set.add(this.newElement());
        }
        return set;
    }

    private Element newElement() {
        int value = this.random.nextInt();
        return this.isUserTypeFast ? new Element(value) : new SlowElement(value);
    }

    static class SlowElement
    extends Element {
        SlowElement(int hash) {
            super(hash);
        }

        @Override
        public boolean equals(Object obj) {
            return SlowElement.slowItDown() != 1 && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return SlowElement.slowItDown() + this.hash;
        }

        @Override
        public int compareTo(Element e) {
            int x = SlowElement.slowItDown();
            return x + super.compareTo(e) - x;
        }

        static int slowItDown() {
            int result = 0;
            for (int i = 1; i <= 1000; ++i) {
                result += i;
            }
            return result;
        }
    }

    static class Element
    implements Comparable<Element> {
        final int hash;

        Element(int hash) {
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Element && ((Element)obj).hash == this.hash;
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public int compareTo(Element that) {
            return Ints.compare((int)this.hash, (int)that.hash);
        }

        public String toString() {
            return String.valueOf(this.hash);
        }
    }
}

