/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestStringCollectionGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class Collections2Test
extends TestCase {
    static final Predicate<String> NOT_YYY_ZZZ = new Predicate<String>(){

        public boolean apply(String input) {
            return !"yyy".equals(input) && !"zzz".equals(input);
        }
    };
    static final Predicate<String> LENGTH_1 = new Predicate<String>(){

        public boolean apply(String input) {
            return input.length() == 1;
        }
    };
    static final Predicate<String> STARTS_WITH_VOWEL = new Predicate<String>(){

        public boolean apply(String input) {
            return Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')).contains(Character.valueOf(input.charAt(0)));
        }
    };
    private static final Function<String, String> REMOVE_FIRST_CHAR = new Function<String, String>(){

        public String apply(String from) {
            return from == null || "".equals(from) ? null : from.substring(1);
        }
    };

    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite(Collections2Test.class.getSimpleName());
        suite.addTest(Collections2Test.testsForFilter());
        suite.addTest(Collections2Test.testsForFilterAll());
        suite.addTest(Collections2Test.testsForFilterLinkedList());
        suite.addTest(Collections2Test.testsForFilterNoNulls());
        suite.addTest(Collections2Test.testsForFilterFiltered());
        suite.addTest(Collections2Test.testsForTransform());
        suite.addTestSuite(Collections2Test.class);
        return suite;
    }

    @GwtIncompatible
    private static Test testsForFilter() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                ArrayList unfiltered = Lists.newArrayList();
                unfiltered.add("yyy");
                Collections.addAll(unfiltered, elements);
                unfiltered.add("zzz");
                return Collections2.filter((Collection)unfiltered, NOT_YYY_ZZZ);
            }
        }).named("Collections2.filter")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    private static Test testsForFilterAll() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                ArrayList unfiltered = Lists.newArrayList();
                Collections.addAll(unfiltered, elements);
                return Collections2.filter((Collection)unfiltered, NOT_YYY_ZZZ);
            }
        }).named("Collections2.filter")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    private static Test testsForFilterLinkedList() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                LinkedList unfiltered = Lists.newLinkedList();
                unfiltered.add("yyy");
                Collections.addAll(unfiltered, elements);
                unfiltered.add("zzz");
                return Collections2.filter((Collection)unfiltered, NOT_YYY_ZZZ);
            }
        }).named("Collections2.filter")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    private static Test testsForFilterNoNulls() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                ArrayList unfiltered = Lists.newArrayList();
                unfiltered.add("yyy");
                unfiltered.addAll(ImmutableList.copyOf((Object[])elements));
                unfiltered.add("zzz");
                return Collections2.filter((Collection)unfiltered, LENGTH_1);
            }
        }).named("Collections2.filter, no nulls")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    private static Test testsForFilterFiltered() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                ArrayList unfiltered = Lists.newArrayList();
                unfiltered.add("yyy");
                unfiltered.addAll(ImmutableList.copyOf((Object[])elements));
                unfiltered.add("zzz");
                unfiltered.add("abc");
                return Collections2.filter((Collection)Collections2.filter((Collection)unfiltered, LENGTH_1), NOT_YYY_ZZZ);
            }
        }).named("Collections2.filter, filtered input")).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    private static Test testsForTransform() {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            public Collection<String> create(String[] elements) {
                ArrayList list = Lists.newArrayList();
                for (String element : elements) {
                    list.add(element == null ? null : "q" + element);
                }
                return Collections2.transform((Collection)list, (Function)REMOVE_FIRST_CHAR);
            }
        }).named("Collections2.transform")).withFeatures(new Feature[]{CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite();
    }

    @GwtIncompatible
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Collections2.class);
    }

    public void testOrderedPermutationSetEmpty() {
        ArrayList list = Lists.newArrayList();
        Collection permutationSet = Collections2.orderedPermutations((Iterable)list);
        Collections2Test.assertEquals((int)1, (int)permutationSet.size());
        Truth.assertThat((Iterable)permutationSet).contains((Object)list);
        Iterator permutations = permutationSet.iterator();
        this.assertNextPermutation(Lists.newArrayList(), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testOrderedPermutationSetOneElement() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1});
        Iterator permutations = Collections2.orderedPermutations((Iterable)list).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testOrderedPermutationSetThreeElements() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"b", "a", "c"});
        Iterator permutations = Collections2.orderedPermutations((Iterable)list).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"a", "c", "b"}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"b", "a", "c"}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"b", "c", "a"}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"c", "a", "b"}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new String[]{"c", "b", "a"}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testOrderedPermutationSetRepeatedElements() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 1, 2, 2});
        Iterator permutations = Collections2.orderedPermutations((Iterable)list, (Comparator)Ordering.natural()).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 1, 2, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 2, 1, 1}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testOrderedPermutationSetRepeatedElementsSize() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 1, 1, 1, 2, 2, 3});
        Collection permutations = Collections2.orderedPermutations((Iterable)list, (Comparator)Ordering.natural());
        this.assertPermutationsCount(105, permutations);
    }

    public void testOrderedPermutationSetSizeOverflow() {
        Collections2Test.assertEquals((int)479001600, (int)Collections2.orderedPermutations((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12})).size());
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.orderedPermutations((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13})).size());
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.orderedPermutations((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21})).size());
        Collections2Test.assertEquals((int)1391975640, (int)Collections2.orderedPermutations((Iterable)Iterables.concat(Collections.nCopies(20, 1), Collections.nCopies(14, 2))).size());
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.orderedPermutations((Iterable)Iterables.concat(Collections.nCopies(21, 1), Collections.nCopies(14, 2))).size());
    }

    public void testOrderedPermutationSetContains() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{3, 2, 1});
        Collection permutationSet = Collections2.orderedPermutations((Iterable)list);
        Collections2Test.assertTrue((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2, 3})));
        Collections2Test.assertTrue((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{2, 3, 1})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 1, 2, 3})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(null));
    }

    public void testPermutationSetEmpty() {
        Collection permutationSet = Collections2.permutations(Collections.emptyList());
        Collections2Test.assertEquals((int)1, (int)permutationSet.size());
        Collections2Test.assertTrue((boolean)permutationSet.contains(Collections.emptyList()));
        Iterator permutations = permutationSet.iterator();
        this.assertNextPermutation(Collections.emptyList(), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetOneElement() {
        Iterator permutations = Collections2.permutations(Collections.singletonList(1)).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetTwoElements() {
        Iterator permutations = Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2})).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetThreeElements() {
        Iterator permutations = Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3})).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 3, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 3, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 3}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetThreeElementsOutOfOrder() {
        Iterator permutations = Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{3, 2, 1})).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 3, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 3, 1}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetThreeRepeatedElements() {
        Iterator permutations = Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 1, 2})).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 1, 2}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetFourElements() {
        Iterator permutations = Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4})).iterator();
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 4, 2, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 1, 2, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 1, 3, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 4, 3, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 3, 4, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{1, 3, 2, 4}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 1, 2, 4}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 1, 4, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 4, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 3, 1, 2}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 3, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 4, 2, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 2, 4, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{3, 2, 1, 4}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 3, 1, 4}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 4, 3, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 2, 3, 1}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{4, 2, 1, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 4, 1, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 4, 3}), permutations);
        this.assertNextPermutation(Lists.newArrayList((Object[])new Integer[]{2, 1, 3, 4}), permutations);
        this.assertNoMorePermutations(permutations);
    }

    public void testPermutationSetSize() {
        this.assertPermutationsCount(1, Collections2.permutations(Collections.emptyList()));
        this.assertPermutationsCount(1, Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1})));
        this.assertPermutationsCount(2, Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2})));
        this.assertPermutationsCount(6, Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3})));
        this.assertPermutationsCount(5040, Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7})));
        this.assertPermutationsCount(40320, Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8})));
    }

    public void testPermutationSetSizeOverflow() {
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.permutations((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13})).size());
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.orderedPermutations((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20})).size());
        Collections2Test.assertEquals((int)Integer.MAX_VALUE, (int)Collections2.orderedPermutations((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21})).size());
    }

    public void testPermutationSetContains() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{3, 2, 1});
        Collection permutationSet = Collections2.permutations((Collection)list);
        Collections2Test.assertTrue((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2, 3})));
        Collections2Test.assertTrue((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{2, 3, 1})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 1, 2, 3})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4})));
        Collections2Test.assertFalse((boolean)permutationSet.contains(null));
    }

    private <T> void assertNextPermutation(List<T> expectedPermutation, Iterator<List<T>> permutations) {
        Collections2Test.assertTrue((String)"Expected another permutation, but there was none.", (boolean)permutations.hasNext());
        Collections2Test.assertEquals(expectedPermutation, permutations.next());
    }

    private <T> void assertNoMorePermutations(Iterator<List<T>> permutations) {
        Collections2Test.assertFalse((String)"Expected no more permutations, but there was one.", (boolean)permutations.hasNext());
        try {
            permutations.next();
            Collections2Test.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private <T> void assertPermutationsCount(int expected, Collection<List<T>> permutationSet) {
        Collections2Test.assertEquals((int)expected, (int)permutationSet.size());
        Iterator<List<T>> permutations = permutationSet.iterator();
        for (int i = 0; i < expected; ++i) {
            Collections2Test.assertTrue((boolean)permutations.hasNext());
            permutations.next();
        }
        this.assertNoMorePermutations(permutations);
    }

    public void testToStringImplWithNullEntries() throws Exception {
        ArrayList list = Lists.newArrayList();
        list.add("foo");
        list.add(null);
        Collections2Test.assertEquals((String)((Object)list).toString(), (String)Collections2.toStringImpl((Collection)list));
    }
}

