/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Synchronized;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class ConcurrentHashMultisetBenchmark {
    @Param(value={"1", "2", "4", "8"})
    int threads;
    @Param(value={"3", "30", "300"})
    int size;
    @Param
    MultisetSupplier implSupplier;
    private Multiset<Integer> multiset;
    private ImmutableList<Integer> keys;
    private ExecutorService threadPool;

    @BeforeExperiment
    void setUp() throws Exception {
        this.multiset = this.implSupplier.get();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.size; ++i) {
            builder.add((Object)i);
        }
        this.keys = builder.build();
        this.threadPool = Executors.newFixedThreadPool(this.threads, new ThreadFactoryBuilder().setDaemon(true).build());
    }

    @Benchmark
    long add(final int reps) throws ExecutionException, InterruptedException {
        return this.doMultithreadedLoop(new Callable<Long>(){

            @Override
            public Long call() {
                return ConcurrentHashMultisetBenchmark.this.runAddSingleThread(reps);
            }
        });
    }

    @Benchmark
    long addRemove(final int reps) throws ExecutionException, InterruptedException {
        return this.doMultithreadedLoop(new Callable<Long>(){

            @Override
            public Long call() {
                return ConcurrentHashMultisetBenchmark.this.runAddRemoveSingleThread(reps);
            }
        });
    }

    private long doMultithreadedLoop(Callable<Long> task) throws InterruptedException, ExecutionException {
        ArrayList futures = Lists.newArrayListWithCapacity((int)this.threads);
        for (int i = 0; i < this.threads; ++i) {
            futures.add(this.threadPool.submit(task));
        }
        long total = 0L;
        for (Future future : futures) {
            total += ((Long)future.get()).longValue();
        }
        return total;
    }

    private long runAddSingleThread(int reps) {
        Random random = new Random();
        int nKeys = this.keys.size();
        long blah = 0L;
        for (int i = 0; i < reps; ++i) {
            Integer key = (Integer)this.keys.get(random.nextInt(nKeys));
            int delta = random.nextInt(5);
            blah += (long)delta;
            this.multiset.add((Object)key, delta);
        }
        return blah;
    }

    private long runAddRemoveSingleThread(int reps) {
        Random random = new Random();
        int nKeys = this.keys.size();
        long blah = 0L;
        for (int i = 0; i < reps; ++i) {
            Integer key = (Integer)this.keys.get(random.nextInt(nKeys));
            int delta = random.nextInt(10) - 5;
            blah += (long)delta;
            if (delta >= 0) {
                this.multiset.add((Object)key, delta);
                continue;
            }
            this.multiset.remove((Object)key, -delta);
        }
        return blah;
    }

    private static final class OldConcurrentHashMultiset<E>
    extends AbstractMultiset<E> {
        private final transient ConcurrentMap<E, Integer> countMap;
        private transient EntrySet entrySet;

        public static <E> OldConcurrentHashMultiset<E> create() {
            return new OldConcurrentHashMultiset(new ConcurrentHashMap());
        }

        @VisibleForTesting
        OldConcurrentHashMultiset(ConcurrentMap<E, Integer> countMap) {
            Preconditions.checkArgument((boolean)countMap.isEmpty());
            this.countMap = countMap;
        }

        public int count(@Nullable Object element) {
            try {
                return OldConcurrentHashMultiset.unbox((Integer)this.countMap.get(element));
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
        }

        public int size() {
            long sum = 0L;
            for (Integer value : this.countMap.values()) {
                sum += (long)value.intValue();
            }
            return Ints.saturatedCast((long)sum);
        }

        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.snapshot().toArray(array);
        }

        private List<E> snapshot() {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)this.size());
            for (Multiset.Entry<E> entry : this.entrySet()) {
                Object element = entry.getElement();
                for (int i = entry.getCount(); i > 0; --i) {
                    list.add(element);
                }
            }
            return list;
        }

        public int add(E element, int occurrences) {
            int current;
            if (occurrences == 0) {
                return this.count(element);
            }
            Preconditions.checkArgument((occurrences > 0 ? 1 : 0) != 0, (String)"Invalid occurrences: %s", (int)occurrences);
            while (true) {
                if ((current = this.count(element)) == 0) {
                    if (this.countMap.putIfAbsent(element, occurrences) != null) continue;
                    return 0;
                }
                Preconditions.checkArgument((occurrences <= Integer.MAX_VALUE - current ? 1 : 0) != 0, (String)"Overflow adding %s occurrences to a count of %s", (int)occurrences, (int)current);
                int next = current + occurrences;
                if (this.countMap.replace(element, current, next)) break;
            }
            return current;
        }

        public int remove(@Nullable Object element, int occurrences) {
            Object casted;
            int current;
            if (occurrences == 0) {
                return this.count(element);
            }
            Preconditions.checkArgument((occurrences > 0 ? 1 : 0) != 0, (String)"Invalid occurrences: %s", (int)occurrences);
            do {
                if ((current = this.count(element)) != 0) continue;
                return 0;
            } while (!(occurrences >= current ? this.countMap.remove(element, current) : this.countMap.replace(casted = element, current, current - occurrences)));
            return current;
        }

        private int removeAllOccurrences(@Nullable Object element) {
            try {
                return OldConcurrentHashMultiset.unbox((Integer)this.countMap.remove(element));
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
        }

        public boolean removeExactly(@Nullable Object element, int occurrences) {
            Object casted;
            int current;
            if (occurrences == 0) {
                return true;
            }
            Preconditions.checkArgument((occurrences > 0 ? 1 : 0) != 0, (String)"Invalid occurrences: %s", (int)occurrences);
            do {
                if (occurrences <= (current = this.count(element))) continue;
                return false;
            } while (!(occurrences == current ? this.countMap.remove(element, occurrences) : this.countMap.replace(casted = element, current, current - occurrences)));
            return true;
        }

        public int setCount(E element, int count) {
            CollectPreconditions.checkNonnegative((int)count, (String)"count");
            return count == 0 ? this.removeAllOccurrences(element) : OldConcurrentHashMultiset.unbox(this.countMap.put(element, count));
        }

        public boolean setCount(E element, int oldCount, int newCount) {
            CollectPreconditions.checkNonnegative((int)oldCount, (String)"oldCount");
            CollectPreconditions.checkNonnegative((int)newCount, (String)"newCount");
            if (newCount == 0) {
                if (oldCount == 0) {
                    return !this.countMap.containsKey(element);
                }
                return this.countMap.remove(element, oldCount);
            }
            if (oldCount == 0) {
                return this.countMap.putIfAbsent(element, newCount) == null;
            }
            return this.countMap.replace(element, oldCount, newCount);
        }

        Set<E> createElementSet() {
            final Set delegate = this.countMap.keySet();
            return new ForwardingSet<E>(){

                protected Set<E> delegate() {
                    return delegate;
                }

                public boolean remove(Object object) {
                    try {
                        return delegate.remove(object);
                    }
                    catch (NullPointerException e) {
                        return false;
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                }
            };
        }

        public Set<Multiset.Entry<E>> entrySet() {
            EntrySet result = this.entrySet;
            if (result == null) {
                this.entrySet = result = new EntrySet();
            }
            return result;
        }

        int distinctElements() {
            return this.countMap.size();
        }

        public boolean isEmpty() {
            return this.countMap.isEmpty();
        }

        Iterator<Multiset.Entry<E>> entryIterator() {
            final Iterator backingIterator = this.countMap.entrySet().iterator();
            return new Iterator<Multiset.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return backingIterator.hasNext();
                }

                @Override
                public Multiset.Entry<E> next() {
                    Map.Entry backingEntry = (Map.Entry)backingIterator.next();
                    return Multisets.immutableEntry(backingEntry.getKey(), (int)((Integer)backingEntry.getValue()));
                }

                @Override
                public void remove() {
                    backingIterator.remove();
                }
            };
        }

        public void clear() {
            this.countMap.clear();
        }

        private static int unbox(@Nullable Integer i) {
            return i == null ? 0 : i;
        }

        private class EntrySet
        extends AbstractMultiset.EntrySet {
            private EntrySet() {
                super((AbstractMultiset)OldConcurrentHashMultiset.this);
            }

            Multiset<E> multiset() {
                return OldConcurrentHashMultiset.this;
            }

            public Object[] toArray() {
                return this.snapshot().toArray();
            }

            public <T> T[] toArray(T[] array) {
                return this.snapshot().toArray(array);
            }

            private List<Multiset.Entry<E>> snapshot() {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)this.size());
                Iterators.addAll((Collection)list, (Iterator)this.iterator());
                return list;
            }

            public boolean remove(Object object) {
                if (object instanceof Multiset.Entry) {
                    Multiset.Entry entry = (Multiset.Entry)object;
                    Object element = entry.getElement();
                    int entryCount = entry.getCount();
                    return OldConcurrentHashMultiset.this.countMap.remove(element, entryCount);
                }
                return false;
            }

            public int hashCode() {
                return OldConcurrentHashMultiset.this.countMap.hashCode();
            }
        }
    }

    private static enum MultisetSupplier {
        CONCURRENT_HASH_MULTISET{

            @Override
            Multiset<Integer> get() {
                return ConcurrentHashMultiset.create();
            }
        }
        ,
        BOXED_ATOMIC_REPLACE{

            @Override
            Multiset<Integer> get() {
                return OldConcurrentHashMultiset.create();
            }
        }
        ,
        SYNCHRONIZED_MULTISET{

            @Override
            Multiset<Integer> get() {
                return Synchronized.multiset((Multiset)HashMultiset.create(), null);
            }
        };


        abstract Multiset<Integer> get();
    }
}

