/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class EvictingQueueTest
extends TestCase {
    public void testCreateWithNegativeSize() throws Exception {
        try {
            EvictingQueue.create((int)-1);
            EvictingQueueTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateWithZeroSize() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)0);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertTrue((boolean)queue.offer((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertFalse((boolean)queue.remove((Object)"hi"));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        try {
            queue.element();
            EvictingQueueTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        EvictingQueueTest.assertNull((Object)queue.peek());
        EvictingQueueTest.assertNull((Object)queue.poll());
        try {
            queue.remove();
            EvictingQueueTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemainingCapacity_maxSize0() {
        EvictingQueue queue = EvictingQueue.create((int)0);
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testRemainingCapacity_maxSize1() {
        EvictingQueue queue = EvictingQueue.create((int)1);
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testRemainingCapacity_maxSize3() {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)2, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        queue.add((Object)"hi");
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
    }

    public void testEvictingAfterOne() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)1);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"hi"));
        EvictingQueueTest.assertEquals((String)"hi", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"hi", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)1, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"there"));
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)1, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"there", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testEvictingAfterThree() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"one"));
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"two"));
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"three"));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.add((Object)"four"));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)2, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testAddAll() throws Exception {
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertEquals((int)0, (int)queue.size());
        EvictingQueueTest.assertEquals((int)3, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.addAll((Collection)ImmutableList.of((Object)"one", (Object)"two", (Object)"three")));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"one", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertTrue((boolean)queue.addAll((Collection)ImmutableList.of((Object)"four")));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.element()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.peek()));
        EvictingQueueTest.assertEquals((int)3, (int)queue.size());
        EvictingQueueTest.assertEquals((int)0, (int)queue.remainingCapacity());
        EvictingQueueTest.assertEquals((String)"two", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((int)2, (int)queue.size());
        EvictingQueueTest.assertEquals((int)1, (int)queue.remainingCapacity());
    }

    public void testAddAll_largeList() {
        ImmutableList list = ImmutableList.of((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five");
        AbstractList<String> misbehavingList = new AbstractList<String>((List)list){
            final /* synthetic */ List val$list;
            {
                this.val$list = list;
            }

            @Override
            public int size() {
                return this.val$list.size();
            }

            @Override
            public String get(int index) {
                if (index < 2) {
                    throw new AssertionError();
                }
                return (String)this.val$list.get(index);
            }
        };
        EvictingQueue queue = EvictingQueue.create((int)3);
        EvictingQueueTest.assertTrue((boolean)queue.addAll((Collection)misbehavingList));
        EvictingQueueTest.assertEquals((String)"three", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((String)"four", (String)((String)queue.remove()));
        EvictingQueueTest.assertEquals((String)"five", (String)((String)queue.remove()));
        EvictingQueueTest.assertTrue((boolean)queue.isEmpty());
    }

    @GwtIncompatible
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(EvictingQueue.class);
        tester.testAllPublicConstructors(EvictingQueue.class);
        EvictingQueue queue = EvictingQueue.create((int)5);
        queue.add((Object)"one");
        tester.testAllPublicInstanceMethods((Object)queue);
    }

    public void testSerialization() {
        EvictingQueue original = EvictingQueue.create((int)5);
        original.add((Object)"one");
        original.add((Object)"two");
        original.add((Object)"three");
        EvictingQueue copy = (EvictingQueue)SerializableTester.reserialize((Object)original);
        EvictingQueueTest.assertEquals((int)copy.maxSize, (int)original.maxSize);
        EvictingQueueTest.assertEquals((String)"one", (String)((String)copy.remove()));
        EvictingQueueTest.assertEquals((String)"two", (String)((String)copy.remove()));
        EvictingQueueTest.assertEquals((String)"three", (String)((String)copy.remove()));
        EvictingQueueTest.assertTrue((boolean)copy.isEmpty());
    }
}

