/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingListTest
extends ForwardingTestCase {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private List<String> forward;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingListTest.class);
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return new StandardImplForwardingList(Lists.newArrayList((Object[])elements));
            }
        }).named("ForwardingList[ArrayList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, ListFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return new StandardImplForwardingList(ImmutableList.copyOf((Object[])elements));
            }
        }).named("ForwardingList[ImmutableList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        final List list = this.createProxyInstance(List.class);
        this.forward = new ForwardingList<String>(){

            protected List<String> delegate() {
                return list;
            }
        };
    }

    public void testAdd_T() {
        this.forward.add("asdf");
        ForwardingListTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAdd_int_T() {
        this.forward.add(0, "asdf");
        ForwardingListTest.assertEquals((String)"[add(int,Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward.addAll(EMPTY_LIST);
        ForwardingListTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testAddAll_int_Collection() {
        this.forward.addAll(0, Collections.singleton("asdf"));
        ForwardingListTest.assertEquals((String)"[addAll(int,Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingListTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_Object() {
        this.forward.contains(null);
        ForwardingListTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward.containsAll(EMPTY_LIST);
        ForwardingListTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testGet_int() {
        this.forward.get(0);
        ForwardingListTest.assertEquals((String)"[get(int)]", (String)this.getCalls());
    }

    public void testIndexOf_Object() {
        this.forward.indexOf(null);
        ForwardingListTest.assertEquals((String)"[indexOf(Object)]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward.isEmpty();
        ForwardingListTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward.iterator();
        ForwardingListTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testLastIndexOf_Object() {
        this.forward.lastIndexOf("asdf");
        ForwardingListTest.assertEquals((String)"[lastIndexOf(Object)]", (String)this.getCalls());
    }

    public void testListIterator() {
        this.forward.listIterator();
        ForwardingListTest.assertEquals((String)"[listIterator]", (String)this.getCalls());
    }

    public void testListIterator_int() {
        this.forward.listIterator(0);
        ForwardingListTest.assertEquals((String)"[listIterator(int)]", (String)this.getCalls());
    }

    public void testRemove_int() {
        this.forward.remove(0);
        ForwardingListTest.assertEquals((String)"[remove(int)]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward.remove(null);
        ForwardingListTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward.removeAll(EMPTY_LIST);
        ForwardingListTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward.retainAll(EMPTY_LIST);
        ForwardingListTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSet_int_T() {
        this.forward.set(0, "asdf");
        ForwardingListTest.assertEquals((String)"[set(int,Object)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward.size();
        ForwardingListTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testSubList_int_int() {
        this.forward.subList(0, 1);
        ForwardingListTest.assertEquals((String)"[subList(int,int)]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward.toArray();
        ForwardingListTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward.toArray(new String[0]);
        ForwardingListTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testEquals_Object() {
        this.forward.equals("asdf");
        ForwardingListTest.assertEquals((String)"[equals(Object)]", (String)this.getCalls());
    }

    public void testHashCode() {
        this.forward.hashCode();
        ForwardingListTest.assertEquals((String)"[hashCode]", (String)this.getCalls());
    }

    public void testRandomAccess() {
        Truth.assertThat(this.forward).isNotInstanceOf(RandomAccess.class);
    }

    public void testToString() {
        this.forward.toString();
        ForwardingListTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    static final class StandardImplForwardingList<T>
    extends ForwardingList<T> {
        private final List<T> backingList;

        StandardImplForwardingList(List<T> backingList) {
            this.backingList = backingList;
        }

        protected List<T> delegate() {
            return this.backingList;
        }

        public boolean add(T element) {
            return this.standardAdd(element);
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public boolean addAll(int index, Collection<? extends T> elements) {
            return this.standardAddAll(index, elements);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public int indexOf(Object element) {
            return this.standardIndexOf(element);
        }

        public int lastIndexOf(Object element) {
            return this.standardLastIndexOf(element);
        }

        public Iterator<T> iterator() {
            return this.listIterator();
        }

        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        public ListIterator<T> listIterator(int index) {
            return this.standardListIterator(index);
        }

        public List<T> subList(int fromIndex, int toIndex) {
            return this.standardSubList(fromIndex, toIndex);
        }
    }
}

