/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ForwardingMultimapTest
extends ForwardingTestCase {
    Multimap<String, Boolean> forward;

    public void setUp() throws Exception {
        super.setUp();
        final Multimap multimap = this.createProxyInstance(Multimap.class);
        this.forward = new ForwardingMultimap<String, Boolean>(){

            protected Multimap<String, Boolean> delegate() {
                return multimap;
            }
        };
    }

    public void testSize() {
        int unused = this.forward.size();
        ForwardingMultimapTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        boolean unused = this.forward.isEmpty();
        ForwardingMultimapTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testContainsKey_Object() {
        boolean unused = this.forward.containsKey((Object)"asdf");
        ForwardingMultimapTest.assertEquals((String)"[containsKey(Object)]", (String)this.getCalls());
    }

    public void testContainsValue_Object() {
        boolean unused = this.forward.containsValue((Object)"asdf");
        ForwardingMultimapTest.assertEquals((String)"[containsValue(Object)]", (String)this.getCalls());
    }

    public void testContainsEntry_Object_Object() {
        boolean unused = this.forward.containsEntry((Object)"asdf", (Object)false);
        ForwardingMultimapTest.assertEquals((String)"[containsEntry(Object,Object)]", (String)this.getCalls());
    }

    public void testPut_Key_Value() {
        this.forward.put((Object)"asdf", (Object)true);
        ForwardingMultimapTest.assertEquals((String)"[put(Object,Object)]", (String)this.getCalls());
    }

    public void testRemove_Key_Value() {
        this.forward.remove((Object)"asdf", (Object)false);
        ForwardingMultimapTest.assertEquals((String)"[remove(Object,Object)]", (String)this.getCalls());
    }

    public void testPutAll_Key_Iterable() {
        this.forward.remove((Object)"asfd", Collections.emptyList());
        ForwardingMultimapTest.assertEquals((String)"[remove(Object,Object)]", (String)this.getCalls());
    }

    public void testPutAll_Multimap() {
        this.forward.putAll((Multimap)ArrayListMultimap.create());
        ForwardingMultimapTest.assertEquals((String)"[putAll(Multimap)]", (String)this.getCalls());
    }

    public void testReplaceValues_Key_Iterable() {
        this.forward.replaceValues((Object)"key", Collections.emptyList());
        ForwardingMultimapTest.assertEquals((String)"[replaceValues(Object,Iterable)]", (String)this.getCalls());
    }

    public void testRemoveAll_Object() {
        this.forward.removeAll((Object)"key");
        ForwardingMultimapTest.assertEquals((String)"[removeAll(Object)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingMultimapTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testGet_Key() {
        Collection unused = this.forward.get(null);
        ForwardingMultimapTest.assertEquals((String)"[get(Object)]", (String)this.getCalls());
    }

    public void testKeySet() {
        Set unused = this.forward.keySet();
        ForwardingMultimapTest.assertEquals((String)"[keySet]", (String)this.getCalls());
    }

    public void testKeys() {
        Multiset unused = this.forward.keys();
        ForwardingMultimapTest.assertEquals((String)"[keys]", (String)this.getCalls());
    }

    public void testValues() {
        Collection unused = this.forward.values();
        ForwardingMultimapTest.assertEquals((String)"[values]", (String)this.getCalls());
    }

    public void testEntries() {
        Collection unused = this.forward.entries();
        ForwardingMultimapTest.assertEquals((String)"[entries]", (String)this.getCalls());
    }

    public void testAsMap() {
        Map unused = this.forward.asMap();
        ForwardingMultimapTest.assertEquals((String)"[asMap]", (String)this.getCalls());
    }

    public void testEquals() {
        boolean unused = this.forward.equals(null);
        ForwardingMultimapTest.assertEquals((String)"[equals(Object)]", (String)this.getCalls());
    }

    public void testHashCode() {
        int unused = this.forward.hashCode();
        ForwardingMultimapTest.assertEquals((String)"[hashCode]", (String)this.getCalls());
    }

    public void testToString() {
        String unused = this.forward.toString();
        ForwardingMultimapTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }
}

