/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class HashMultisetAddPresentBenchmark {
    private static final int ARRAY_MASK = 65535;
    private static final int ARRAY_SIZE = 65536;
    List<Multiset<Integer>> multisets = new ArrayList<Multiset<Integer>>(65536);
    int[] queries = new int[65536];

    @BeforeExperiment
    void setUp() {
        Random random = new Random();
        this.multisets.clear();
        for (int i = 0; i < 65536; ++i) {
            HashMultiset multiset = HashMultiset.create();
            this.multisets.add((Multiset<Integer>)multiset);
            this.queries[i] = random.nextInt();
            multiset.add((Object)this.queries[i]);
        }
    }

    @Benchmark
    int add(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += this.multisets.get(j).add((Object)this.queries[j], 4);
        }
        return tmp;
    }
}

