/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableEnumMapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ImmutableEnumMapGenerator()).named("Maps.immutableEnumMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableEnumMapTest.class);
        return suite;
    }

    public void testEmptyImmutableEnumMap() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of());
        ImmutableEnumMapTest.assertEquals((Object)ImmutableMap.of(), (Object)map);
    }

    public void testImmutableEnumMapOrdering() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)AnEnum.C, (Object)"c", (Object)AnEnum.A, (Object)"a", (Object)AnEnum.E, (Object)"e"));
        Truth.assertThat((Iterable)map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)AnEnum.A, (Object)"a"), Helpers.mapEntry((Object)AnEnum.C, (Object)"c"), Helpers.mapEntry((Object)AnEnum.E, (Object)"e")}).inOrder();
    }

    public static class ImmutableEnumMapGenerator
    extends TestEnumMapGenerator {
        protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<AnEnum, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return Maps.immutableEnumMap((Map)map);
        }
    }
}

