/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LenientSerializableTester;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.ListMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestListMultimapGenerator;
import com.google.common.collect.testing.google.TestStringListMultimapGenerator;
import com.google.common.collect.testing.google.UnmodifiableCollectionTests;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableListMultimapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new ImmutableListMultimapGenerator()).named("ImmutableListMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new ImmutableListMultimapCopyOfEntriesGenerator()).named("ImmutableListMultimap.copyOf[Iterable<Entry>]")).withFeatures(new Feature[]{MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTestSuite(ImmutableListMultimapTest.class);
        return suite;
    }

    public void testBuilder_withImmutableEntry() {
        ImmutableListMultimap multimap = new ImmutableListMultimap.Builder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1), (Object)multimap.get((Object)"one"));
    }

    public void testBuilder_withImmutableEntryAndNullContents() {
        ImmutableListMultimap.Builder builder = new ImmutableListMultimap.Builder();
        try {
            builder.put(Maps.immutableEntry((Object)"one", (Object)null));
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.put(Maps.immutableEntry((Object)null, (Object)1));
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilder_withMutableEntry() {
        ImmutableListMultimap.Builder builder = new ImmutableListMultimap.Builder();
        final StringHolder holder = new StringHolder();
        holder.string = "one";
        AbstractMapEntry<String, Integer> entry = new AbstractMapEntry<String, Integer>(){

            public String getKey() {
                return holder.string;
            }

            public Integer getValue() {
                return 1;
            }
        };
        builder.put((Map.Entry)entry);
        holder.string = "two";
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1), (Object)builder.build().get((Object)"one"));
    }

    public void testBuilderPutAllIterable() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)"foo", Arrays.asList(1, 2, 3));
        builder.putAll((Object)"bar", Arrays.asList(4, 5));
        builder.putAll((Object)"foo", Arrays.asList(6, 7));
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 3, 6, 7), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllVarargs() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.putAll((Object)"foo", (Object[])new Integer[]{6, 7});
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 3, 6, 7), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllMultimap() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)4);
        toPut.put((Object)"foo", (Object)2);
        toPut.put((Object)"foo", (Object)3);
        LinkedListMultimap moreToPut = LinkedListMultimap.create();
        moreToPut.put((Object)"foo", (Object)6);
        moreToPut.put((Object)"bar", (Object)5);
        moreToPut.put((Object)"foo", (Object)7);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Multimap)toPut);
        builder.putAll((Multimap)moreToPut);
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 3, 6, 7), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllWithDuplicates() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 6, 7});
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 3, 1, 6, 7), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)8, (int)multimap.size());
    }

    public void testBuilderPutWithDuplicates() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.put((Object)"foo", (Object)1);
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 3, 1), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)6, (int)multimap.size());
    }

    public void testBuilderPutAllMultimapWithDuplicates() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)4);
        toPut.put((Object)"foo", (Object)2);
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)5);
        LinkedListMultimap moreToPut = LinkedListMultimap.create();
        moreToPut.put((Object)"foo", (Object)6);
        moreToPut.put((Object)"bar", (Object)4);
        moreToPut.put((Object)"foo", (Object)7);
        moreToPut.put((Object)"foo", (Object)2);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Multimap)toPut);
        builder.putAll((Multimap)moreToPut);
        ImmutableListMultimap multimap = builder.build();
        ImmutableListMultimapTest.assertEquals(Arrays.asList(1, 2, 1, 6, 7, 2), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals(Arrays.asList(4, 5, 4), (Object)multimap.get((Object)"bar"));
        ImmutableListMultimapTest.assertEquals((int)9, (int)multimap.size());
    }

    public void testBuilderPutNullKey() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", null);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        try {
            builder.put(null, (Object)1);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll(null, Arrays.asList(1, 2, 3));
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll(null, (Object[])new Integer[]{1, 2, 3});
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll((Multimap)toPut);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderPutNullValue() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put(null, (Object)1);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        try {
            builder.put((Object)"foo", null);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll((Object)"foo", Arrays.asList(1, null, 3));
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll((Object)"foo", (Object[])new Integer[]{1, null, 3});
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.putAll((Multimap)toPut);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderOrderKeysBy() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableListMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "c", "b", "a"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 4, 3, 6, 5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{3, 6}).inOrder();
    }

    public void testBuilderOrderKeysByDuplicates() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.put((Object)"bb", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy((Comparator)new Ordering<String>(){

            public int compare(String left, String right) {
                return left.length() - right.length();
            }
        });
        builder.put((Object)"cc", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"bb", (Object)6);
        ImmutableListMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "a", "bb", "cc"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 5, 2, 3, 6, 4}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"bb")).containsExactly(new Object[]{3, 6}).inOrder();
    }

    public void testBuilderOrderValuesBy() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderValuesBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableListMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"b", "d", "a", "c"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{6, 3, 2, 5, 2, 4}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{6, 3}).inOrder();
    }

    public void testBuilderOrderKeysAndValuesBy() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy(Collections.reverseOrder());
        builder.orderValuesBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableListMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "c", "b", "a"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 4, 6, 3, 5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{6, 3}).inOrder();
    }

    public void testCopyOf() {
        ArrayListMultimap input = ArrayListMultimap.create();
        input.put((Object)"foo", (Object)1);
        input.put((Object)"bar", (Object)2);
        input.put((Object)"foo", (Object)3);
        ImmutableListMultimap multimap = ImmutableListMultimap.copyOf((Multimap)input);
        ImmutableListMultimapTest.assertEquals((Object)multimap, (Object)input);
        ImmutableListMultimapTest.assertEquals((Object)input, (Object)multimap);
    }

    public void testCopyOfWithDuplicates() {
        ArrayListMultimap input = ArrayListMultimap.create();
        input.put((Object)"foo", (Object)1);
        input.put((Object)"bar", (Object)2);
        input.put((Object)"foo", (Object)3);
        input.put((Object)"foo", (Object)1);
        ImmutableListMultimap multimap = ImmutableListMultimap.copyOf((Multimap)input);
        ImmutableListMultimapTest.assertEquals((Object)multimap, (Object)input);
        ImmutableListMultimapTest.assertEquals((Object)input, (Object)multimap);
    }

    public void testCopyOfEmpty() {
        ArrayListMultimap input = ArrayListMultimap.create();
        ImmutableListMultimap multimap = ImmutableListMultimap.copyOf((Multimap)input);
        ImmutableListMultimapTest.assertEquals((Object)multimap, (Object)input);
        ImmutableListMultimapTest.assertEquals((Object)input, (Object)multimap);
    }

    public void testCopyOfImmutableListMultimap() {
        Multimap<String, Integer> multimap = this.createMultimap();
        ImmutableListMultimapTest.assertSame(multimap, (Object)ImmutableListMultimap.copyOf(multimap));
    }

    public void testCopyOfNullKey() {
        ArrayListMultimap input = ArrayListMultimap.create();
        input.put(null, (Object)1);
        try {
            ImmutableListMultimap.copyOf((Multimap)input);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOfNullValue() {
        ArrayListMultimap input = ArrayListMultimap.create();
        input.putAll((Object)"foo", Arrays.asList(1, null, 3));
        try {
            ImmutableListMultimap.copyOf((Multimap)input);
            ImmutableListMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEmptyMultimapReads() {
        ImmutableListMultimap multimap = ImmutableListMultimap.of();
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsValue((Object)1));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"foo", (Object)1));
        ImmutableListMultimapTest.assertTrue((boolean)multimap.entries().isEmpty());
        ImmutableListMultimapTest.assertTrue((boolean)multimap.equals((Object)ArrayListMultimap.create()));
        ImmutableListMultimapTest.assertEquals(Collections.emptyList(), (Object)multimap.get((Object)"foo"));
        ImmutableListMultimapTest.assertEquals((int)0, (int)multimap.hashCode());
        ImmutableListMultimapTest.assertTrue((boolean)multimap.isEmpty());
        ImmutableListMultimapTest.assertEquals((Object)HashMultiset.create(), (Object)multimap.keys());
        ImmutableListMultimapTest.assertEquals(Collections.emptySet(), (Object)multimap.keySet());
        ImmutableListMultimapTest.assertEquals((int)0, (int)multimap.size());
        ImmutableListMultimapTest.assertTrue((boolean)multimap.values().isEmpty());
        ImmutableListMultimapTest.assertEquals((String)"{}", (String)multimap.toString());
    }

    public void testEmptyMultimapWrites() {
        ImmutableListMultimap multimap = ImmutableListMultimap.of();
        UnmodifiableCollectionTests.assertMultimapIsUnmodifiable((Multimap)multimap, (Object)"foo", (Object)1);
    }

    private Multimap<String, Integer> createMultimap() {
        return ImmutableListMultimap.builder().put((Object)"foo", (Object)1).put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).build();
    }

    public void testMultimapReads() {
        Multimap<String, Integer> multimap = this.createMultimap();
        ImmutableListMultimapTest.assertTrue((boolean)multimap.containsKey((Object)"foo"));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"cat"));
        ImmutableListMultimapTest.assertTrue((boolean)multimap.containsValue((Object)1));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsValue((Object)5));
        ImmutableListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)1));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"cat", (Object)1));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"foo", (Object)5));
        ImmutableListMultimapTest.assertFalse((boolean)multimap.entries().isEmpty());
        ImmutableListMultimapTest.assertEquals((int)3, (int)multimap.size());
        ImmutableListMultimapTest.assertFalse((boolean)multimap.isEmpty());
        ImmutableListMultimapTest.assertEquals((String)"{foo=[1, 3], bar=[2]}", (String)multimap.toString());
    }

    public void testMultimapWrites() {
        Multimap<String, Integer> multimap = this.createMultimap();
        UnmodifiableCollectionTests.assertMultimapIsUnmodifiable(multimap, (Object)"bar", (Object)2);
    }

    public void testMultimapEquals() {
        Multimap<String, Integer> multimap = this.createMultimap();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        arrayListMultimap.putAll((Object)"foo", Arrays.asList(1, 3));
        arrayListMultimap.put((Object)"bar", (Object)2);
        new EqualsTester().addEqualityGroup(new Object[]{multimap, this.createMultimap(), arrayListMultimap, ImmutableListMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)1).put((Object)"foo", (Object)3).build()}).addEqualityGroup(new Object[]{ImmutableListMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).put((Object)"foo", (Object)1).build()}).addEqualityGroup(new Object[]{ImmutableListMultimap.builder().put((Object)"foo", (Object)2).put((Object)"foo", (Object)3).put((Object)"foo", (Object)1).build()}).addEqualityGroup(new Object[]{ImmutableListMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).build()}).testEquals();
    }

    public void testOf() {
        ImmutableListMultimapTest.assertMultimapEquals(ImmutableListMultimap.of((Object)"one", (Object)1), new Object[]{"one", 1});
        ImmutableListMultimapTest.assertMultimapEquals(ImmutableListMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2), new Object[]{"one", 1, "two", 2});
        ImmutableListMultimapTest.assertMultimapEquals(ImmutableListMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3), new Object[]{"one", 1, "two", 2, "three", 3});
        ImmutableListMultimapTest.assertMultimapEquals(ImmutableListMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
        ImmutableListMultimapTest.assertMultimapEquals(ImmutableListMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4, (Object)"five", (Object)5), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
    }

    public void testInverse() {
        ImmutableListMultimapTest.assertEquals((Object)ImmutableListMultimap.of(), (Object)ImmutableListMultimap.of().inverse());
        ImmutableListMultimapTest.assertEquals((Object)ImmutableListMultimap.of((Object)1, (Object)"one"), (Object)ImmutableListMultimap.of((Object)"one", (Object)1).inverse());
        ImmutableListMultimapTest.assertEquals((Object)ImmutableListMultimap.of((Object)1, (Object)"one", (Object)2, (Object)"two"), (Object)ImmutableListMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2).inverse());
        ImmutableListMultimapTest.assertEquals((Object)ImmutableListMultimap.of((Object)"of", (Object)Character.valueOf('o'), (Object)"of", (Object)Character.valueOf('f'), (Object)"to", (Object)Character.valueOf('t'), (Object)"to", (Object)Character.valueOf('o')).inverse(), (Object)ImmutableListMultimap.of((Object)Character.valueOf('o'), (Object)"of", (Object)Character.valueOf('f'), (Object)"of", (Object)Character.valueOf('t'), (Object)"to", (Object)Character.valueOf('o'), (Object)"to"));
        ImmutableListMultimapTest.assertEquals((Object)ImmutableListMultimap.of((Object)Character.valueOf('f'), (Object)"foo", (Object)Character.valueOf('o'), (Object)"foo", (Object)Character.valueOf('o'), (Object)"foo"), (Object)ImmutableListMultimap.of((Object)"foo", (Object)Character.valueOf('f'), (Object)"foo", (Object)Character.valueOf('o'), (Object)"foo", (Object)Character.valueOf('o')).inverse());
    }

    public void testInverseMinimizesWork() {
        ImmutableListMultimap multimap = ImmutableListMultimap.builder().put((Object)"foo", (Object)Character.valueOf('f')).put((Object)"foo", (Object)Character.valueOf('o')).put((Object)"foo", (Object)Character.valueOf('o')).put((Object)"poo", (Object)Character.valueOf('p')).put((Object)"poo", (Object)Character.valueOf('o')).put((Object)"poo", (Object)Character.valueOf('o')).build();
        ImmutableListMultimapTest.assertSame((Object)multimap.inverse(), (Object)multimap.inverse());
        ImmutableListMultimapTest.assertSame((Object)multimap, (Object)multimap.inverse().inverse());
    }

    private static <K, V> void assertMultimapEquals(Multimap<K, V> multimap, Object ... alternatingKeysAndValues) {
        ImmutableListMultimapTest.assertEquals((int)multimap.size(), (int)(alternatingKeysAndValues.length / 2));
        int i = 0;
        for (Map.Entry entry : multimap.entries()) {
            ImmutableListMultimapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getKey());
            ImmutableListMultimapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getValue());
        }
    }

    @GwtIncompatible
    public void testSerialization() {
        Multimap<String, Integer> multimap = this.createMultimap();
        SerializableTester.reserializeAndAssert(multimap);
        ImmutableListMultimapTest.assertEquals((int)multimap.size(), (int)((Multimap)SerializableTester.reserialize(multimap)).size());
        SerializableTester.reserializeAndAssert((Object)multimap.get((Object)"foo"));
        LenientSerializableTester.reserializeAndAssertLenient(multimap.keySet());
        LenientSerializableTester.reserializeAndAssertLenient(multimap.keys());
        SerializableTester.reserializeAndAssert((Object)multimap.asMap());
        Collection valuesCopy = (Collection)SerializableTester.reserialize((Object)multimap.values());
        ImmutableListMultimapTest.assertEquals((Object)HashMultiset.create((Iterable)multimap.values()), (Object)HashMultiset.create((Iterable)valuesCopy));
    }

    @GwtIncompatible
    public void testEmptySerialization() {
        ImmutableListMultimap multimap = ImmutableListMultimap.of();
        ImmutableListMultimapTest.assertSame((Object)multimap, (Object)SerializableTester.reserialize((Object)multimap));
    }

    private static class StringHolder {
        String string;

        private StringHolder() {
        }
    }

    public static class ImmutableListMultimapCopyOfEntriesGenerator
    extends TestStringListMultimapGenerator {
        protected ListMultimap<String, String> create(Map.Entry<String, String>[] entries) {
            return ImmutableListMultimap.copyOf(Arrays.asList(entries));
        }
    }

    public static class ImmutableListMultimapGenerator
    extends TestStringListMultimapGenerator {
        protected ListMultimap<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (Map.Entry<String, String> entry : entries) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

