/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractRangeSetTest;
import com.google.common.collect.AndroidIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtIncompatible
public class ImmutableRangeSetTest
extends AbstractRangeSetTest {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableRangeSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new ImmutableRangeSetIntegerAsSetGenerator()).named("ImmutableRangeSet.asSet[DiscreteDomain.integers[]]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.SERIALIZABLE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new ImmutableRangeSetBigIntegerAsSetGenerator()).named("ImmutableRangeSet.asSet[DiscreteDomain.bigIntegers[]]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.SERIALIZABLE})).createTestSuite());
        return suite;
    }

    public void testEmpty() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.of();
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
        ImmutableRangeSetTest.assertEquals((Object)ImmutableRangeSet.all(), (Object)rangeSet.complement());
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(0)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.singleton((Comparable)Integer.valueOf(0))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.singleton((Comparable)Integer.valueOf(0))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.enclosesAll((RangeSet)rangeSet));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.isEmpty());
    }

    public void testAll() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.all();
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.all());
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(0)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.singleton((Comparable)Integer.valueOf(0))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.all()));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.all()));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.enclosesAll((RangeSet)rangeSet));
        ImmutableRangeSetTest.assertEquals((Object)ImmutableRangeSet.of(), (Object)rangeSet.complement());
    }

    public void testSingleBoundedRange() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.of((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)));
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(7))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.greaterThan((Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(3)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(5)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(0)));
        TreeRangeSet expectedComplement = TreeRangeSet.create();
        expectedComplement.add(Range.lessThan((Comparable)Integer.valueOf(1)));
        expectedComplement.add(Range.atLeast((Comparable)Integer.valueOf(5)));
        ImmutableRangeSetTest.assertEquals((Object)expectedComplement, (Object)rangeSet.complement());
    }

    public void testSingleBoundedBelowRange() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.of((Range)Range.greaterThan((Comparable)Integer.valueOf(2)));
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.greaterThan((Comparable)Integer.valueOf(2)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.lessThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(3))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.greaterThan((Comparable)Integer.valueOf(3))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(3)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(5)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(0)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(2)));
        ImmutableRangeSetTest.assertEquals((Object)ImmutableRangeSet.of((Range)Range.atMost((Comparable)Integer.valueOf(2))), (Object)rangeSet.complement());
    }

    public void testSingleBoundedAboveRange() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.of((Range)Range.atMost((Comparable)Integer.valueOf(3)));
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.atMost((Comparable)Integer.valueOf(3)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.lessThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(3))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.lessThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(3)));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(0)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(4)));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(5)));
        ImmutableRangeSetTest.assertEquals((Object)ImmutableRangeSet.of((Range)Range.greaterThan((Comparable)Integer.valueOf(3))), (Object)rangeSet.complement());
    }

    public void testMultipleBoundedRanges() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))}).inOrder();
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.open((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.open((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSet expectedComplement = ImmutableRangeSet.builder().add(Range.lessThan((Comparable)Integer.valueOf(1))).add(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5))).add(Range.greaterThan((Comparable)Integer.valueOf(8))).build();
        ImmutableRangeSetTest.assertEquals((Object)expectedComplement, (Object)rangeSet.complement());
    }

    public void testMultipleBoundedBelowRanges() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.greaterThan((Comparable)Integer.valueOf(6))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.lessThan((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSet expectedComplement = ImmutableRangeSet.builder().add(Range.lessThan((Comparable)Integer.valueOf(1))).add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))).build();
        ImmutableRangeSetTest.assertEquals((Object)expectedComplement, (Object)rangeSet.complement());
    }

    public void testMultipleBoundedAboveRanges() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.atMost((Comparable)Integer.valueOf(0))).add(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))).build();
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.atMost((Comparable)Integer.valueOf(0)), Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))}).inOrder();
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.open((Comparable)Integer.valueOf(-5), (Comparable)Integer.valueOf(-2))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.intersects(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.singleton((Comparable)Integer.valueOf(1))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.intersects(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        ImmutableRangeSetTest.assertTrue((boolean)rangeSet.encloses(Range.open((Comparable)Integer.valueOf(-5), (Comparable)Integer.valueOf(-2))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8))));
        ImmutableRangeSetTest.assertFalse((boolean)rangeSet.encloses(Range.greaterThan((Comparable)Integer.valueOf(5))));
        ImmutableRangeSet expectedComplement = ImmutableRangeSet.builder().add(Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2))).add(Range.atLeast((Comparable)Integer.valueOf(5))).build();
        ImmutableRangeSetTest.assertEquals((Object)expectedComplement, (Object)rangeSet.complement());
    }

    public void testAddUnsupported() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        try {
            rangeSet.add(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4)));
            ImmutableRangeSetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddAllUnsupported() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        try {
            rangeSet.addAll((RangeSet)ImmutableRangeSet.of());
            ImmutableRangeSetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveUnsupported() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        try {
            rangeSet.remove(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7)));
            ImmutableRangeSetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveAllUnsupported() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8))).add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3))).build();
        try {
            rangeSet.removeAll((RangeSet)ImmutableRangeSet.of());
            ImmutableRangeSetTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            rangeSet.removeAll((RangeSet)ImmutableRangeSet.of((Range)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
            ImmutableRangeSetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @AndroidIncompatible
    public void testExhaustive() {
        ImmutableSet ranges = ImmutableSet.of((Object)Range.all(), (Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)Range.singleton((Comparable)Integer.valueOf(1)), (Object)Range.lessThan((Comparable)Integer.valueOf(2)), (Object)Range.greaterThan((Comparable)Integer.valueOf(10)), (Object)Range.atMost((Comparable)Integer.valueOf(4)), (Object[])new Range[]{Range.atLeast((Comparable)Integer.valueOf(3)), Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)), Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), Range.openClosed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))});
        for (Set subset : Sets.powerSet((Set)ranges)) {
            TreeRangeSet mutable = TreeRangeSet.create();
            ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
            for (Range range : subset) {
                boolean overlaps = false;
                for (Range other : mutable.asRanges()) {
                    if (!other.isConnected(range) || other.intersection(range).isEmpty()) continue;
                    overlaps = true;
                }
                try {
                    builder.add(range);
                    ImmutableRangeSetTest.assertFalse((boolean)overlaps);
                    mutable.add(range);
                }
                catch (IllegalArgumentException e) {
                    ImmutableRangeSetTest.assertTrue((boolean)overlaps);
                }
            }
            ImmutableRangeSet built = builder.build();
            ImmutableRangeSetTest.assertEquals((Object)mutable, (Object)built);
            ImmutableRangeSetTest.assertEquals((Object)ImmutableRangeSet.copyOf((RangeSet)mutable), (Object)built);
            ImmutableRangeSetTest.assertEquals((Object)mutable.complement(), (Object)built.complement());
            for (int i = 0; i <= 11; ++i) {
                ImmutableRangeSetTest.assertEquals((boolean)mutable.contains((Comparable)Integer.valueOf(i)), (boolean)built.contains((Comparable)Integer.valueOf(i)));
            }
            SerializableTester.reserializeAndAssert((Object)built);
            SerializableTester.reserializeAndAssert((Object)built.asRanges());
        }
    }

    public void testAsSet() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))).add(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7))).add(Range.closedOpen((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))).add(Range.openClosed((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(17))).build();
        ImmutableSortedSet expectedSet = ImmutableSortedSet.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(16), (Comparable[])new Integer[]{17});
        ImmutableSortedSet asSet = rangeSet.asSet(DiscreteDomain.integers());
        ImmutableRangeSetTest.assertEquals((Object)expectedSet, (Object)asSet);
        Truth.assertThat((Iterable)asSet).containsExactlyElementsIn((Iterable)expectedSet).inOrder();
        ImmutableRangeSetTest.assertTrue((boolean)asSet.containsAll((Collection)expectedSet));
        SerializableTester.reserializeAndAssert((Object)asSet);
    }

    public void testAsSetHeadSet() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))).add(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7))).add(Range.closedOpen((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))).add(Range.openClosed((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(17))).build();
        ImmutableSortedSet expectedSet = ImmutableSortedSet.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(16), (Comparable[])new Integer[]{17});
        ImmutableSortedSet asSet = rangeSet.asSet(DiscreteDomain.integers());
        for (int i = 0; i <= 20; ++i) {
            ImmutableRangeSetTest.assertEquals((Object)asSet.headSet((Object)i, false), (Object)expectedSet.headSet((Object)i, false));
            ImmutableRangeSetTest.assertEquals((Object)asSet.headSet((Object)i, true), (Object)expectedSet.headSet((Object)i, true));
        }
    }

    public void testAsSetTailSet() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))).add(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7))).add(Range.closedOpen((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))).add(Range.openClosed((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(17))).build();
        ImmutableSortedSet expectedSet = ImmutableSortedSet.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(16), (Comparable[])new Integer[]{17});
        ImmutableSortedSet asSet = rangeSet.asSet(DiscreteDomain.integers());
        for (int i = 0; i <= 20; ++i) {
            ImmutableRangeSetTest.assertEquals((Object)asSet.tailSet((Object)i, false), (Object)expectedSet.tailSet((Object)i, false));
            ImmutableRangeSetTest.assertEquals((Object)asSet.tailSet((Object)i, true), (Object)expectedSet.tailSet((Object)i, true));
        }
    }

    public void testAsSetSubSet() {
        ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))).add(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7))).add(Range.closedOpen((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))).add(Range.openClosed((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(17))).build();
        ImmutableSortedSet expectedSet = ImmutableSortedSet.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(16), (Comparable[])new Integer[]{17});
        ImmutableSortedSet asSet = rangeSet.asSet(DiscreteDomain.integers());
        for (int i = 0; i <= 20; ++i) {
            for (int j = i + 1; j <= 20; ++j) {
                ImmutableRangeSetTest.assertEquals((Object)expectedSet.subSet((Object)i, false, (Object)j, false), (Object)asSet.subSet((Object)i, false, (Object)j, false));
                ImmutableRangeSetTest.assertEquals((Object)expectedSet.subSet((Object)i, true, (Object)j, false), (Object)asSet.subSet((Object)i, true, (Object)j, false));
                ImmutableRangeSetTest.assertEquals((Object)expectedSet.subSet((Object)i, false, (Object)j, true), (Object)asSet.subSet((Object)i, false, (Object)j, true));
                ImmutableRangeSetTest.assertEquals((Object)expectedSet.subSet((Object)i, true, (Object)j, true), (Object)asSet.subSet((Object)i, true, (Object)j, true));
            }
        }
    }

    public void testSubRangeSet() {
        ImmutableList.Builder rangesBuilder = ImmutableList.builder();
        rangesBuilder.add((Object)Range.all());
        for (int i = -2; i <= 2; ++i) {
            for (BoundType boundType : BoundType.values()) {
                rangesBuilder.add((Object)Range.upTo((Comparable)Integer.valueOf(i), (BoundType)boundType));
                rangesBuilder.add((Object)Range.downTo((Comparable)Integer.valueOf(i), (BoundType)boundType));
            }
            for (int j = i + 1; j <= 2; ++j) {
                for (BoundType lbType : BoundType.values()) {
                    for (BoundType ubType : BoundType.values()) {
                        rangesBuilder.add((Object)Range.range((Comparable)Integer.valueOf(i), (BoundType)lbType, (Comparable)Integer.valueOf(j), (BoundType)ubType));
                    }
                }
            }
        }
        ImmutableList ranges = rangesBuilder.build();
        for (int i = -2; i <= 2; ++i) {
            rangesBuilder.add((Object)Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)));
            rangesBuilder.add((Object)Range.openClosed((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)));
        }
        ImmutableList subRanges = rangesBuilder.build();
        for (Range range1 : ranges) {
            for (Range range2 : ranges) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                ImmutableRangeSet rangeSet = ImmutableRangeSet.builder().add(range1).add(range2).build();
                for (Range subRange : subRanges) {
                    TreeRangeSet expected = TreeRangeSet.create();
                    for (Range range : rangeSet.asRanges()) {
                        if (!range.isConnected(subRange)) continue;
                        expected.add(range.intersection(subRange));
                    }
                    ImmutableRangeSet subRangeSet = rangeSet.subRangeSet(subRange);
                    ImmutableRangeSetTest.assertEquals((Object)expected, (Object)subRangeSet);
                    ImmutableRangeSetTest.assertEquals((Object)expected.asRanges(), (Object)subRangeSet.asRanges());
                    if (!expected.isEmpty()) {
                        ImmutableRangeSetTest.assertEquals((Object)expected.span(), (Object)subRangeSet.span());
                    }
                    for (int i = -3; i <= 3; ++i) {
                        ImmutableRangeSetTest.assertEquals((boolean)expected.contains((Comparable)Integer.valueOf(i)), (boolean)subRangeSet.contains((Comparable)Integer.valueOf(i)));
                    }
                }
            }
        }
    }

    static final class ImmutableRangeSetBigIntegerAsSetGenerator
    implements TestSetGenerator<BigInteger> {
        ImmutableRangeSetBigIntegerAsSetGenerator() {
        }

        public SampleElements<BigInteger> samples() {
            return new SampleElements((Object)BigInteger.valueOf(1L), (Object)BigInteger.valueOf(4L), (Object)BigInteger.valueOf(3L), (Object)BigInteger.valueOf(2L), (Object)BigInteger.valueOf(5L));
        }

        public BigInteger[] createArray(int length) {
            return new BigInteger[length];
        }

        public Iterable<BigInteger> order(List<BigInteger> insertionOrder) {
            return Ordering.natural().sortedCopy(insertionOrder);
        }

        public Set<BigInteger> create(Object ... elements) {
            ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
            for (Object o : elements) {
                BigInteger i = (BigInteger)o;
                builder.add(Range.closedOpen((Comparable)i, (Comparable)i.add(BigInteger.ONE)));
            }
            return builder.build().asSet(DiscreteDomain.bigIntegers());
        }
    }

    static final class ImmutableRangeSetIntegerAsSetGenerator
    implements TestSetGenerator<Integer> {
        ImmutableRangeSetIntegerAsSetGenerator() {
        }

        public SampleElements<Integer> samples() {
            return new SampleElements((Object)1, (Object)4, (Object)3, (Object)2, (Object)5);
        }

        public Integer[] createArray(int length) {
            return new Integer[length];
        }

        public Iterable<Integer> order(List<Integer> insertionOrder) {
            return Ordering.natural().sortedCopy(insertionOrder);
        }

        public Set<Integer> create(Object ... elements) {
            ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
            for (Object o : elements) {
                Integer i = (Integer)o;
                builder.add(Range.singleton((Comparable)i));
            }
            return builder.build().asSet(DiscreteDomain.integers());
        }
    }
}

