/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.ListIteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.ListMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestListMultimapGenerator;
import com.google.common.collect.testing.google.TestStringListMultimapGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class LinkedListMultimapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)ListMultimapTestSuiteBuilder.using((TestListMultimapGenerator)new TestStringListMultimapGenerator(){

            protected ListMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedListMultimap multimap = LinkedListMultimap.create();
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }
        }).named("LinkedListMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTestSuite(LinkedListMultimapTest.class);
        return suite;
    }

    protected LinkedListMultimap<String, Integer> create() {
        return LinkedListMultimap.create();
    }

    public void testGetRandomAccess() {
        LinkedListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        Truth.assertThat((Iterable)multimap.get((Object)"foo")).isNotInstanceOf(RandomAccess.class);
        Truth.assertThat((Iterable)multimap.get((Object)"bar")).isNotInstanceOf(RandomAccess.class);
    }

    public void testRemoveAllRandomAccess() {
        LinkedListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        LinkedListMultimapTest.assertTrue((boolean)(multimap.removeAll((Object)"foo") instanceof RandomAccess));
        LinkedListMultimapTest.assertTrue((boolean)(multimap.removeAll((Object)"bar") instanceof RandomAccess));
    }

    public void testReplaceValuesRandomAccess() {
        LinkedListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)3);
        LinkedListMultimapTest.assertTrue((boolean)(multimap.replaceValues((Object)"foo", Arrays.asList(2, 4)) instanceof RandomAccess));
        LinkedListMultimapTest.assertTrue((boolean)(multimap.replaceValues((Object)"bar", Arrays.asList(2, 4)) instanceof RandomAccess));
    }

    public void testCreateFromMultimap() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)3);
        multimap.put((Object)"foo", (Object)2);
        LinkedListMultimap copy = LinkedListMultimap.create((Multimap)multimap);
        LinkedListMultimapTest.assertEquals((Object)multimap, (Object)copy);
        Truth.assertThat((Iterable)copy.entries()).containsExactlyElementsIn((Iterable)multimap.entries()).inOrder();
    }

    public void testCreateFromSize() {
        LinkedListMultimap multimap = LinkedListMultimap.create((int)20);
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        LinkedListMultimapTest.assertEquals((Object)ImmutableList.of((Object)1, (Object)3), (Object)multimap.get((Object)"foo"));
    }

    public void testCreateFromIllegalSize() {
        try {
            LinkedListMultimap.create((int)-20);
            LinkedListMultimapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLinkedGetAdd() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        List foos = map.get((Object)"foo");
        foos.add(2);
        foos.add(3);
        map.put((Object)"bar", (Object)4);
        map.put((Object)"foo", (Object)5);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 4], foo=[2, 3, 5]}", (String)map.toString());
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=2, foo=3, bar=4, foo=5]", (String)map.entries().toString());
    }

    public void testLinkedGetInsert() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        List foos = map.get((Object)"foo");
        foos.add(2);
        foos.add(0, 3);
        map.put((Object)"bar", (Object)4);
        map.put((Object)"foo", (Object)5);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 4], foo=[3, 2, 5]}", (String)map.toString());
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=3, foo=2, bar=4, foo=5]", (String)map.entries().toString());
    }

    public void testLinkedPutInOrder() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"foo", (Object)1);
        map.put((Object)"bar", (Object)2);
        map.put((Object)"bar", (Object)3);
        LinkedListMultimapTest.assertEquals((String)"{foo=[1], bar=[2, 3]}", (String)map.toString());
        LinkedListMultimapTest.assertEquals((String)"[foo=1, bar=2, bar=3]", (String)map.entries().toString());
    }

    public void testLinkedPutOutOfOrder() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 3], foo=[2]}", (String)map.toString());
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=2, bar=3]", (String)map.entries().toString());
    }

    public void testLinkedPutAllMultimap() {
        LinkedListMultimap<String, Integer> src = this.create();
        src.put((Object)"bar", (Object)1);
        src.put((Object)"foo", (Object)2);
        src.put((Object)"bar", (Object)3);
        LinkedListMultimap<String, Integer> dst = this.create();
        dst.putAll(src);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 3], foo=[2]}", (String)dst.toString());
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=2, bar=3]", (String)src.entries().toString());
    }

    public void testLinkedReplaceValues() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        map.put((Object)"bar", (Object)4);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 3, 4], foo=[2]}", (String)map.toString());
        map.replaceValues((Object)"bar", Arrays.asList(1, 2));
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=2, bar=2]", (String)map.entries().toString());
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 2], foo=[2]}", (String)map.toString());
    }

    public void testLinkedClear() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"foo", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        List foos = map.get((Object)"foo");
        Collection values = map.values();
        LinkedListMultimapTest.assertEquals(Arrays.asList(1, 2), (Object)foos);
        Truth.assertThat((Iterable)values).containsExactly(new Object[]{1, 2, 3}).inOrder();
        map.clear();
        LinkedListMultimapTest.assertEquals(Collections.emptyList(), (Object)foos);
        Truth.assertThat((Iterable)values).isEmpty();
        LinkedListMultimapTest.assertEquals((String)"[]", (String)map.entries().toString());
        LinkedListMultimapTest.assertEquals((String)"{}", (String)map.toString());
    }

    public void testLinkedKeySet() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        map.put((Object)"bar", (Object)4);
        LinkedListMultimapTest.assertEquals((String)"[bar, foo]", (String)map.keySet().toString());
        map.keySet().remove("bar");
        LinkedListMultimapTest.assertEquals((String)"{foo=[2]}", (String)map.toString());
    }

    public void testLinkedKeys() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        map.put((Object)"bar", (Object)4);
        LinkedListMultimapTest.assertEquals((String)"[bar=1, foo=2, bar=3, bar=4]", (String)map.entries().toString());
        Truth.assertThat((Multiset)map.keys()).containsExactly(new Object[]{"bar", "foo", "bar", "bar"}).inOrder();
        map.keys().remove((Object)"bar");
        LinkedListMultimapTest.assertEquals((String)"{foo=[2], bar=[3, 4]}", (String)map.toString());
    }

    public void testLinkedValues() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        map.put((Object)"bar", (Object)4);
        LinkedListMultimapTest.assertEquals((String)"[1, 2, 3, 4]", (String)map.values().toString());
        map.values().remove(2);
        LinkedListMultimapTest.assertEquals((String)"{bar=[1, 3, 4]}", (String)map.toString());
    }

    public void testLinkedEntries() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        Iterator entries = map.entries().iterator();
        Map.Entry entry = (Map.Entry)entries.next();
        LinkedListMultimapTest.assertEquals((String)"bar", (String)((String)entry.getKey()));
        LinkedListMultimapTest.assertEquals((int)1, (int)((Integer)entry.getValue()));
        entry = (Map.Entry)entries.next();
        LinkedListMultimapTest.assertEquals((String)"foo", (String)((String)entry.getKey()));
        LinkedListMultimapTest.assertEquals((int)2, (int)((Integer)entry.getValue()));
        entry.setValue(4);
        entry = (Map.Entry)entries.next();
        LinkedListMultimapTest.assertEquals((String)"bar", (String)((String)entry.getKey()));
        LinkedListMultimapTest.assertEquals((int)3, (int)((Integer)entry.getValue()));
        LinkedListMultimapTest.assertFalse((boolean)entries.hasNext());
        entries.remove();
        LinkedListMultimapTest.assertEquals((String)"{bar=[1], foo=[4]}", (String)map.toString());
    }

    public void testLinkedAsMapEntries() {
        LinkedListMultimap<String, Integer> map = this.create();
        map.put((Object)"bar", (Object)1);
        map.put((Object)"foo", (Object)2);
        map.put((Object)"bar", (Object)3);
        Iterator entries = map.asMap().entrySet().iterator();
        Map.Entry entry = entries.next();
        LinkedListMultimapTest.assertEquals((String)"bar", (String)((String)entry.getKey()));
        Truth.assertThat((Iterable)((Iterable)entry.getValue())).containsExactly(new Object[]{1, 3}).inOrder();
        try {
            entry.setValue(Arrays.asList(new Integer[0]));
            LinkedListMultimapTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entries.remove();
        entry = entries.next();
        LinkedListMultimapTest.assertEquals((String)"foo", (String)((String)entry.getKey()));
        Truth.assertThat((Iterable)((Iterable)entry.getValue())).contains((Object)2);
        LinkedListMultimapTest.assertFalse((boolean)entries.hasNext());
        LinkedListMultimapTest.assertEquals((String)"{foo=[2]}", (String)map.toString());
    }

    public void testEntriesAfterMultimapUpdate() {
        LinkedListMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)2);
        multimap.put((Object)"bar", (Object)3);
        Collection entries = multimap.entries();
        Iterator iterator = entries.iterator();
        Map.Entry entrya = (Map.Entry)iterator.next();
        Map.Entry entryb = (Map.Entry)iterator.next();
        LinkedListMultimapTest.assertEquals((int)2, (int)multimap.get((Object)"foo").set(0, 4));
        LinkedListMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"foo", (Object)2));
        LinkedListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)4));
        LinkedListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"bar", (Object)3));
        LinkedListMultimapTest.assertEquals((int)4, (int)((Integer)entrya.getValue()));
        LinkedListMultimapTest.assertEquals((int)3, (int)((Integer)entryb.getValue()));
        LinkedListMultimapTest.assertTrue((boolean)multimap.put((Object)"foo", (Object)5));
        LinkedListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)5));
        LinkedListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)4));
        LinkedListMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"bar", (Object)3));
        LinkedListMultimapTest.assertEquals((int)4, (int)((Integer)entrya.getValue()));
        LinkedListMultimapTest.assertEquals((int)3, (int)((Integer)entryb.getValue()));
    }

    @GwtIncompatible
    public void testEntriesIteration() {
        ImmutableList addItems = ImmutableList.of((Object)Maps.immutableEntry((Object)"foo", (Object)99), (Object)Maps.immutableEntry((Object)"foo", (Object)88), (Object)Maps.immutableEntry((Object)"bar", (Object)77));
        for (final int startIndex : new int[]{0, 3, 5}) {
            ArrayList list = Lists.newArrayList((Object[])new Map.Entry[]{Maps.immutableEntry((Object)"foo", (Object)2), Maps.immutableEntry((Object)"foo", (Object)3), Maps.immutableEntry((Object)"bar", (Object)4), Maps.immutableEntry((Object)"bar", (Object)5), Maps.immutableEntry((Object)"foo", (Object)6)});
            new ListIteratorTester<Map.Entry<String, Integer>>(3, (Iterable)addItems, (Iterable)ImmutableList.of((Object)IteratorFeature.SUPPORTS_REMOVE), (Iterable)list, startIndex){
                private LinkedListMultimap<String, Integer> multimap;

                protected ListIterator<Map.Entry<String, Integer>> newTargetIterator() {
                    this.multimap = LinkedListMultimapTest.this.create();
                    this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                    this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                    this.multimap.put((Object)"foo", (Object)6);
                    return this.multimap.entries().listIterator(startIndex);
                }

                protected void verify(List<Map.Entry<String, Integer>> elements) {
                    Assert.assertEquals(elements, (Object)this.multimap.entries());
                }
            }.test();
        }
    }

    @GwtIncompatible
    public void testKeysIteration() {
        new IteratorTester<String>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new String[]{"foo", "foo", "bar", "bar", "foo"}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<String> newTargetIterator() {
                this.multimap = LinkedListMultimapTest.this.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                return this.multimap.keys().iterator();
            }

            protected void verify(List<String> elements) {
                Assert.assertEquals(elements, (Object)Lists.newArrayList((Iterable)this.multimap.keys()));
            }
        }.test();
    }

    @GwtIncompatible
    public void testValuesIteration() {
        ImmutableList addItems = ImmutableList.of((Object)99, (Object)88, (Object)77);
        for (final int startIndex : new int[]{0, 3, 5}) {
            new ListIteratorTester<Integer>(3, (Iterable)addItems, (Iterable)ImmutableList.of((Object)IteratorFeature.SUPPORTS_REMOVE, (Object)IteratorFeature.SUPPORTS_SET), (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 5, 6}), startIndex){
                private LinkedListMultimap<String, Integer> multimap;

                protected ListIterator<Integer> newTargetIterator() {
                    this.multimap = LinkedListMultimapTest.this.create();
                    this.multimap.put((Object)"bar", (Object)2);
                    this.multimap.putAll((Object)"foo", Arrays.asList(3, 4));
                    this.multimap.put((Object)"bar", (Object)5);
                    this.multimap.put((Object)"foo", (Object)6);
                    return this.multimap.values().listIterator(startIndex);
                }

                protected void verify(List<Integer> elements) {
                    Assert.assertEquals(elements, (Object)this.multimap.values());
                }
            }.test();
        }
    }

    @GwtIncompatible
    public void testKeySetIteration() {
        new IteratorTester<String>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Sets.newLinkedHashSet(Arrays.asList("foo", "bar", "baz", "dog", "cat")), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<String> newTargetIterator() {
                this.multimap = LinkedListMultimapTest.this.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                this.multimap.putAll((Object)"baz", Arrays.asList(7, 8));
                this.multimap.putAll((Object)"dog", Arrays.asList(9));
                this.multimap.putAll((Object)"bar", Arrays.asList(10, 11));
                this.multimap.putAll((Object)"cat", Arrays.asList(12, 13, 14));
                return this.multimap.keySet().iterator();
            }

            protected void verify(List<String> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)this.multimap.keySet());
            }
        }.test();
    }

    @GwtIncompatible
    public void testAsSetIteration() {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList(Maps.immutableEntry((Object)"foo", Arrays.asList(2, 3, 6)), Maps.immutableEntry((Object)"bar", Arrays.asList(4, 5, 10, 11)), Maps.immutableEntry((Object)"baz", Arrays.asList(7, 8)), Maps.immutableEntry((Object)"dog", Arrays.asList(9)), Maps.immutableEntry((Object)"cat", Arrays.asList(12, 13, 14))));
        new IteratorTester<Map.Entry<String, Collection<Integer>>>(6, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)set, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Map.Entry<String, Collection<Integer>>> newTargetIterator() {
                this.multimap = LinkedListMultimapTest.this.create();
                this.multimap.putAll((Object)"foo", Arrays.asList(2, 3));
                this.multimap.putAll((Object)"bar", Arrays.asList(4, 5));
                this.multimap.putAll((Object)"foo", Arrays.asList(6));
                this.multimap.putAll((Object)"baz", Arrays.asList(7, 8));
                this.multimap.putAll((Object)"dog", Arrays.asList(9));
                this.multimap.putAll((Object)"bar", Arrays.asList(10, 11));
                this.multimap.putAll((Object)"cat", Arrays.asList(12, 13, 14));
                return this.multimap.asMap().entrySet().iterator();
            }

            protected void verify(List<Map.Entry<String, Collection<Integer>>> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), this.multimap.asMap().entrySet());
            }
        }.test();
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{LinkedListMultimap.create(), LinkedListMultimap.create(), LinkedListMultimap.create((int)1)}).testEquals();
    }
}

