/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Function;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;

public class MinMaxPriorityQueueBenchmark {
    @Param
    private ComparatorType comparator;
    @Param(value={"100", "10000"})
    private int size;
    @Param
    private HeapType heap;
    private Queue<Integer> queue;
    private final Random random = new Random();

    @BeforeExperiment
    void setUp() {
        this.queue = this.heap.create(this.comparator.get());
        for (int i = 0; i < this.size; ++i) {
            this.queue.add(this.random.nextInt());
        }
    }

    @Benchmark
    void pollAndAdd(int reps) {
        for (int i = 0; i < reps; ++i) {
            this.queue.add(this.queue.poll() ^ this.random.nextInt());
        }
    }

    @Benchmark
    void populate(int reps) {
        for (int i = 0; i < reps; ++i) {
            this.queue.clear();
            for (int j = 0; j < this.size; ++j) {
                this.queue.add(this.random.nextInt());
            }
        }
    }

    public static enum ComparatorType {
        CHEAP{

            @Override
            public Comparator<Integer> get() {
                return Ordering.natural();
            }
        }
        ,
        EXPENSIVE{

            @Override
            public Comparator<Integer> get() {
                return Ordering.natural().onResultOf((Function)new ExpensiveComputation());
            }
        };


        public abstract Comparator<Integer> get();
    }

    static class ExpensiveComputation
    implements Function<Integer, BigInteger> {
        ExpensiveComputation() {
        }

        public BigInteger apply(Integer from) {
            BigInteger v = BigInteger.valueOf(from.intValue());
            for (double i = 0.0; i < 100.0; i += 20.0) {
                v = v.add(v.multiply(BigInteger.valueOf(Double.valueOf(Math.abs(Math.sin(i) * 10.0)).longValue())));
            }
            return v;
        }
    }

    public static enum HeapType {
        MIN_MAX{

            @Override
            public Queue<Integer> create(Comparator<Integer> comparator) {
                return MinMaxPriorityQueue.orderedBy(comparator).create();
            }
        }
        ,
        PRIORITY_QUEUE{

            @Override
            public Queue<Integer> create(Comparator<Integer> comparator) {
                return new PriorityQueue<Integer>(11, comparator);
            }
        }
        ,
        INVERTED_MIN_MAX{

            @Override
            public Queue<Integer> create(Comparator<Integer> comparator) {
                return new InvertedMinMaxPriorityQueue<Integer>(comparator);
            }
        };


        public abstract Queue<Integer> create(Comparator<Integer> var1);
    }

    static final class InvertedMinMaxPriorityQueue<T>
    extends ForwardingQueue<T> {
        MinMaxPriorityQueue<T> mmHeap;

        public InvertedMinMaxPriorityQueue(Comparator<T> comparator) {
            this.mmHeap = MinMaxPriorityQueue.orderedBy(comparator).create();
        }

        protected Queue<T> delegate() {
            return this.mmHeap;
        }

        public T poll() {
            return (T)this.mmHeap.pollLast();
        }
    }
}

