/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.testing.DerivedComparable;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedSetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class TreeMultimapNaturalTest
extends TestCase {
    private static final Comparator<Double> KEY_COMPARATOR = Ordering.natural();
    private static final Comparator<Double> VALUE_COMPARATOR = Ordering.natural().reverse().nullsFirst();

    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SortedSetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                TreeMultimap multimap = TreeMultimap.create((Comparator)Ordering.natural().nullsFirst(), (Comparator)Ordering.natural().nullsFirst());
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }

            public Iterable<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
                return new Ordering<Map.Entry<String, String>>(){

                    public int compare(Map.Entry<String, String> left, Map.Entry<String, String> right) {
                        return ComparisonChain.start().compare((Object)left.getKey(), (Object)right.getKey(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getValue(), (Object)right.getValue(), (Comparator)Ordering.natural().nullsFirst()).result();
                    }
                }.sortedCopy(insertionOrder);
            }
        }).named("TreeMultimap nullsFirst")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSortedSetGenerator)new TestStringSortedSetGenerator(){

            protected NavigableSet<String> create(String[] elements) {
                TreeMultimap multimap = TreeMultimap.create((Comparator)Ordering.natural().nullsFirst(), (Comparator)Ordering.natural());
                for (int i = 0; i < elements.length; ++i) {
                    multimap.put((Object)elements[i], (Object)i);
                }
                return multimap.keySet();
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().nullsFirst().sortedCopy(insertionOrder);
            }
        }).named("TreeMultimap.keySet")).withFeatures(new Feature[]{CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestSortedMapGenerator<String, Collection<String>>(){

            public String[] createKeyArray(int length) {
                return new String[length];
            }

            public Collection<String>[] createValueArray(int length) {
                return new Collection[length];
            }

            public SampleElements<Map.Entry<String, Collection<String>>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)"a", (Object)ImmutableSortedSet.of((Comparable)((Object)"alex"))), (Object)Helpers.mapEntry((Object)"b", (Object)ImmutableSortedSet.of((Comparable)((Object)"bob"), (Comparable)((Object)"bagel"))), (Object)Helpers.mapEntry((Object)"c", (Object)ImmutableSortedSet.of((Comparable)((Object)"carl"), (Comparable)((Object)"carol"))), (Object)Helpers.mapEntry((Object)"d", (Object)ImmutableSortedSet.of((Comparable)((Object)"david"), (Comparable)((Object)"dead"))), (Object)Helpers.mapEntry((Object)"e", (Object)ImmutableSortedSet.of((Comparable)((Object)"eric"), (Comparable)((Object)"elaine"))));
            }

            public Map.Entry<String, Collection<String>>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<String, Collection<String>>> order(List<Map.Entry<String, Collection<String>>> insertionOrder) {
                return new Ordering<Map.Entry<String, ?>>(){

                    public int compare(Map.Entry<String, ?> left, Map.Entry<String, ?> right) {
                        return left.getKey().compareTo(right.getKey());
                    }
                }.sortedCopy(insertionOrder);
            }

            public NavigableMap<String, Collection<String>> create(Object ... elements) {
                TreeMultimap multimap = TreeMultimap.create();
                for (Object o : elements) {
                    Map.Entry entry = (Map.Entry)o;
                    Preconditions.checkArgument((!multimap.containsKey(entry.getKey()) ? 1 : 0) != 0);
                    multimap.putAll(entry.getKey(), (Iterable)entry.getValue());
                }
                return multimap.asMap();
            }

            public Map.Entry<String, Collection<String>> belowSamplesLesser() {
                return Helpers.mapEntry((Object)"-- a", (Object)ImmutableSortedSet.of((Comparable)((Object)"--below")));
            }

            public Map.Entry<String, Collection<String>> belowSamplesGreater() {
                return Helpers.mapEntry((Object)"-- b", (Object)ImmutableSortedSet.of((Comparable)((Object)"--below")));
            }

            public Map.Entry<String, Collection<String>> aboveSamplesLesser() {
                return Helpers.mapEntry((Object)"~~ b", (Object)ImmutableSortedSet.of((Comparable)((Object)"~above")));
            }

            public Map.Entry<String, Collection<String>> aboveSamplesGreater() {
                return Helpers.mapEntry((Object)"~~ c", (Object)ImmutableSortedSet.of((Comparable)((Object)"~above")));
            }
        }).named("TreeMultimap.asMap")).withFeatures(new Feature[]{MapFeature.SUPPORTS_REMOVE, MapFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeMultimap multimap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.natural().nullsFirst());
                multimap.putAll((Object)1, Arrays.asList(elements));
                return multimap.get((Object)1);
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().nullsFirst().sortedCopy(insertionOrder);
            }
        }).named("TreeMultimap.get")).withFeatures(new Feature[]{CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeMultimap multimap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.natural().nullsFirst());
                multimap.putAll((Object)1, Arrays.asList(elements));
                return (Set)multimap.asMap().entrySet().iterator().next().getValue();
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().nullsFirst().sortedCopy(insertionOrder);
            }
        }).named("TreeMultimap.asMap.entrySet collection")).withFeatures(new Feature[]{CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ONE, CollectionSize.SEVERAL})).createTestSuite());
        suite.addTestSuite(TreeMultimapNaturalTest.class);
        return suite;
    }

    protected SetMultimap<String, Integer> create() {
        return TreeMultimap.create();
    }

    private TreeMultimap<String, Integer> createPopulate() {
        TreeMultimap multimap = TreeMultimap.create();
        multimap.put((Object)"google", (Object)2);
        multimap.put((Object)"google", (Object)6);
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)7);
        multimap.put((Object)"tree", (Object)4);
        multimap.put((Object)"tree", (Object)0);
        return multimap;
    }

    public void testToString() {
        SetMultimap<String, Integer> multimap = this.create();
        multimap.putAll((Object)"bar", Arrays.asList(3, 1, 2));
        multimap.putAll((Object)"foo", Arrays.asList(2, 3, 1, -1, 4));
        TreeMultimapNaturalTest.assertEquals((String)"{bar=[1, 2, 3], foo=[-1, 1, 2, 3, 4]}", (String)multimap.toString());
    }

    public void testOrderedGet() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Iterable)multimap.get((Object)"foo")).containsExactly(new Object[]{1, 3, 7}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"google")).containsExactly(new Object[]{2, 6}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"tree")).containsExactly(new Object[]{0, 4}).inOrder();
    }

    public void testOrderedKeySet() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"foo", "google", "tree"}).inOrder();
    }

    public void testOrderedAsMapEntries() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Iterator iterator = multimap.asMap().entrySet().iterator();
        Map.Entry entry = iterator.next();
        TreeMultimapNaturalTest.assertEquals((String)"foo", (String)((String)entry.getKey()));
        Truth.assertThat((Iterable)((Iterable)entry.getValue())).containsExactly(new Object[]{1, 3, 7});
        entry = iterator.next();
        TreeMultimapNaturalTest.assertEquals((String)"google", (String)((String)entry.getKey()));
        Truth.assertThat((Iterable)((Iterable)entry.getValue())).containsExactly(new Object[]{2, 6});
        entry = iterator.next();
        TreeMultimapNaturalTest.assertEquals((String)"tree", (String)((String)entry.getKey()));
        Truth.assertThat((Iterable)((Iterable)entry.getValue())).containsExactly(new Object[]{0, 4});
    }

    public void testOrderedEntries() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Iterable)multimap.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)"foo", (Object)1), Maps.immutableEntry((Object)"foo", (Object)3), Maps.immutableEntry((Object)"foo", (Object)7), Maps.immutableEntry((Object)"google", (Object)2), Maps.immutableEntry((Object)"google", (Object)6), Maps.immutableEntry((Object)"tree", (Object)0), Maps.immutableEntry((Object)"tree", (Object)4)}).inOrder();
    }

    public void testOrderedValues() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{1, 3, 7, 2, 6, 0, 4}).inOrder();
    }

    public void testMultimapConstructor() {
        SetMultimap<String, Integer> multimap = this.create();
        multimap.putAll((Object)"bar", Arrays.asList(3, 1, 2));
        multimap.putAll((Object)"foo", Arrays.asList(2, 3, 1, -1, 4));
        TreeMultimap copy = TreeMultimap.create(multimap);
        TreeMultimapNaturalTest.assertEquals(multimap, (Object)copy);
    }

    public void testCreateFromTreeMultimap() {
        TreeMultimap tree = TreeMultimap.create(KEY_COMPARATOR, VALUE_COMPARATOR);
        tree.put((Object)1.0, (Object)2.0);
        tree.put((Object)2.0, (Object)3.0);
        tree.put((Object)3.0, (Object)4.0);
        tree.put((Object)4.0, (Object)5.0);
        TreeMultimap copyFromTree = TreeMultimap.create((Multimap)tree);
        TreeMultimapNaturalTest.assertEquals((Object)tree, (Object)copyFromTree);
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), (Object)copyFromTree.keyComparator());
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), (Object)copyFromTree.valueComparator());
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), copyFromTree.get((Object)1.0).comparator());
    }

    public void testCreateFromHashMultimap() {
        HashMultimap hash = HashMultimap.create();
        hash.put((Object)1.0, (Object)2.0);
        hash.put((Object)2.0, (Object)3.0);
        hash.put((Object)3.0, (Object)4.0);
        hash.put((Object)4.0, (Object)5.0);
        TreeMultimap copyFromHash = TreeMultimap.create((Multimap)hash);
        TreeMultimapNaturalTest.assertEquals((Object)hash, (Object)copyFromHash);
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)copyFromHash.keyComparator());
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)copyFromHash.valueComparator());
    }

    public void testCreateFromSortedSetMultimap() {
        TreeMultimap tree = TreeMultimap.create(KEY_COMPARATOR, VALUE_COMPARATOR);
        tree.put((Object)1.0, (Object)2.0);
        tree.put((Object)2.0, (Object)3.0);
        tree.put((Object)3.0, (Object)4.0);
        tree.put((Object)4.0, (Object)5.0);
        SortedSetMultimap sorted = Multimaps.unmodifiableSortedSetMultimap((SortedSetMultimap)tree);
        TreeMultimap copyFromSorted = TreeMultimap.create((Multimap)sorted);
        TreeMultimapNaturalTest.assertEquals((Object)tree, (Object)copyFromSorted);
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), (Object)copyFromSorted.keyComparator());
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), (Object)copyFromSorted.valueComparator());
        TreeMultimapNaturalTest.assertSame((Object)Ordering.natural(), copyFromSorted.get((Object)1.0).comparator());
    }

    public void testComparators() {
        TreeMultimap multimap = TreeMultimap.create();
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.keyComparator());
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.valueComparator());
    }

    @GwtIncompatible
    public void testExplicitComparatorSerialization() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        TreeMultimap copy = (TreeMultimap)SerializableTester.reserializeAndAssert(multimap);
        Truth.assertThat((Iterable)copy.values()).containsExactly(new Object[]{1, 3, 7, 2, 6, 0, 4}).inOrder();
        Truth.assertThat((Iterable)copy.keySet()).containsExactly(new Object[]{"foo", "google", "tree"}).inOrder();
        TreeMultimapNaturalTest.assertEquals((Object)multimap.keyComparator(), (Object)copy.keyComparator());
        TreeMultimapNaturalTest.assertEquals((Object)multimap.valueComparator(), (Object)copy.valueComparator());
    }

    @GwtIncompatible
    public void testTreeMultimapDerived() {
        TreeMultimap multimap = TreeMultimap.create();
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableMultimap.of(), (Object)multimap);
        multimap.put((Object)new DerivedComparable("foo"), (Object)new DerivedComparable("f"));
        multimap.put((Object)new DerivedComparable("foo"), (Object)new DerivedComparable("o"));
        multimap.put((Object)new DerivedComparable("foo"), (Object)new DerivedComparable("o"));
        multimap.put((Object)new DerivedComparable("bar"), (Object)new DerivedComparable("b"));
        multimap.put((Object)new DerivedComparable("bar"), (Object)new DerivedComparable("a"));
        multimap.put((Object)new DerivedComparable("bar"), (Object)new DerivedComparable("r"));
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{new DerivedComparable("bar"), new DerivedComparable("foo")}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{new DerivedComparable("a"), new DerivedComparable("b"), new DerivedComparable("r"), new DerivedComparable("f"), new DerivedComparable("o")}).inOrder();
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.keyComparator());
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.valueComparator());
        SerializableTester.reserializeAndAssert((Object)multimap);
    }

    @GwtIncompatible
    public void testTreeMultimapNonGeneric() {
        TreeMultimap multimap = TreeMultimap.create();
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableMultimap.of(), (Object)multimap);
        multimap.put((Object)new LegacyComparable("foo"), (Object)new LegacyComparable("f"));
        multimap.put((Object)new LegacyComparable("foo"), (Object)new LegacyComparable("o"));
        multimap.put((Object)new LegacyComparable("foo"), (Object)new LegacyComparable("o"));
        multimap.put((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("b"));
        multimap.put((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("a"));
        multimap.put((Object)new LegacyComparable("bar"), (Object)new LegacyComparable("r"));
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{new LegacyComparable("bar"), new LegacyComparable("foo")}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{new LegacyComparable("a"), new LegacyComparable("b"), new LegacyComparable("r"), new LegacyComparable("f"), new LegacyComparable("o")}).inOrder();
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.keyComparator());
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), (Object)multimap.valueComparator());
        SerializableTester.reserializeAndAssert((Object)multimap);
    }

    public void testTreeMultimapAsMapSorted() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        NavigableMap asMap = multimap.asMap();
        TreeMultimapNaturalTest.assertEquals((Object)Ordering.natural(), asMap.comparator());
        TreeMultimapNaturalTest.assertEquals((String)"foo", (String)((String)asMap.firstKey()));
        TreeMultimapNaturalTest.assertEquals((String)"tree", (String)((String)asMap.lastKey()));
        ImmutableSet fooValues = ImmutableSet.of((Object)1, (Object)3, (Object)7);
        ImmutableSet googleValues = ImmutableSet.of((Object)2, (Object)6);
        ImmutableSet treeValues = ImmutableSet.of((Object)4, (Object)0);
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableMap.of((Object)"google", (Object)googleValues, (Object)"tree", (Object)treeValues), asMap.tailMap("g"));
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableMap.of((Object)"google", (Object)googleValues, (Object)"foo", (Object)fooValues), asMap.headMap("h"));
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableMap.of((Object)"google", (Object)googleValues), asMap.subMap("g", "h"));
    }

    public void testTailSetClear() {
        TreeMultimap multimap = TreeMultimap.create();
        multimap.put((Object)"a", (Object)1);
        multimap.put((Object)"a", (Object)11);
        multimap.put((Object)"b", (Object)2);
        multimap.put((Object)"c", (Object)3);
        multimap.put((Object)"d", (Object)4);
        multimap.put((Object)"e", (Object)5);
        multimap.put((Object)"e", (Object)55);
        multimap.keySet().tailSet("d").clear();
        TreeMultimapNaturalTest.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)multimap.keySet());
        TreeMultimapNaturalTest.assertEquals((int)4, (int)multimap.size());
        TreeMultimapNaturalTest.assertEquals((int)4, (int)multimap.values().size());
        TreeMultimapNaturalTest.assertEquals((int)4, (int)multimap.keys().size());
    }

    @GwtIncompatible
    public void testKeySetBridgeMethods() {
        for (Method m : TreeMultimap.class.getMethods()) {
            if (!m.getName().equals("keySet") || !m.getReturnType().equals(SortedSet.class)) continue;
            return;
        }
        TreeMultimapNaturalTest.fail((String)"No bridge method found");
    }

    @GwtIncompatible
    public void testAsMapBridgeMethods() {
        for (Method m : TreeMultimap.class.getMethods()) {
            if (!m.getName().equals("asMap") || !m.getReturnType().equals(SortedMap.class)) continue;
            return;
        }
    }

    @GwtIncompatible
    public void testGetBridgeMethods() {
        for (Method m : TreeMultimap.class.getMethods()) {
            if (!m.getName().equals("get") || !m.getReturnType().equals(SortedSet.class)) continue;
            return;
        }
        TreeMultimapNaturalTest.fail((String)"No bridge method found");
    }
}

