/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractRangeSetTest;
import com.google.common.collect.BoundType;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;

@GwtIncompatible
public class TreeRangeSetTest
extends AbstractRangeSetTest {
    private static final ImmutableList<Range<Integer>> QUERY_RANGES;
    private static final int MIN_BOUND = -1;
    private static final int MAX_BOUND = 1;
    private static final ImmutableList<Cut<Integer>> CUTS_TO_TEST;

    void testViewAgainstExpected(RangeSet<Integer> expected, RangeSet<Integer> view) {
        TreeRangeSetTest.assertEquals(expected, view);
        TreeRangeSetTest.assertEquals((Object)expected.asRanges(), (Object)view.asRanges());
        TreeRangeSetTest.assertEquals((boolean)expected.isEmpty(), (boolean)view.isEmpty());
        if (!expected.isEmpty()) {
            TreeRangeSetTest.assertEquals((Object)expected.span(), (Object)view.span());
        }
        for (int i = -2; i <= 2; ++i) {
            TreeRangeSetTest.assertEquals((boolean)expected.contains((Comparable)Integer.valueOf(i)), (boolean)view.contains((Comparable)Integer.valueOf(i)));
            TreeRangeSetTest.assertEquals((Object)expected.rangeContaining((Comparable)Integer.valueOf(i)), (Object)view.rangeContaining((Comparable)Integer.valueOf(i)));
        }
        this.testEnclosing(view);
        if (view instanceof TreeRangeSet) {
            this.testRangesByLowerBounds((TreeRangeSet<Integer>)((TreeRangeSet)view), expected.asRanges());
        }
    }

    private void testRangesByLowerBounds(TreeRangeSet<Integer> rangeSet, Iterable<Range<Integer>> expectedRanges) {
        TreeMap expectedRangesByLowerBound = Maps.newTreeMap();
        for (Range<Integer> range : expectedRanges) {
            expectedRangesByLowerBound.put(range.lowerBound, range);
        }
        NavigableMap rangesByLowerBound = rangeSet.rangesByLowerBound;
        this.testNavigationAgainstExpected(expectedRangesByLowerBound, rangesByLowerBound, (Iterable)CUTS_TO_TEST);
    }

    <K, V> void testNavigationAgainstExpected(NavigableMap<K, V> expected, NavigableMap<K, V> navigableMap, Iterable<K> keysToTest) {
        for (K key : keysToTest) {
            TreeRangeSetTest.assertEquals(expected.lowerEntry(key), navigableMap.lowerEntry(key));
            TreeRangeSetTest.assertEquals(expected.floorEntry(key), navigableMap.floorEntry(key));
            TreeRangeSetTest.assertEquals(expected.ceilingEntry(key), navigableMap.ceilingEntry(key));
            TreeRangeSetTest.assertEquals(expected.higherEntry(key), navigableMap.higherEntry(key));
            for (boolean inclusive : new boolean[]{false, true}) {
                Truth.assertThat(navigableMap.headMap(key, inclusive).entrySet()).containsExactlyElementsIn(expected.headMap(key, inclusive).entrySet()).inOrder();
                Truth.assertThat(navigableMap.tailMap(key, inclusive).entrySet()).containsExactlyElementsIn(expected.tailMap(key, inclusive).entrySet()).inOrder();
                Truth.assertThat(navigableMap.headMap(key, inclusive).descendingMap().entrySet()).containsExactlyElementsIn(expected.headMap(key, inclusive).descendingMap().entrySet()).inOrder();
                Truth.assertThat(navigableMap.tailMap(key, inclusive).descendingMap().entrySet()).containsExactlyElementsIn(expected.tailMap(key, inclusive).descendingMap().entrySet()).inOrder();
            }
        }
    }

    public void testIntersects(RangeSet<Integer> rangeSet) {
        for (Range query : QUERY_RANGES) {
            boolean expectIntersect = false;
            for (Range expectedRange : rangeSet.asRanges()) {
                if (!expectedRange.isConnected(query) || expectedRange.intersection(query).isEmpty()) continue;
                expectIntersect = true;
                break;
            }
            TreeRangeSetTest.assertEquals((String)(rangeSet + " was incorrect on intersects(" + query + ")"), (boolean)expectIntersect, (boolean)rangeSet.intersects(query));
        }
    }

    public void testEnclosing(RangeSet<Integer> rangeSet) {
        for (Range query : QUERY_RANGES) {
            boolean expectEnclose = false;
            for (Range expectedRange : rangeSet.asRanges()) {
                if (!expectedRange.encloses(query)) continue;
                expectEnclose = true;
                break;
            }
            TreeRangeSetTest.assertEquals((String)(rangeSet + " was incorrect on encloses(" + query + ")"), (boolean)expectEnclose, (boolean)rangeSet.encloses(query));
        }
    }

    public void testAllSingleRangesComplementAgainstRemove() {
        for (Range range : QUERY_RANGES) {
            TreeRangeSet rangeSet = TreeRangeSet.create();
            rangeSet.add(range);
            TreeRangeSet complement = TreeRangeSet.create();
            complement.add(Range.all());
            complement.remove(range);
            TreeRangeSetTest.assertEquals((Object)complement, (Object)rangeSet.complement());
            Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactlyElementsIn((Iterable)complement.asRanges()).inOrder();
        }
    }

    public void testInvariantsEmpty() {
        TreeRangeSetTest.testInvariants(TreeRangeSet.create());
    }

    public void testEmptyIntersecting() {
        this.testIntersects((RangeSet<Integer>)TreeRangeSet.create());
        this.testIntersects((RangeSet<Integer>)TreeRangeSet.create().complement());
    }

    public void testAllSingleRangesIntersecting() {
        for (Range range : QUERY_RANGES) {
            TreeRangeSet rangeSet = TreeRangeSet.create();
            rangeSet.add(range);
            this.testIntersects((RangeSet<Integer>)rangeSet);
            this.testIntersects((RangeSet<Integer>)rangeSet.complement());
        }
    }

    public void testAllTwoRangesIntersecting() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                this.testIntersects((RangeSet<Integer>)rangeSet);
                this.testIntersects((RangeSet<Integer>)rangeSet.complement());
            }
        }
    }

    public void testEmptyEnclosing() {
        this.testEnclosing((RangeSet<Integer>)TreeRangeSet.create());
        this.testEnclosing((RangeSet<Integer>)TreeRangeSet.create().complement());
    }

    public void testAllSingleRangesEnclosing() {
        for (Range range : QUERY_RANGES) {
            TreeRangeSet rangeSet = TreeRangeSet.create();
            rangeSet.add(range);
            this.testEnclosing((RangeSet<Integer>)rangeSet);
            this.testEnclosing((RangeSet<Integer>)rangeSet.complement());
        }
    }

    public void testAllTwoRangesEnclosing() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                this.testEnclosing((RangeSet<Integer>)rangeSet);
                this.testEnclosing((RangeSet<Integer>)rangeSet.complement());
            }
        }
    }

    public void testCreateCopy() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                TreeRangeSetTest.assertEquals((Object)rangeSet, (Object)TreeRangeSet.create((RangeSet)rangeSet));
            }
        }
    }

    private RangeSet<Integer> expectedSubRangeSet(RangeSet<Integer> rangeSet, Range<Integer> subRange) {
        TreeRangeSet expected = TreeRangeSet.create();
        for (Range range : rangeSet.asRanges()) {
            if (!range.isConnected(subRange)) continue;
            expected.add(range.intersection(subRange));
        }
        return expected;
    }

    private RangeSet<Integer> expectedComplement(RangeSet<Integer> rangeSet) {
        TreeRangeSet expected = TreeRangeSet.create();
        expected.add(Range.all());
        expected.removeAll(rangeSet);
        return expected;
    }

    public void testSubRangeSet() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                for (Range subRange : QUERY_RANGES) {
                    this.testViewAgainstExpected(this.expectedSubRangeSet((RangeSet<Integer>)rangeSet, (Range<Integer>)subRange), (RangeSet<Integer>)rangeSet.subRangeSet(subRange));
                }
            }
        }
    }

    public void testComplement() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                this.testViewAgainstExpected(this.expectedComplement((RangeSet<Integer>)rangeSet), (RangeSet<Integer>)rangeSet.complement());
            }
        }
    }

    public void testSubRangeSetOfComplement() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                for (Range subRange : QUERY_RANGES) {
                    this.testViewAgainstExpected(this.expectedSubRangeSet(this.expectedComplement((RangeSet<Integer>)rangeSet), (Range<Integer>)subRange), (RangeSet<Integer>)rangeSet.complement().subRangeSet(subRange));
                }
            }
        }
    }

    public void testComplementOfSubRangeSet() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                for (Range subRange : QUERY_RANGES) {
                    this.testViewAgainstExpected(this.expectedComplement(this.expectedSubRangeSet((RangeSet<Integer>)rangeSet, (Range<Integer>)subRange)), (RangeSet<Integer>)rangeSet.subRangeSet(subRange).complement());
                }
            }
        }
    }

    public void testRangesByUpperBound() {
        for (Range range1 : QUERY_RANGES) {
            for (Range range2 : QUERY_RANGES) {
                TreeRangeSet rangeSet = TreeRangeSet.create();
                rangeSet.add(range1);
                rangeSet.add(range2);
                TreeMap expectedRangesByUpperBound = Maps.newTreeMap();
                for (Range range : rangeSet.asRanges()) {
                    expectedRangesByUpperBound.put(range.upperBound, range);
                }
                this.testNavigationAgainstExpected(expectedRangesByUpperBound, (NavigableMap)new TreeRangeSet.RangesByUpperBound(rangeSet.rangesByLowerBound), (Iterable)CUTS_TO_TEST);
            }
        }
    }

    public void testMergesConnectedWithOverlap() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)));
        rangeSet.add(Range.open((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.atLeast((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testMergesConnectedDisjoint() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)));
        rangeSet.add(Range.open((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.atLeast((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testIgnoresSmallerSharingNoBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.open((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testIgnoresSmallerSharingLowerBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testIgnoresSmallerSharingUpperBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testIgnoresEqual() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testExtendSameLowerBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testExtendSameUpperBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testExtendBothDirections() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4)));
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testAddEmpty() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.all()});
    }

    public void testFillHoleExactly() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)));
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.atLeast((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testFillHoleWithOverlap() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)));
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)));
        rangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.atLeast((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testAddManyPairs() {
        for (int aLow = 0; aLow < 6; ++aLow) {
            for (int aHigh = 0; aHigh < 6; ++aHigh) {
                for (BoundType aLowType : BoundType.values()) {
                    for (BoundType aHighType : BoundType.values()) {
                        if (aLow == aHigh && aLowType == BoundType.OPEN && aHighType == BoundType.OPEN || aLow > aHigh) continue;
                        for (int bLow = 0; bLow < 6; ++bLow) {
                            for (int bHigh = 0; bHigh < 6; ++bHigh) {
                                for (BoundType bLowType : BoundType.values()) {
                                    for (BoundType bHighType : BoundType.values()) {
                                        if (bLow == bHigh && bLowType == BoundType.OPEN && bHighType == BoundType.OPEN || bLow > bHigh) continue;
                                        TreeRangeSetTest.doPairTest((Range<Integer>)Range.range((Comparable)Integer.valueOf(aLow), (BoundType)aLowType, (Comparable)Integer.valueOf(aHigh), (BoundType)aHighType), (Range<Integer>)Range.range((Comparable)Integer.valueOf(bLow), (BoundType)bLowType, (Comparable)Integer.valueOf(bHigh), (BoundType)bHighType));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void doPairTest(Range<Integer> a, Range<Integer> b) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(a);
        rangeSet.add(b);
        if (a.isEmpty() && b.isEmpty()) {
            Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
        } else if (a.isEmpty()) {
            Truth.assertThat((Iterable)rangeSet.asRanges()).contains(b);
        } else if (b.isEmpty()) {
            Truth.assertThat((Iterable)rangeSet.asRanges()).contains(a);
        } else if (a.isConnected(b)) {
            Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{a.span(b)});
        } else if ((Integer)a.lowerEndpoint() < (Integer)b.lowerEndpoint()) {
            Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{a, b}).inOrder();
        } else {
            Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{b, a}).inOrder();
        }
    }

    public void testRemoveEmpty() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(1)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testRemovePartSharingLowerBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
        rangeSet.remove(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.singleton((Comparable)Integer.valueOf(5)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(5)), Range.greaterThan((Comparable)Integer.valueOf(5))}).inOrder();
    }

    public void testRemovePartSharingUpperBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
        rangeSet.remove(Range.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).contains((Object)Range.singleton((Comparable)Integer.valueOf(3)));
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(3)), Range.greaterThan((Comparable)Integer.valueOf(3))}).inOrder();
    }

    public void testRemoveMiddle() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.atMost((Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.lessThan((Comparable)Integer.valueOf(3)), Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6))}).inOrder();
        Truth.assertThat((Iterable)rangeSet.complement().asRanges()).containsExactly(new Object[]{Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4)), Range.greaterThan((Comparable)Integer.valueOf(6))}).inOrder();
    }

    public void testRemoveNoOverlap() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))});
    }

    public void testRemovePartFromBelowLowerBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))});
    }

    public void testRemovePartFromAboveUpperBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(9)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).containsExactly(new Object[]{Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))});
    }

    public void testRemoveExact() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
    }

    public void testRemoveAllFromBelowLowerBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
    }

    public void testRemoveAllFromAboveUpperBound() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
    }

    public void testRemoveAllExtendingBothDirections() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6)));
        rangeSet.remove(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(7)));
        TreeRangeSetTest.testInvariants(rangeSet);
        Truth.assertThat((Iterable)rangeSet.asRanges()).isEmpty();
    }

    public void testRangeContaining1() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(10)));
        TreeRangeSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(10)), (Object)rangeSet.rangeContaining((Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.assertNull((Object)rangeSet.rangeContaining((Comparable)Integer.valueOf(1)));
        TreeRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(1)));
    }

    public void testRangeContaining2() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(10)));
        rangeSet.remove(Range.open((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)));
        TreeRangeSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)rangeSet.rangeContaining((Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(5)));
        TreeRangeSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)rangeSet.rangeContaining((Comparable)Integer.valueOf(8)));
        TreeRangeSetTest.assertTrue((boolean)rangeSet.contains((Comparable)Integer.valueOf(8)));
        TreeRangeSetTest.assertNull((Object)rangeSet.rangeContaining((Comparable)Integer.valueOf(6)));
        TreeRangeSetTest.assertFalse((boolean)rangeSet.contains((Comparable)Integer.valueOf(6)));
    }

    @GwtIncompatible
    public void testSerialization() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(10)));
        rangeSet.remove(Range.open((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)));
        SerializableTester.reserializeAndAssert((Object)rangeSet);
    }

    static {
        int i;
        ImmutableList.Builder queryBuilder = ImmutableList.builder();
        queryBuilder.add((Object)Range.all());
        for (i = -1; i <= 1; ++i) {
            for (BoundType boundType : BoundType.values()) {
                queryBuilder.add((Object)Range.upTo((Comparable)Integer.valueOf(i), (BoundType)boundType));
                queryBuilder.add((Object)Range.downTo((Comparable)Integer.valueOf(i), (BoundType)boundType));
            }
            queryBuilder.add((Object)Range.singleton((Comparable)Integer.valueOf(i)));
            queryBuilder.add((Object)Range.openClosed((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)));
            queryBuilder.add((Object)Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)));
            for (BoundType lowerBoundType : BoundType.values()) {
                for (int j = i + 1; j <= 1; ++j) {
                    for (BoundType upperBoundType : BoundType.values()) {
                        queryBuilder.add((Object)Range.range((Comparable)Integer.valueOf(i), (BoundType)lowerBoundType, (Comparable)Integer.valueOf(j), (BoundType)upperBoundType));
                    }
                }
            }
        }
        QUERY_RANGES = queryBuilder.build();
        ArrayList cutsToTest = Lists.newArrayList();
        for (i = -2; i <= 2; ++i) {
            cutsToTest.add(Cut.belowValue((Comparable)Integer.valueOf(i)));
            cutsToTest.add(Cut.aboveValue((Comparable)Integer.valueOf(i)));
        }
        cutsToTest.add(Cut.aboveAll());
        cutsToTest.add(Cut.belowAll());
        CUTS_TO_TEST = ImmutableList.copyOf((Collection)cutsToTest);
    }
}

