/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible
public class UnmodifiableIteratorTest
extends TestCase {
    public void testRemove() {
        final String[] array = new String[]{"a", "b", "c"};
        UnmodifiableIterator<String> iterator = new UnmodifiableIterator<String>(){
            int i;

            public boolean hasNext() {
                return this.i < array.length;
            }

            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.i++];
            }
        };
        UnmodifiableIteratorTest.assertTrue((boolean)iterator.hasNext());
        UnmodifiableIteratorTest.assertEquals((String)"a", (String)((String)iterator.next()));
        try {
            iterator.remove();
            UnmodifiableIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

