/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.eventbus.Dispatcher;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class DispatcherTest
extends TestCase {
    private final EventBus bus = new EventBus();
    private final IntegerSubscriber i1 = new IntegerSubscriber("i1");
    private final IntegerSubscriber i2 = new IntegerSubscriber("i2");
    private final IntegerSubscriber i3 = new IntegerSubscriber("i3");
    private final ImmutableList<Subscriber> integerSubscribers = ImmutableList.of((Object)DispatcherTest.subscriber(this.bus, this.i1, "handleInteger", Integer.class), (Object)DispatcherTest.subscriber(this.bus, this.i2, "handleInteger", Integer.class), (Object)DispatcherTest.subscriber(this.bus, this.i3, "handleInteger", Integer.class));
    private final StringSubscriber s1 = new StringSubscriber("s1");
    private final StringSubscriber s2 = new StringSubscriber("s2");
    private final ImmutableList<Subscriber> stringSubscribers = ImmutableList.of((Object)DispatcherTest.subscriber(this.bus, this.s1, "handleString", String.class), (Object)DispatcherTest.subscriber(this.bus, this.s2, "handleString", String.class));
    private final ConcurrentLinkedQueue<Object> dispatchedSubscribers = Queues.newConcurrentLinkedQueue();
    private Dispatcher dispatcher;

    public void testPerThreadQueuedDispatcher() {
        this.dispatcher = Dispatcher.perThreadDispatchQueue();
        this.dispatcher.dispatch((Object)1, (Iterator)this.integerSubscribers.iterator());
        Truth.assertThat(this.dispatchedSubscribers).containsExactly(new Object[]{this.i1, this.i2, this.i3, this.s1, this.s2, this.s1, this.s2, this.s1, this.s2}).inOrder();
    }

    public void testLegacyAsyncDispatcher() {
        this.dispatcher = Dispatcher.legacyAsync();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch latch = new CountDownLatch(2);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                DispatcherTest.this.dispatcher.dispatch((Object)2, (Iterator)DispatcherTest.this.integerSubscribers.iterator());
                latch.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                DispatcherTest.this.dispatcher.dispatch((Object)"foo", (Iterator)DispatcherTest.this.stringSubscribers.iterator());
                latch.countDown();
            }
        }).start();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        Truth.assertThat(this.dispatchedSubscribers).containsExactly(new Object[]{this.i1, this.i2, this.i3, this.s1, this.s1, this.s1, this.s1, this.s2, this.s2, this.s2, this.s2});
    }

    public void testImmediateDispatcher() {
        this.dispatcher = Dispatcher.immediate();
        this.dispatcher.dispatch((Object)1, (Iterator)this.integerSubscribers.iterator());
        Truth.assertThat(this.dispatchedSubscribers).containsExactly(new Object[]{this.i1, this.s1, this.s2, this.i2, this.s1, this.s2, this.i3, this.s1, this.s2}).inOrder();
    }

    private static Subscriber subscriber(EventBus bus, Object target, String methodName, Class<?> eventType) {
        try {
            return Subscriber.create((EventBus)bus, (Object)target, (Method)target.getClass().getMethod(methodName, eventType));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final class StringSubscriber {
        private final String name;

        public StringSubscriber(String name) {
            this.name = name;
        }

        @Subscribe
        public void handleString(String string) {
            DispatcherTest.this.dispatchedSubscribers.add(this);
        }

        public String toString() {
            return this.name;
        }
    }

    public final class IntegerSubscriber {
        private final String name;

        public IntegerSubscriber(String name) {
            this.name = name;
        }

        @Subscribe
        public void handleInteger(Integer integer) {
            DispatcherTest.this.dispatchedSubscribers.add(this);
            DispatcherTest.this.dispatcher.dispatch((Object)"hello", (Iterator)DispatcherTest.this.stringSubscribers.iterator());
        }

        public String toString() {
            return this.name;
        }
    }
}

