/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.eventbus.Dispatcher;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.testing.AbstractPackageSanityTests;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class PackageSanityTests
extends AbstractPackageSanityTests {
    public PackageSanityTests() throws Exception {
        DummySubscriber dummySubscriber = new DummySubscriber();
        this.setDefault(Subscriber.class, dummySubscriber.toSubscriber());
        this.setDefault(Method.class, DummySubscriber.subscriberMethod());
        this.setDefault(SubscriberExceptionContext.class, dummySubscriber.toContext());
        this.setDefault(Dispatcher.class, Dispatcher.immediate());
    }

    private static class DummySubscriber {
        private final EventBus eventBus = new EventBus();

        private DummySubscriber() {
        }

        @Subscribe
        public void handle(@Nullable Object anything) {
        }

        Subscriber toSubscriber() throws Exception {
            return Subscriber.create((EventBus)this.eventBus, (Object)this, (Method)DummySubscriber.subscriberMethod());
        }

        SubscriberExceptionContext toContext() {
            return new SubscriberExceptionContext(this.eventBus, new Object(), (Object)this, DummySubscriber.subscriberMethod());
        }

        private static Method subscriberMethod() {
            try {
                return DummySubscriber.class.getMethod("handle", Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

