/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus.outside;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.truth.Truth;
import java.util.List;
import junit.framework.TestCase;

public class AnnotatedSubscriberFinderTests {
    private static final Object EVENT = new Object();

    public static class DeepInterfaceTest
    extends AbstractEventBusTest<SubscriberClass> {
        public void testAnnotatedIn1() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).annotatedIn1Events).contains(EVENT);
        }

        public void testAnnotatedIn2() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).annotatedIn2Events).contains(EVENT);
        }

        public void testAnnotatedIn1And2() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).annotatedIn1And2Events).contains(EVENT);
        }

        public void testAnnotatedIn1And2AndClass() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).annotatedIn1And2AndClassEvents).contains(EVENT);
        }

        public void testDeclaredIn1AnnotatedIn2() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).declaredIn1AnnotatedIn2Events).contains(EVENT);
        }

        public void testDeclaredIn1AnnotatedInClass() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).declaredIn1AnnotatedInClassEvents).contains(EVENT);
        }

        public void testDeclaredIn2AnnotatedInClass() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).declaredIn2AnnotatedInClassEvents).contains(EVENT);
        }

        public void testNowhereAnnotated() {
            Truth.assertThat(((SubscriberClass)this.getSubscriber()).nowhereAnnotatedEvents).isEmpty();
        }

        @Override
        SubscriberClass createSubscriber() {
            return new SubscriberClass();
        }

        static class SubscriberClass
        implements Interface2 {
            final List<Object> annotatedIn1Events = Lists.newArrayList();
            final List<Object> annotatedIn1And2Events = Lists.newArrayList();
            final List<Object> annotatedIn1And2AndClassEvents = Lists.newArrayList();
            final List<Object> declaredIn1AnnotatedIn2Events = Lists.newArrayList();
            final List<Object> declaredIn1AnnotatedInClassEvents = Lists.newArrayList();
            final List<Object> declaredIn2AnnotatedInClassEvents = Lists.newArrayList();
            final List<Object> annotatedIn2Events = Lists.newArrayList();
            final List<Object> nowhereAnnotatedEvents = Lists.newArrayList();

            SubscriberClass() {
            }

            @Override
            public void annotatedIn1(Object o) {
                this.annotatedIn1Events.add(o);
            }

            @Override
            @Subscribe
            public void declaredIn1AnnotatedInClass(Object o) {
                this.declaredIn1AnnotatedInClassEvents.add(o);
            }

            @Override
            public void declaredIn1AnnotatedIn2(Object o) {
                this.declaredIn1AnnotatedIn2Events.add(o);
            }

            @Override
            public void annotatedIn1And2(Object o) {
                this.annotatedIn1And2Events.add(o);
            }

            @Override
            @Subscribe
            public void annotatedIn1And2AndClass(Object o) {
                this.annotatedIn1And2AndClassEvents.add(o);
            }

            @Override
            @Subscribe
            public void declaredIn2AnnotatedInClass(Object o) {
                this.declaredIn2AnnotatedInClassEvents.add(o);
            }

            @Override
            public void annotatedIn2(Object o) {
                this.annotatedIn2Events.add(o);
            }

            @Override
            public void nowhereAnnotated(Object o) {
                this.nowhereAnnotatedEvents.add(o);
            }
        }

        static interface Interface2
        extends Interface1 {
            @Override
            @Subscribe
            public void declaredIn1AnnotatedIn2(Object var1);

            @Override
            @Subscribe
            public void annotatedIn1And2(Object var1);

            @Override
            @Subscribe
            public void annotatedIn1And2AndClass(Object var1);

            public void declaredIn2AnnotatedInClass(Object var1);

            @Subscribe
            public void annotatedIn2(Object var1);
        }

        static interface Interface1 {
            @Subscribe
            public void annotatedIn1(Object var1);

            @Subscribe
            public void annotatedIn1And2(Object var1);

            @Subscribe
            public void annotatedIn1And2AndClass(Object var1);

            public void declaredIn1AnnotatedIn2(Object var1);

            public void declaredIn1AnnotatedInClass(Object var1);

            public void nowhereAnnotated(Object var1);
        }
    }

    public static class NeitherAbstractNorAnnotatedInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testNeitherOverriddenNorAnnotated() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).neitherOverriddenNorAnnotatedEvents).isEmpty();
        }

        public void testOverriddenInSubclassNowhereAnnotated() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).overriddenInSubclassNowhereAnnotatedEvents).isEmpty();
        }

        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).contains(EVENT);
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            SubClass() {
            }

            @Override
            public void overriddenInSubclassNowhereAnnotated(Object o) {
                super.overriddenInSubclassNowhereAnnotated(o);
            }

            @Override
            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                super.overriddenAndAnnotatedInSubclass(o);
            }
        }

        static class SuperClass {
            final List<Object> neitherOverriddenNorAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenInSubclassNowhereAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();

            SuperClass() {
            }

            public void neitherOverriddenNorAnnotated(Object o) {
                this.neitherOverriddenNorAnnotatedEvents.add(o);
            }

            public void overriddenInSubclassNowhereAnnotated(Object o) {
                this.overriddenInSubclassNowhereAnnotatedEvents.add(o);
            }

            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }
        }
    }

    public static class AbstractNotAnnotatedInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.assertThat(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).contains(EVENT);
        }

        public void testOverriddenInSubclassNowhereAnnotated() {
            Truth.assertThat(((SubClass)this.getSubscriber()).overriddenInSubclassNowhereAnnotatedEvents).isEmpty();
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> overriddenInSubclassNowhereAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();

            SubClass() {
            }

            @Override
            public void overriddenInSubclassNowhereAnnotated(Object o) {
                this.overriddenInSubclassNowhereAnnotatedEvents.add(o);
            }

            @Override
            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }
        }

        static abstract class SuperClass {
            SuperClass() {
            }

            public abstract void overriddenInSubclassNowhereAnnotated(Object var1);

            public abstract void overriddenAndAnnotatedInSubclass(Object var1);
        }
    }

    public static class AnnotatedNotAbstractInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testNotOverriddenInSubclass() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).notOverriddenInSubclassEvents).contains(EVENT);
        }

        public void testOverriddenNotAnnotatedInSubclass() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).overriddenNotAnnotatedInSubclassEvents).contains(EVENT);
        }

        public void testDifferentlyOverriddenNotAnnotatedInSubclass() {
            Truth.assertThat(((SubClass)this.getSubscriber()).differentlyOverriddenNotAnnotatedInSubclassGoodEvents).contains(EVENT);
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).differentlyOverriddenNotAnnotatedInSubclassBadEvents).isEmpty();
        }

        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).contains(EVENT);
        }

        public void testDifferentlyOverriddenAndAnnotatedInSubclass() {
            Truth.assertThat(((SubClass)this.getSubscriber()).differentlyOverriddenAnnotatedInSubclassGoodEvents).contains(EVENT);
            Truth.assertThat((Iterable)((SubClass)this.getSubscriber()).differentlyOverriddenAnnotatedInSubclassBadEvents).isEmpty();
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> differentlyOverriddenNotAnnotatedInSubclassGoodEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenAnnotatedInSubclassGoodEvents = Lists.newArrayList();

            SubClass() {
            }

            @Override
            public void overriddenNotAnnotatedInSubclass(Object o) {
                super.overriddenNotAnnotatedInSubclass(o);
            }

            @Override
            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                super.overriddenAndAnnotatedInSubclass(o);
            }

            @Override
            public void differentlyOverriddenNotAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenNotAnnotatedInSubclassGoodEvents.add(o);
            }

            @Override
            @Subscribe
            public void differentlyOverriddenAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenAnnotatedInSubclassGoodEvents.add(o);
            }
        }

        static class SuperClass {
            final List<Object> notOverriddenInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenNotAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenNotAnnotatedInSubclassBadEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenAnnotatedInSubclassBadEvents = Lists.newArrayList();

            SuperClass() {
            }

            @Subscribe
            public void notOverriddenInSubclass(Object o) {
                this.notOverriddenInSubclassEvents.add(o);
            }

            @Subscribe
            public void overriddenNotAnnotatedInSubclass(Object o) {
                this.overriddenNotAnnotatedInSubclassEvents.add(o);
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }

            @Subscribe
            public void differentlyOverriddenNotAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenNotAnnotatedInSubclassBadEvents.add(o);
            }

            @Subscribe
            public void differentlyOverriddenAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenAnnotatedInSubclassBadEvents.add(o);
            }
        }
    }

    public static class AnnotatedAndAbstractInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.assertThat(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).contains(EVENT);
        }

        public void testOverriddenNotAnnotatedInSubclass() {
            Truth.assertThat(((SubClass)this.getSubscriber()).overriddenInSubclassEvents).contains(EVENT);
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenInSubclassEvents = Lists.newArrayList();

            SubClass() {
            }

            @Override
            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }

            @Override
            public void overriddenInSubclass(Object o) {
                this.overriddenInSubclassEvents.add(o);
            }
        }

        static abstract class SuperClass {
            SuperClass() {
            }

            @Subscribe
            public abstract void overriddenAndAnnotatedInSubclass(Object var1);

            @Subscribe
            public abstract void overriddenInSubclass(Object var1);
        }
    }

    public static class BaseSubscriberFinderTest
    extends AbstractEventBusTest<Subscriber> {
        public void testNonSubscriber() {
            Truth.assertThat(((Subscriber)this.getSubscriber()).nonSubscriberEvents).isEmpty();
        }

        public void testSubscriber() {
            Truth.assertThat(((Subscriber)this.getSubscriber()).subscriberEvents).contains(EVENT);
        }

        @Override
        Subscriber createSubscriber() {
            return new Subscriber();
        }

        static class Subscriber {
            final List<Object> nonSubscriberEvents = Lists.newArrayList();
            final List<Object> subscriberEvents = Lists.newArrayList();

            Subscriber() {
            }

            public void notASubscriber(Object o) {
                this.nonSubscriberEvents.add(o);
            }

            @Subscribe
            public void subscriber(Object o) {
                this.subscriberEvents.add(o);
            }
        }
    }

    static abstract class AbstractEventBusTest<H>
    extends TestCase {
        private H subscriber;

        AbstractEventBusTest() {
        }

        abstract H createSubscriber();

        H getSubscriber() {
            return this.subscriber;
        }

        protected void setUp() throws Exception {
            this.subscriber = this.createSubscriber();
            EventBus bus = new EventBus();
            bus.register(this.subscriber);
            bus.post(EVENT);
        }

        protected void tearDown() throws Exception {
            this.subscriber = null;
        }
    }
}

