/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetworkTest;
import com.google.common.graph.EndpointPair;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDirectedNetworkTest
extends AbstractNetworkTest {
    @After
    public void validateSourceAndTarget() {
        for (Integer node : this.network.nodes()) {
            EndpointPair endpointPair;
            for (String inEdge : this.network.inEdges((Object)node)) {
                endpointPair = this.network.incidentNodes((Object)inEdge);
                Truth.assertThat((Integer)((Integer)endpointPair.source())).isEqualTo(endpointPair.adjacentNode((Object)node));
                Truth.assertThat((Integer)((Integer)endpointPair.target())).isEqualTo((Object)node);
            }
            for (String outEdge : this.network.outEdges((Object)node)) {
                endpointPair = this.network.incidentNodes((Object)outEdge);
                Truth.assertThat((Integer)((Integer)endpointPair.source())).isEqualTo((Object)node);
                Truth.assertThat((Integer)((Integer)endpointPair.target())).isEqualTo(endpointPair.adjacentNode((Object)node));
            }
            for (Integer adjacentNode : this.network.adjacentNodes((Object)node)) {
                Set edges = this.network.edgesConnecting((Object)node, (Object)adjacentNode);
                Set antiParallelEdges = this.network.edgesConnecting((Object)adjacentNode, (Object)node);
                Truth.assertThat((Boolean)(node.equals(adjacentNode) || Collections.disjoint(edges, antiParallelEdges) ? 1 : 0)).isTrue();
            }
        }
    }

    @Override
    @Test
    public void incidentNodes_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-2").source())).isEqualTo((Object)N1);
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-2").target())).isEqualTo((Object)N2);
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void inEdges_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.inEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.network.inEdges((Object)N1)).isEmpty();
    }

    @Test
    public void outEdges_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.outEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.network.outEdges((Object)N2)).isEmpty();
    }

    @Test
    public void predecessors_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.network.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.network.successors((Object)N2)).isEmpty();
    }

    @Test
    public void source_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-2").source())).isEqualTo((Object)N1);
    }

    @Test
    public void source_edgeNotInGraph() {
        try {
            this.network.incidentNodes((Object)"edgeNotInGraph").source();
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void target_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-2").target())).isEqualTo((Object)N2);
    }

    @Test
    public void target_edgeNotInGraph() {
        try {
            this.network.incidentNodes((Object)"edgeNotInGraph").target();
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)this.network.inDegree((Object)N2)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.network.inDegree((Object)N1)).isEqualTo((Object)0);
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)this.network.outDegree((Object)N1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.network.outDegree((Object)N2)).isEqualTo((Object)0);
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Boolean)this.addEdge(N1, N2, "1-2")).isTrue();
        Truth.assertThat((Iterable)this.network.edges()).contains((Object)"1-2");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge(N1, N2, "1-2");
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.network.edges());
        Truth.assertThat((Boolean)this.addEdge(N1, N2, "1-2")).isFalse();
        Truth.assertThat((Iterable)this.network.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes() {
        this.addEdge(N1, N2, "1-2");
        try {
            this.addEdge(N4, N5, "1-2");
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it cannot be reused to connect");
        }
        try {
            this.addEdge(N2, N1, "1-2");
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it cannot be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelEdge() {
        this.addEdge(N1, N2, "1-2");
        try {
            this.addEdge(N1, N2, "edgeNotInGraph");
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }
}

