/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ConfigurableDirectedNetworkTest;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableDirectedMultiNetworkTest
extends ConfigurableDirectedNetworkTest {
    @Override
    public MutableNetwork<Integer, String> createGraph() {
        return NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
    }

    @Test
    public void adjacentEdges_parallelEdges() {
        this.addEdge(N1, N2, "1-2");
        this.addEdge(N1, N2, "1-2a");
        this.addEdge(N1, N2, "1-2b");
        this.addEdge(N3, N4, "3-4");
        Truth.assertThat((Iterable)this.network.adjacentEdges((Object)"1-2")).containsExactly(new Object[]{"1-2a", "1-2b"});
    }

    @Test
    public void edgesConnecting_parallelEdges() {
        Assert.assertTrue((boolean)this.addEdge(N1, N2, "1-2"));
        Assert.assertTrue((boolean)this.addEdge(N1, N2, "1-2a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "1-2a"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void edgesConnecting_parallelSelfLoopEdges() {
        Assert.assertTrue((boolean)this.addEdge(N1, N1, "1-1"));
        Assert.assertTrue((boolean)this.addEdge(N1, N1, "1-1a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1", "1-1a"});
    }

    @Override
    @Test
    public void addEdge_parallelEdge() {
        Assert.assertTrue((boolean)this.addEdge(N1, N2, "1-2"));
        Assert.assertTrue((boolean)this.addEdge(N1, N2, "1-2a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "1-2a"});
    }

    @Override
    @Test
    public void addEdge_parallelSelfLoopEdge() {
        Assert.assertTrue((boolean)this.addEdge(N1, N1, "1-1"));
        Assert.assertTrue((boolean)this.addEdge(N1, N1, "1-1a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1", "1-1a"});
    }

    @Test
    public void removeEdge_parallelEdge() {
        this.addEdge(N1, N2, "1-2");
        this.addEdge(N1, N2, "1-2a");
        Assert.assertTrue((boolean)this.network.removeEdge((Object)"1-2a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void removeEdge_parallelSelfLoopEdge() {
        this.addEdge(N1, N1, "1-1");
        this.addEdge(N1, N1, "1-1a");
        this.addEdge(N1, N2, "1-2");
        Assert.assertTrue((boolean)this.network.removeEdge((Object)"1-1a"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Assert.assertTrue((boolean)this.network.removeEdge((Object)"1-1"));
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).isEmpty();
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
    }
}

