/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ConfigurableSimpleUndirectedGraphTest;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableUndirectedGraphTest
extends ConfigurableSimpleUndirectedGraphTest {
    @Override
    public MutableGraph<Integer> createGraph() {
        return GraphBuilder.undirected().allowsSelfLoops(true).build();
    }

    @Test
    public void adjacentNodes_selfLoop() {
        this.putEdge(N1, N1);
        this.putEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void predecessors_selfLoop() {
        this.putEdge(N1, N1);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N1});
        this.putEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void successors_selfLoop() {
        this.putEdge(N1, N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N1});
        this.putEdge(N2, N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void degree_selfLoop() {
        this.putEdge(N1, N1);
        Truth.assertThat((Integer)this.graph.degree((Object)N1)).isEqualTo((Object)2);
        this.putEdge(N1, N2);
        Truth.assertThat((Integer)this.graph.degree((Object)N1)).isEqualTo((Object)3);
    }

    @Test
    public void inDegree_selfLoop() {
        this.putEdge(N1, N1);
        Truth.assertThat((Integer)this.graph.inDegree((Object)N1)).isEqualTo((Object)2);
        this.putEdge(N1, N2);
        Truth.assertThat((Integer)this.graph.inDegree((Object)N1)).isEqualTo((Object)3);
    }

    @Test
    public void outDegree_selfLoop() {
        this.putEdge(N1, N1);
        Truth.assertThat((Integer)this.graph.outDegree((Object)N1)).isEqualTo((Object)2);
        this.putEdge(N2, N1);
        Truth.assertThat((Integer)this.graph.outDegree((Object)N1)).isEqualTo((Object)3);
    }

    @Override
    @Test
    public void addEdge_selfLoop() {
        Truth.assertThat((Boolean)this.putEdge(N1, N1)).isTrue();
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1});
    }

    @Test
    public void addEdge_existingSelfLoopEdgeBetweenSameNodes() {
        this.putEdge(N1, N1);
        Truth.assertThat((Boolean)this.putEdge(N1, N1)).isFalse();
    }

    @Test
    public void removeNode_existingNodeWithSelfLoopEdge() {
        this.addNode(N1);
        this.putEdge(N1, N1);
        Truth.assertThat((Boolean)this.graph.removeNode((Object)N1)).isTrue();
        Truth.assertThat((Iterable)this.graph.nodes()).isEmpty();
    }

    @Test
    public void removeEdge_existingSelfLoopEdge() {
        this.putEdge(N1, N1);
        Truth.assertThat((Boolean)this.graph.removeEdge((Object)N1, (Object)N1)).isTrue();
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).isEmpty();
    }
}

