/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class GraphMutationTest {
    private static final int NUM_TRIALS = 50;
    private static final int NUM_NODES = 100;
    private static final int NUM_EDGES = 1000;
    private static final int NODE_POOL_SIZE = 1000;

    @Test
    public void directedGraph() {
        GraphMutationTest.testGraphMutation((GraphBuilder<? super Integer>)GraphBuilder.directed());
    }

    @Test
    public void undirectedGraph() {
        GraphMutationTest.testGraphMutation((GraphBuilder<? super Integer>)GraphBuilder.undirected());
    }

    private static void testGraphMutation(GraphBuilder<? super Integer> graphBuilder) {
        Random gen = new Random(42L);
        for (int trial = 0; trial < 50; ++trial) {
            int i;
            MutableGraph graph = graphBuilder.allowsSelfLoops(true).build();
            Truth.assertThat((Iterable)graph.nodes()).isEmpty();
            Truth.assertThat((Iterable)graph.edges()).isEmpty();
            AbstractGraphTest.validateGraph(graph);
            while (graph.nodes().size() < 100) {
                graph.addNode((Object)gen.nextInt(1000));
            }
            ArrayList nodeList = new ArrayList(graph.nodes());
            while (graph.edges().size() < 1000) {
                graph.putEdge(GraphMutationTest.getRandomElement(nodeList, gen), GraphMutationTest.getRandomElement(nodeList, gen));
            }
            ArrayList edgeList = new ArrayList(graph.edges());
            Truth.assertThat((Iterable)graph.nodes()).hasSize(100);
            Truth.assertThat((Iterable)graph.edges()).hasSize(1000);
            AbstractGraphTest.validateGraph(graph);
            Collections.shuffle(edgeList, gen);
            int numEdgesToRemove = gen.nextInt(1000);
            for (int i2 = 0; i2 < numEdgesToRemove; ++i2) {
                EndpointPair edge = (EndpointPair)edgeList.get(i2);
                Truth.assertThat((Boolean)graph.removeEdge(edge.nodeU(), edge.nodeV())).isTrue();
            }
            Truth.assertThat((Iterable)graph.nodes()).hasSize(100);
            Truth.assertThat((Iterable)graph.edges()).hasSize(1000 - numEdgesToRemove);
            AbstractGraphTest.validateGraph(graph);
            Collections.shuffle(nodeList, gen);
            int numNodesToRemove = gen.nextInt(100);
            for (i = 0; i < numNodesToRemove; ++i) {
                Truth.assertThat((Boolean)graph.removeNode(nodeList.get(i))).isTrue();
            }
            Truth.assertThat((Iterable)graph.nodes()).hasSize(100 - numNodesToRemove);
            AbstractGraphTest.validateGraph(graph);
            for (i = numNodesToRemove; i < 100; ++i) {
                Truth.assertThat((Boolean)graph.removeNode(nodeList.get(i))).isTrue();
            }
            Truth.assertThat((Iterable)graph.nodes()).isEmpty();
            Truth.assertThat((Iterable)graph.edges()).isEmpty();
            AbstractGraphTest.validateGraph(graph);
            Collections.shuffle(nodeList, gen);
            for (Integer node : nodeList) {
                Truth.assertThat((Boolean)graph.addNode((Object)node)).isTrue();
            }
            Collections.shuffle(edgeList, gen);
            for (EndpointPair edge : edgeList) {
                Truth.assertThat((Boolean)graph.putEdge(edge.nodeU(), edge.nodeV())).isTrue();
            }
            Truth.assertThat((Iterable)graph.nodes()).hasSize(100);
            Truth.assertThat((Iterable)graph.edges()).hasSize(1000);
            AbstractGraphTest.validateGraph(graph);
        }
    }

    private static <L extends List<T> & RandomAccess, T> T getRandomElement(L list, Random gen) {
        return list.get(gen.nextInt(list.size()));
    }
}

