/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.Ordering;
import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class MapCacheTest {
    private final MapIteratorCache<String, String> mapCache;

    public MapCacheTest(MapIteratorCache<String, String> mapCache) {
        this.mapCache = mapCache;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        Ordering nullsLast = Ordering.natural().nullsLast();
        return Arrays.asList({new MapIteratorCache(new HashMap())}, {new MapIteratorCache(new TreeMap(nullsLast))}, {new MapRetrievalCache(new HashMap())}, {new MapRetrievalCache(new TreeMap(nullsLast))});
    }

    @Before
    public void init() {
        this.mapCache.clear();
    }

    @Test
    public void testKeySetIterator() {
        this.mapCache.put((Object)"A", (Object)"A_value");
        this.mapCache.put((Object)"B", (Object)"B_value");
        this.mapCache.put((Object)"C", (Object)"C_value");
        Truth.assertThat((Iterable)this.mapCache.unmodifiableKeySet()).hasSize(3);
        for (String key : this.mapCache.unmodifiableKeySet()) {
            Truth.assertThat((String)((String)this.mapCache.get((Object)key))).isEqualTo((Object)(key + "_value"));
        }
    }

    @Test
    public void testPutNewValue() {
        Truth.assertThat((String)((String)this.mapCache.put((Object)"key", (Object)"value"))).isNull();
        Truth.assertThat((String)((String)this.mapCache.get((Object)"key"))).isEqualTo((Object)"value");
        Truth.assertThat((String)((String)this.mapCache.put((Object)"key", (Object)"new value"))).isEqualTo((Object)"value");
        Truth.assertThat((String)((String)this.mapCache.get((Object)"key"))).isEqualTo((Object)"new value");
    }

    @Test
    public void testRemoveEqualKeyWithDifferentReference() {
        String fooReference1 = new String("foo");
        String fooReference2 = new String("foo");
        Truth.assertThat((String)fooReference1).isNotSameAs((Object)fooReference2);
        Truth.assertThat((String)((String)this.mapCache.put((Object)fooReference1, (Object)"bar"))).isNull();
        Truth.assertThat((String)((String)this.mapCache.get((Object)fooReference1))).isEqualTo((Object)"bar");
        Truth.assertThat((String)((String)this.mapCache.remove((Object)fooReference2))).isEqualTo((Object)"bar");
        Truth.assertThat((String)((String)this.mapCache.get((Object)fooReference1))).isNull();
    }

    @Test
    public void testHandleNulls() {
        this.mapCache.put((Object)"foo", (Object)"bar");
        this.mapCache.put((Object)"non-null key", null);
        this.mapCache.put(null, (Object)"non-null value");
        Truth.assertThat((String)((String)this.mapCache.get((Object)"foo"))).isEqualTo((Object)"bar");
        Truth.assertThat((String)((String)this.mapCache.get((Object)"non-null key"))).isNull();
        Truth.assertThat((String)((String)this.mapCache.get(null))).isEqualTo((Object)"non-null value");
        Truth.assertThat((Boolean)this.mapCache.containsKey((Object)"foo")).isTrue();
        Truth.assertThat((Boolean)this.mapCache.containsKey((Object)"bar")).isFalse();
        Truth.assertThat((Boolean)this.mapCache.containsKey((Object)"non-null key")).isTrue();
        Truth.assertThat((Boolean)this.mapCache.containsKey(null)).isTrue();
        Truth.assertThat((String)((String)this.mapCache.get(null))).isEqualTo((Object)"non-null value");
        Truth.assertThat((String)((String)this.mapCache.get((Object)"non-null key"))).isNull();
        Truth.assertThat((String)((String)this.mapCache.get((Object)"foo"))).isEqualTo((Object)"bar");
    }
}

