/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.testing.AbstractPackageSanityTests;
import com.google.common.truth.Truth;
import junit.framework.AssertionFailedError;

public class PackageSanityTests
extends AbstractPackageSanityTests {
    private static final AbstractGraphBuilder<?> GRAPH_BUILDER_A = GraphBuilder.directed().expectedNodeCount(10);
    private static final AbstractGraphBuilder<?> GRAPH_BUILDER_B = ValueGraphBuilder.directed().allowsSelfLoops(true).expectedNodeCount(16);
    private static final ImmutableGraph<String> IMMUTABLE_GRAPH_A = PackageSanityTests.graphWithNode("A");
    private static final ImmutableGraph<String> IMMUTABLE_GRAPH_B = PackageSanityTests.graphWithNode("B");
    private static final NetworkBuilder<?, ?> NETWORK_BUILDER_A = NetworkBuilder.directed().allowsParallelEdges(true).expectedNodeCount(10);
    private static final NetworkBuilder<?, ?> NETWORK_BUILDER_B = NetworkBuilder.directed().allowsSelfLoops(true).expectedNodeCount(16);
    private static final ImmutableNetwork<String, String> IMMUTABLE_NETWORK_A = PackageSanityTests.networkWithNode("A");
    private static final ImmutableNetwork<String, String> IMMUTABLE_NETWORK_B = PackageSanityTests.networkWithNode("B");

    public PackageSanityTests() {
        this.setDistinctValues(AbstractGraphBuilder.class, GRAPH_BUILDER_A, GRAPH_BUILDER_B);
        this.setDistinctValues(Graph.class, IMMUTABLE_GRAPH_A, IMMUTABLE_GRAPH_B);
        this.setDistinctValues(NetworkBuilder.class, NETWORK_BUILDER_A, NETWORK_BUILDER_B);
        this.setDistinctValues(Network.class, IMMUTABLE_NETWORK_A, IMMUTABLE_NETWORK_B);
    }

    public void testNulls() throws Exception {
        try {
            super.testNulls();
        }
        catch (AssertionFailedError e) {
            Truth.assertWithMessage((String)"Method did not throw null pointer OR element not in graph exception.").that(e.getCause().getMessage()).contains((CharSequence)"not an element of this graph");
        }
    }

    private static <N> ImmutableGraph<N> graphWithNode(N node) {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.addNode(node);
        return ImmutableGraph.copyOf((Graph)graph);
    }

    private static <N> ImmutableNetwork<N, N> networkWithNode(N node) {
        MutableNetwork network = NetworkBuilder.directed().build();
        network.addNode(node);
        return ImmutableNetwork.copyOf((Network)network);
    }
}

