/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.HashCode;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;

public class AbstractByteHasherTest
extends TestCase {
    public void testBytes() {
        TestHasher hasher = new TestHasher();
        byte[] expected = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        hasher.putByte((byte)1);
        hasher.putBytes(new byte[]{2, 3, 4, 5, 6});
        hasher.putByte((byte)7);
        hasher.putBytes(new byte[0]);
        hasher.putBytes(new byte[]{8});
        hasher.assertBytes(expected);
    }

    public void testShort() {
        TestHasher hasher = new TestHasher();
        hasher.putShort((short)513);
        hasher.assertBytes(new byte[]{1, 2});
    }

    public void testInt() {
        TestHasher hasher = new TestHasher();
        hasher.putInt(67305985);
        hasher.assertBytes(new byte[]{1, 2, 3, 4});
    }

    public void testLong() {
        TestHasher hasher = new TestHasher();
        hasher.putLong(578437695752307201L);
        hasher.assertBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
    }

    public void testChar() {
        TestHasher hasher = new TestHasher();
        hasher.putChar('\u0201');
        hasher.assertBytes(new byte[]{1, 2});
    }

    public void testString() {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            byte[] bytes = new byte[64];
            random.nextBytes(bytes);
            String s = new String(bytes, Charsets.UTF_16LE);
            AbstractByteHasherTest.assertEquals((Object)new TestHasher().putUnencodedChars(s).hash(), (Object)new TestHasher().putBytes(s.getBytes(Charsets.UTF_16LE)).hash());
            AbstractByteHasherTest.assertEquals((Object)new TestHasher().putUnencodedChars(s).hash(), (Object)new TestHasher().putString(s, Charsets.UTF_16LE).hash());
        }
    }

    public void testFloat() {
        TestHasher hasher = new TestHasher();
        hasher.putFloat(Float.intBitsToFloat(67305985));
        hasher.assertBytes(new byte[]{1, 2, 3, 4});
    }

    public void testDouble() {
        TestHasher hasher = new TestHasher();
        hasher.putDouble(Double.longBitsToDouble(578437695752307201L));
        hasher.assertBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
    }

    public void testCorrectExceptions() {
        TestHasher hasher = new TestHasher();
        try {
            hasher.putBytes(new byte[8], -1, 4);
            AbstractByteHasherTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            hasher.putBytes(new byte[8], 0, 16);
            AbstractByteHasherTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            hasher.putBytes(new byte[8], 0, -1);
            AbstractByteHasherTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @CanIgnoreReturnValue
    private class TestHasher
    extends AbstractByteHasher {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        private TestHasher() {
        }

        protected void update(byte b) {
            this.out.write(b);
        }

        protected void update(byte[] b, int off, int len) {
            this.out.write(b, off, len);
        }

        byte[] bytes() {
            return this.out.toByteArray();
        }

        void assertBytes(byte[] expected) {
            Assert.assertArrayEquals((byte[])expected, (byte[])this.bytes());
        }

        public HashCode hash() {
            return HashCode.fromBytesNoCopy((byte[])this.bytes());
        }
    }
}

