/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.testing.NullPointerTester;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class HashingInputStreamTest
extends TestCase {
    private Hasher hasher;
    private HashFunction hashFunction;
    private static final byte[] testBytes = new byte[]{121, 97, 109, 115};
    private ByteArrayInputStream buffer;

    protected void setUp() throws Exception {
        super.setUp();
        this.hasher = (Hasher)Mockito.mock(Hasher.class);
        this.hashFunction = (HashFunction)Mockito.mock(HashFunction.class);
        this.buffer = new ByteArrayInputStream(testBytes);
        Mockito.when((Object)this.hashFunction.newHasher()).thenReturn((Object)this.hasher);
    }

    public void testRead_putSingleByte() throws Exception {
        HashingInputStream in = new HashingInputStream(this.hashFunction, (InputStream)this.buffer);
        int b = in.read();
        HashingInputStreamTest.assertEquals((int)121, (int)b);
        ((Hasher)Mockito.verify((Object)this.hasher)).putByte((byte)121);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testRead_putByteArray() throws Exception {
        HashingInputStream in = new HashingInputStream(this.hashFunction, (InputStream)this.buffer);
        byte[] buf = new byte[4];
        int numOfByteRead = in.read(buf, 0, buf.length);
        HashingInputStreamTest.assertEquals((int)4, (int)numOfByteRead);
        for (int i = 0; i < testBytes.length; ++i) {
            HashingInputStreamTest.assertEquals((byte)testBytes[i], (byte)buf[i]);
        }
        ((Hasher)Mockito.verify((Object)this.hasher)).putBytes(testBytes, 0, testBytes.length);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testRead_putByteArrayAtPos() throws Exception {
        HashingInputStream in = new HashingInputStream(this.hashFunction, (InputStream)this.buffer);
        byte[] buf = new byte[3];
        int numOfByteRead = in.read(buf, 0, 3);
        HashingInputStreamTest.assertEquals((int)3, (int)numOfByteRead);
        for (int i = 0; i < numOfByteRead; ++i) {
            HashingInputStreamTest.assertEquals((byte)testBytes[i], (byte)buf[i]);
        }
        ((Hasher)Mockito.verify((Object)this.hasher)).putBytes(Arrays.copyOf(testBytes, 3), 0, 3);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testRead_putByteArrayOutOfBound() throws Exception {
        byte[] buf = new byte[100];
        byte[] expectedBytes = (byte[])buf.clone();
        System.arraycopy(testBytes, 0, expectedBytes, 0, testBytes.length);
        HashingInputStream in = new HashingInputStream(this.hashFunction, (InputStream)this.buffer);
        int numOfByteRead = in.read(buf, 0, 100);
        HashingInputStreamTest.assertEquals((int)4, (int)numOfByteRead);
        for (int i = 0; i < numOfByteRead; ++i) {
            HashingInputStreamTest.assertEquals((byte)testBytes[i], (byte)buf[i]);
        }
        ((Hasher)Mockito.verify((Object)this.hasher)).putBytes(expectedBytes, 0, 4);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testHash_hashesCorrectly() throws Exception {
        HashCode expectedHash = Hashing.md5().hashBytes(testBytes);
        HashingInputStream in = new HashingInputStream(Hashing.md5(), (InputStream)this.buffer);
        byte[] buf = new byte[4];
        int numOfByteRead = in.read(buf, 0, buf.length);
        HashingInputStreamTest.assertEquals((int)4, (int)numOfByteRead);
        HashingInputStreamTest.assertEquals((Object)expectedHash, (Object)in.hash());
    }

    public void testHash_hashesCorrectlyReadOutOfBound() throws Exception {
        HashCode expectedHash = Hashing.md5().hashBytes(testBytes);
        HashingInputStream in = new HashingInputStream(Hashing.md5(), (InputStream)this.buffer);
        byte[] buf = new byte[100];
        int numOfByteRead = in.read(buf, 0, buf.length);
        HashingInputStreamTest.assertEquals((int)-1, (int)in.read());
        HashingInputStreamTest.assertEquals((int)4, (int)numOfByteRead);
        HashingInputStreamTest.assertEquals((Object)expectedHash, (Object)in.hash());
    }

    public void testHash_hashesCorrectlyForSkipping() throws Exception {
        HashCode expectedHash = Hashing.md5().hashBytes(new byte[]{109, 115});
        HashingInputStream in = new HashingInputStream(Hashing.md5(), (InputStream)this.buffer);
        long numOfByteSkipped = in.skip(2L);
        HashingInputStreamTest.assertEquals((long)2L, (long)numOfByteSkipped);
        byte[] buf = new byte[4];
        int numOfByteRead = in.read(buf, 0, buf.length);
        HashingInputStreamTest.assertEquals((int)2, (int)numOfByteRead);
        HashingInputStreamTest.assertEquals((Object)expectedHash, (Object)in.hash());
    }

    public void testChecksForNull() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new HashingInputStream(Hashing.md5(), (InputStream)this.buffer));
        tester.testAllPublicStaticMethods(HashingInputStream.class);
        tester.testAllPublicConstructors(HashingInputStream.class);
    }
}

