/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.AndroidIncompatible;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.IoTestCase;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class ByteStreamsTest
extends IoTestCase {
    private static final byte[] bytes = new byte[]{18, 52, 86, 120, 118, 84, 50, 16};
    private static final byte[] utf16ExpectedWithBom = new byte[]{-2, -1, 0, 114, 0, -55, 0, 115, 0, 117, 0, 109, 0, -55};

    public void testCopyChannel() throws IOException {
        byte[] expected = ByteStreamsTest.newPreFilledByteArray(100);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WritableByteChannel outChannel = Channels.newChannel(out);
        ReadableByteChannel inChannel = Channels.newChannel(new ByteArrayInputStream(expected));
        ByteStreams.copy((ReadableByteChannel)inChannel, (WritableByteChannel)outChannel);
        ByteStreamsTest.assertEquals(expected, out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFileChannel() throws IOException {
        int chunkSize = 14407;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WritableByteChannel outChannel = Channels.newChannel(out);
        File testFile = this.createTempFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        byte[] dummyData = ByteStreamsTest.newPreFilledByteArray(14407);
        try {
            for (int i = 0; i < 500; ++i) {
                fos.write(dummyData);
            }
        }
        finally {
            fos.close();
        }
        FileChannel inChannel = new RandomAccessFile(testFile, "r").getChannel();
        try {
            ByteStreams.copy((ReadableByteChannel)inChannel, (WritableByteChannel)outChannel);
        }
        finally {
            inChannel.close();
        }
        byte[] actual = out.toByteArray();
        for (int i = 0; i < 7203500; i += 14407) {
            ByteStreamsTest.assertEquals(dummyData, Arrays.copyOfRange(actual, i, i + 14407));
        }
    }

    public void testReadFully() throws IOException {
        byte[] b = new byte[10];
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), null, (int)0, (int)10);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully(null, (byte[])b, (int)0, (int)10);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)-1, (int)10);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)0, (int)-1);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)0, (int)-1);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)2, (int)10);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(5), (byte[])b, (int)0, (int)10);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        Arrays.fill(b, (byte)0);
        ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)0, (int)0);
        ByteStreamsTest.assertEquals(new byte[10], b);
        Arrays.fill(b, (byte)0);
        ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)0, (int)10);
        ByteStreamsTest.assertEquals(ByteStreamsTest.newPreFilledByteArray(10), b);
        Arrays.fill(b, (byte)0);
        ByteStreams.readFully((InputStream)ByteStreamsTest.newTestStream(10), (byte[])b, (int)0, (int)5);
        ByteStreamsTest.assertEquals(new byte[]{0, 1, 2, 3, 4, 0, 0, 0, 0, 0}, b);
    }

    public void testSkipFully() throws IOException {
        byte[] bytes = ByteStreamsTest.newPreFilledByteArray(100);
        ByteStreamsTest.skipHelper(0L, 0, new ByteArrayInputStream(bytes));
        ByteStreamsTest.skipHelper(50L, 50, new ByteArrayInputStream(bytes));
        ByteStreamsTest.skipHelper(50L, 50, new SlowSkipper(new ByteArrayInputStream(bytes), 1L));
        ByteStreamsTest.skipHelper(50L, 50, new SlowSkipper(new ByteArrayInputStream(bytes), 0L));
        ByteStreamsTest.skipHelper(100L, -1, new ByteArrayInputStream(bytes));
        try {
            ByteStreamsTest.skipHelper(101L, 0, new ByteArrayInputStream(bytes));
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private static void skipHelper(long n, int expect, InputStream in) throws IOException {
        ByteStreams.skipFully((InputStream)in, (long)n);
        ByteStreamsTest.assertEquals((int)expect, (int)in.read());
        in.close();
    }

    public void testNewDataInput_empty() {
        byte[] b = new byte[]{};
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])b);
        try {
            in.readInt();
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNewDataInput_normal() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        ByteStreamsTest.assertEquals((int)305419896, (int)in.readInt());
        ByteStreamsTest.assertEquals((int)1985229328, (int)in.readInt());
        try {
            in.readInt();
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNewDataInput_readFully() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        byte[] actual = new byte[bytes.length];
        in.readFully(actual);
        ByteStreamsTest.assertEquals(bytes, actual);
    }

    public void testNewDataInput_readFullyAndThenSome() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        byte[] actual = new byte[bytes.length * 2];
        try {
            in.readFully(actual);
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException ex) {
            Truth.assertThat((Throwable)ex.getCause()).isInstanceOf(EOFException.class);
        }
    }

    public void testNewDataInput_readFullyWithOffset() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        byte[] actual = new byte[4];
        in.readFully(actual, 2, 2);
        ByteStreamsTest.assertEquals((int)0, (int)actual[0]);
        ByteStreamsTest.assertEquals((int)0, (int)actual[1]);
        ByteStreamsTest.assertEquals((byte)bytes[0], (byte)actual[2]);
        ByteStreamsTest.assertEquals((byte)bytes[1], (byte)actual[3]);
    }

    public void testNewDataInput_readLine() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])"This is a line\r\nThis too\rand this\nand also this".getBytes(Charsets.UTF_8));
        ByteStreamsTest.assertEquals((String)"This is a line", (String)in.readLine());
        ByteStreamsTest.assertEquals((String)"This too", (String)in.readLine());
        ByteStreamsTest.assertEquals((String)"and this", (String)in.readLine());
        ByteStreamsTest.assertEquals((String)"and also this", (String)in.readLine());
    }

    public void testNewDataInput_readFloat() {
        byte[] data = new byte[]{18, 52, 86, 120, 118, 84, 50, 16};
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((double)Float.intBitsToFloat(305419896), (double)in.readFloat(), (double)0.0);
        ByteStreamsTest.assertEquals((double)Float.intBitsToFloat(1985229328), (double)in.readFloat(), (double)0.0);
    }

    public void testNewDataInput_readDouble() {
        byte[] data = new byte[]{18, 52, 86, 120, 118, 84, 50, 16};
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((double)Double.longBitsToDouble(1311768466852950544L), (double)in.readDouble(), (double)0.0);
    }

    public void testNewDataInput_readUTF() {
        byte[] data = new byte[17];
        data[1] = 15;
        System.arraycopy("Kilroy was here".getBytes(Charsets.UTF_8), 0, data, 2, 15);
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((String)"Kilroy was here", (String)in.readUTF());
    }

    public void testNewDataInput_readChar() {
        byte[] data = "qed".getBytes(Charsets.UTF_16BE);
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((char)'q', (char)in.readChar());
        ByteStreamsTest.assertEquals((char)'e', (char)in.readChar());
        ByteStreamsTest.assertEquals((char)'d', (char)in.readChar());
    }

    public void testNewDataInput_readUnsignedShort() {
        byte[] data = new byte[]{0, 0, 0, 1, -1, -1, 18, 52};
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((int)0, (int)in.readUnsignedShort());
        ByteStreamsTest.assertEquals((int)1, (int)in.readUnsignedShort());
        ByteStreamsTest.assertEquals((int)65535, (int)in.readUnsignedShort());
        ByteStreamsTest.assertEquals((int)4660, (int)in.readUnsignedShort());
    }

    public void testNewDataInput_readLong() {
        byte[] data = new byte[]{18, 52, 86, 120, 118, 84, 50, 16};
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        ByteStreamsTest.assertEquals((long)1311768466852950544L, (long)in.readLong());
    }

    public void testNewDataInput_readBoolean() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        ByteStreamsTest.assertTrue((boolean)in.readBoolean());
    }

    public void testNewDataInput_readByte() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        for (int i = 0; i < bytes.length; ++i) {
            ByteStreamsTest.assertEquals((byte)bytes[i], (byte)in.readByte());
        }
        try {
            in.readByte();
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException ex) {
            Truth.assertThat((Throwable)ex.getCause()).isInstanceOf(EOFException.class);
        }
    }

    public void testNewDataInput_readUnsignedByte() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        for (int i = 0; i < bytes.length; ++i) {
            ByteStreamsTest.assertEquals((int)bytes[i], (int)in.readUnsignedByte());
        }
        try {
            in.readUnsignedByte();
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException ex) {
            Truth.assertThat((Throwable)ex.getCause()).isInstanceOf(EOFException.class);
        }
    }

    public void testNewDataInput_offset() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes, (int)2);
        ByteStreamsTest.assertEquals((int)1450735188, (int)in.readInt());
        try {
            in.readInt();
            ByteStreamsTest.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNewDataInput_skip() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])new byte[2]);
        ByteStreamsTest.assertEquals((int)2, (int)in.skipBytes(2));
        ByteStreamsTest.assertEquals((int)0, (int)in.skipBytes(1));
    }

    public void testNewDataInput_BAIS() {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{18, 52, 86, 120});
        ByteArrayDataInput in = ByteStreams.newDataInput((ByteArrayInputStream)bais);
        ByteStreamsTest.assertEquals((int)305419896, (int)in.readInt());
    }

    public void testNewDataOutput_empty() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        ByteStreamsTest.assertEquals((int)0, (int)out.toByteArray().length);
    }

    public void testNewDataOutput_writeInt() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(305419896);
        out.writeInt(1985229328);
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_sized() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)4);
        out.writeInt(305419896);
        out.writeInt(1985229328);
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_writeLong() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeLong(1311768466852950544L);
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_writeByteArray() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.write(bytes);
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_writeByte() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.write(18);
        out.writeByte(52);
        ByteStreamsTest.assertEquals(new byte[]{18, 52}, out.toByteArray());
    }

    public void testNewDataOutput_writeByteOffset() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.write(bytes, 4, 2);
        byte[] expected = new byte[]{bytes[4], bytes[5]};
        ByteStreamsTest.assertEquals(expected, out.toByteArray());
    }

    public void testNewDataOutput_writeBoolean() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeBoolean(true);
        out.writeBoolean(false);
        byte[] expected = new byte[]{1, 0};
        ByteStreamsTest.assertEquals(expected, out.toByteArray());
    }

    public void testNewDataOutput_writeChar() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeChar(97);
        ByteStreamsTest.assertEquals(new byte[]{0, 97}, out.toByteArray());
    }

    public void testNewDataOutput_writeChars() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeChars("r\u00c9sum\u00c9");
        byte[] expected = Arrays.copyOfRange(utf16ExpectedWithBom, 2, 14);
        ByteStreamsTest.assertEquals(expected, out.toByteArray());
    }

    @AndroidIncompatible
    public void testUtf16Expected() {
        byte[] hardcodedExpected = utf16ExpectedWithBom;
        byte[] computedExpected = "r\u00c9sum\u00c9".getBytes(Charsets.UTF_16);
        ByteStreamsTest.assertEquals(hardcodedExpected, computedExpected);
    }

    public void testNewDataOutput_writeUTF() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("r\u00c9sum\u00c9");
        byte[] expected = "r\u00c9sum\u00c9".getBytes(Charsets.UTF_8);
        byte[] actual = out.toByteArray();
        ByteStreamsTest.assertEquals((int)0, (int)actual[0]);
        ByteStreamsTest.assertEquals((int)expected.length, (int)actual[1]);
        ByteStreamsTest.assertEquals(expected, Arrays.copyOfRange(actual, 2, actual.length));
    }

    public void testNewDataOutput_writeShort() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeShort(4660);
        ByteStreamsTest.assertEquals(new byte[]{18, 52}, out.toByteArray());
    }

    public void testNewDataOutput_writeDouble() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeDouble(Double.longBitsToDouble(1311768466852950544L));
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_writeFloat() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeFloat(Float.intBitsToFloat(305419896));
        out.writeFloat(Float.intBitsToFloat(1985229328));
        ByteStreamsTest.assertEquals(bytes, out.toByteArray());
    }

    public void testNewDataOutput_BAOS() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayDataOutput out = ByteStreams.newDataOutput((ByteArrayOutputStream)baos);
        out.writeInt(305419896);
        ByteStreamsTest.assertEquals((int)4, (int)baos.size());
        ByteStreamsTest.assertEquals(new byte[]{18, 52, 86, 120}, baos.toByteArray());
    }

    public void testToByteArray_withSize_givenCorrectSize() throws IOException {
        InputStream in = ByteStreamsTest.newTestStream(100);
        byte[] b = ByteStreams.toByteArray((InputStream)in, (int)100);
        ByteStreamsTest.assertEquals((int)100, (int)b.length);
    }

    public void testToByteArray_withSize_givenSmallerSize() throws IOException {
        InputStream in = ByteStreamsTest.newTestStream(100);
        byte[] b = ByteStreams.toByteArray((InputStream)in, (int)80);
        ByteStreamsTest.assertEquals((int)100, (int)b.length);
    }

    public void testToByteArray_withSize_givenLargerSize() throws IOException {
        InputStream in = ByteStreamsTest.newTestStream(100);
        byte[] b = ByteStreams.toByteArray((InputStream)in, (int)120);
        ByteStreamsTest.assertEquals((int)100, (int)b.length);
    }

    public void testToByteArray_withSize_givenSizeZero() throws IOException {
        InputStream in = ByteStreamsTest.newTestStream(100);
        byte[] b = ByteStreams.toByteArray((InputStream)in, (int)0);
        ByteStreamsTest.assertEquals((int)100, (int)b.length);
    }

    public void testExhaust() throws IOException {
        InputStream in = ByteStreamsTest.newTestStream(100);
        ByteStreamsTest.assertEquals((long)100L, (long)ByteStreams.exhaust((InputStream)in));
        ByteStreamsTest.assertEquals((int)-1, (int)in.read());
        ByteStreamsTest.assertEquals((long)0L, (long)ByteStreams.exhaust((InputStream)in));
        InputStream empty = ByteStreamsTest.newTestStream(0);
        ByteStreamsTest.assertEquals((long)0L, (long)ByteStreams.exhaust((InputStream)empty));
        ByteStreamsTest.assertEquals((int)-1, (int)empty.read());
    }

    private static InputStream newTestStream(int n) {
        return new ByteArrayInputStream(ByteStreamsTest.newPreFilledByteArray(n));
    }

    public void testReadBytes() throws IOException {
        byte[] array = ByteStreamsTest.newPreFilledByteArray(1000);
        ByteStreamsTest.assertEquals(array, (byte[])ByteStreams.readBytes((InputStream)new ByteArrayInputStream(array), (ByteProcessor)new TestByteProcessor()));
    }

    public void testByteProcessorStopEarly() throws IOException {
        byte[] array = ByteStreamsTest.newPreFilledByteArray(10000);
        ByteStreamsTest.assertEquals((Object)42, (Object)ByteStreams.readBytes((InputStream)new ByteArrayInputStream(array), (ByteProcessor)new ByteProcessor<Integer>(){

            public boolean processBytes(byte[] buf, int off, int len) {
                ByteStreamsTest.assertEquals(ByteStreamsTest.copyOfRange(buf, off, off + len), IoTestCase.newPreFilledByteArray(8192));
                return false;
            }

            public Integer getResult() {
                return 42;
            }
        }));
    }

    public void testNullOutputStream() throws Exception {
        OutputStream nos = ByteStreams.nullOutputStream();
        nos.write(110);
        String test = "Test string for NullOutputStream";
        nos.write(test.getBytes());
        nos.write(test.getBytes(), 2, 10);
        ByteStreamsTest.assertSame((Object)ByteStreams.nullOutputStream(), (Object)ByteStreams.nullOutputStream());
    }

    public void testLimit() throws Exception {
        byte[] big = ByteStreamsTest.newPreFilledByteArray(5);
        ByteArrayInputStream bin = new ByteArrayInputStream(big);
        InputStream lin = ByteStreams.limit((InputStream)bin, (long)2L);
        lin.mark(2);
        ByteStreamsTest.assertEquals((int)2, (int)lin.available());
        int read = lin.read();
        ByteStreamsTest.assertEquals((int)big[0], (int)read);
        ByteStreamsTest.assertEquals((int)1, (int)lin.available());
        read = lin.read();
        ByteStreamsTest.assertEquals((int)big[1], (int)read);
        ByteStreamsTest.assertEquals((int)0, (int)lin.available());
        read = lin.read();
        ByteStreamsTest.assertEquals((int)-1, (int)read);
        lin.reset();
        byte[] small = new byte[5];
        read = lin.read(small);
        ByteStreamsTest.assertEquals((int)2, (int)read);
        ByteStreamsTest.assertEquals((byte)big[0], (byte)small[0]);
        ByteStreamsTest.assertEquals((byte)big[1], (byte)small[1]);
        lin.reset();
        read = lin.read(small, 2, 3);
        ByteStreamsTest.assertEquals((int)2, (int)read);
        ByteStreamsTest.assertEquals((byte)big[0], (byte)small[2]);
        ByteStreamsTest.assertEquals((byte)big[1], (byte)small[3]);
    }

    public void testLimit_mark() throws Exception {
        byte[] big = ByteStreamsTest.newPreFilledByteArray(5);
        ByteArrayInputStream bin = new ByteArrayInputStream(big);
        InputStream lin = ByteStreams.limit((InputStream)bin, (long)2L);
        int read = lin.read();
        ByteStreamsTest.assertEquals((int)big[0], (int)read);
        lin.mark(2);
        read = lin.read();
        ByteStreamsTest.assertEquals((int)big[1], (int)read);
        read = lin.read();
        ByteStreamsTest.assertEquals((int)-1, (int)read);
        lin.reset();
        read = lin.read();
        ByteStreamsTest.assertEquals((int)big[1], (int)read);
        read = lin.read();
        ByteStreamsTest.assertEquals((int)-1, (int)read);
    }

    public void testLimit_skip() throws Exception {
        byte[] big = ByteStreamsTest.newPreFilledByteArray(5);
        ByteArrayInputStream bin = new ByteArrayInputStream(big);
        InputStream lin = ByteStreams.limit((InputStream)bin, (long)2L);
        lin.mark(2);
        ByteStreamsTest.assertEquals((int)2, (int)lin.available());
        lin.skip(1L);
        ByteStreamsTest.assertEquals((int)1, (int)lin.available());
        lin.reset();
        ByteStreamsTest.assertEquals((int)2, (int)lin.available());
        lin.skip(3L);
        ByteStreamsTest.assertEquals((int)0, (int)lin.available());
    }

    public void testLimit_markNotSet() {
        byte[] big = ByteStreamsTest.newPreFilledByteArray(5);
        ByteArrayInputStream bin = new ByteArrayInputStream(big);
        InputStream lin = ByteStreams.limit((InputStream)bin, (long)2L);
        try {
            lin.reset();
            ByteStreamsTest.fail();
        }
        catch (IOException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("Mark not set");
        }
    }

    public void testLimit_markNotSupported() {
        InputStream lin = ByteStreams.limit((InputStream)new UnmarkableInputStream(), (long)2L);
        try {
            lin.reset();
            ByteStreamsTest.fail();
        }
        catch (IOException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("Mark not supported");
        }
    }

    private static byte[] copyOfRange(byte[] in, int from, int to) {
        byte[] out = new byte[to - from];
        for (int i = 0; i < to - from; ++i) {
            out[i] = in[from + i];
        }
        return out;
    }

    private static void assertEquals(byte[] expected, byte[] actual) {
        Truth.assertThat((byte[])actual).isEqualTo((Object)expected);
    }

    private static class UnmarkableInputStream
    extends InputStream {
        private UnmarkableInputStream() {
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }

    private class TestByteProcessor
    implements ByteProcessor<byte[]> {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        private TestByteProcessor() {
        }

        public boolean processBytes(byte[] buf, int off, int len) throws IOException {
            this.out.write(buf, off, len);
            return true;
        }

        public byte[] getResult() {
            return this.out.toByteArray();
        }
    }

    private static class SlowSkipper
    extends FilterInputStream {
        private final long max;

        public SlowSkipper(InputStream in, long max) {
            super(in);
            this.max = max;
        }

        @Override
        public long skip(long n) throws IOException {
            return super.skip(Math.min(this.max, n));
        }
    }
}

