/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.AndroidIncompatible;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.CharSourceTester;
import com.google.common.io.Closeables;
import com.google.common.io.Closer;
import com.google.common.io.CloserTest;
import com.google.common.io.IoTestCase;
import com.google.common.io.LineProcessor;
import com.google.common.io.SourceSinkFactories;
import com.google.common.io.TestCharSink;
import com.google.common.io.TestCharSource;
import com.google.common.io.TestOption;
import com.google.common.io.TestWriter;
import com.google.common.testing.TestLogHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CharSourceTest
extends IoTestCase {
    private static final String STRING = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
    private static final String LINES = "foo\nbar\r\nbaz\rsomething";
    private TestCharSource source;
    static final CharSource BROKEN_READ_SOURCE = new TestCharSource("ABC", TestOption.READ_THROWS);
    static final CharSource BROKEN_CLOSE_SOURCE = new TestCharSource("ABC", TestOption.CLOSE_THROWS);
    static final CharSource BROKEN_OPEN_SOURCE = new TestCharSource("ABC", TestOption.OPEN_THROWS);
    static final CharSink BROKEN_WRITE_SINK = new TestCharSink(TestOption.WRITE_THROWS);
    static final CharSink BROKEN_CLOSE_SINK = new TestCharSink(TestOption.CLOSE_THROWS);
    static final CharSink BROKEN_OPEN_SINK = new TestCharSink(TestOption.OPEN_THROWS);
    private static final ImmutableSet<CharSource> BROKEN_SOURCES = ImmutableSet.of((Object)BROKEN_CLOSE_SOURCE, (Object)BROKEN_OPEN_SOURCE, (Object)BROKEN_READ_SOURCE);
    private static final ImmutableSet<CharSink> BROKEN_SINKS = ImmutableSet.of((Object)BROKEN_CLOSE_SINK, (Object)BROKEN_OPEN_SINK, (Object)BROKEN_WRITE_SINK);

    @AndroidIncompatible
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        for (boolean asByteSource : new boolean[]{false, true}) {
            suite.addTest((Test)CharSourceTester.tests("CharSource.wrap[CharSequence]", SourceSinkFactories.stringCharSourceFactory(), asByteSource));
            suite.addTest((Test)CharSourceTester.tests("CharSource.empty[]", SourceSinkFactories.emptyCharSourceFactory(), asByteSource));
        }
        suite.addTestSuite(CharSourceTest.class);
        return suite;
    }

    public void setUp() {
        this.source = new TestCharSource(STRING, new TestOption[0]);
    }

    public void testOpenBufferedStream() throws IOException {
        int read;
        BufferedReader reader = this.source.openBufferedStream();
        CharSourceTest.assertTrue((boolean)this.source.wasStreamOpened());
        CharSourceTest.assertFalse((boolean)this.source.wasStreamClosed());
        StringWriter writer = new StringWriter();
        char[] buf = new char[64];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        reader.close();
        writer.close();
        CharSourceTest.assertTrue((boolean)this.source.wasStreamClosed());
        CharSourceTest.assertEquals((String)STRING, (String)writer.toString());
    }

    public void testCopyTo_appendable() throws IOException {
        StringBuilder builder = new StringBuilder();
        CharSourceTest.assertEquals((long)STRING.length(), (long)this.source.copyTo(builder));
        CharSourceTest.assertTrue((this.source.wasStreamOpened() && this.source.wasStreamClosed() ? 1 : 0) != 0);
        CharSourceTest.assertEquals((String)STRING, (String)builder.toString());
    }

    public void testCopyTo_charSink() throws IOException {
        TestCharSink sink = new TestCharSink(new TestOption[0]);
        CharSourceTest.assertFalse((sink.wasStreamOpened() || sink.wasStreamClosed() ? 1 : 0) != 0);
        CharSourceTest.assertEquals((long)STRING.length(), (long)this.source.copyTo(sink));
        CharSourceTest.assertTrue((this.source.wasStreamOpened() && this.source.wasStreamClosed() ? 1 : 0) != 0);
        CharSourceTest.assertTrue((sink.wasStreamOpened() && sink.wasStreamClosed() ? 1 : 0) != 0);
        CharSourceTest.assertEquals((String)STRING, (String)sink.getString());
    }

    public void testRead_toString() throws IOException {
        CharSourceTest.assertEquals((String)STRING, (String)this.source.read());
        CharSourceTest.assertTrue((this.source.wasStreamOpened() && this.source.wasStreamClosed() ? 1 : 0) != 0);
    }

    public void testReadFirstLine() throws IOException {
        TestCharSource lines = new TestCharSource(LINES, new TestOption[0]);
        CharSourceTest.assertEquals((String)"foo", (String)lines.readFirstLine());
        CharSourceTest.assertTrue((lines.wasStreamOpened() && lines.wasStreamClosed() ? 1 : 0) != 0);
    }

    public void testReadLines_toList() throws IOException {
        TestCharSource lines = new TestCharSource(LINES, new TestOption[0]);
        CharSourceTest.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"something"), (Object)lines.readLines());
        CharSourceTest.assertTrue((lines.wasStreamOpened() && lines.wasStreamClosed() ? 1 : 0) != 0);
    }

    public void testReadLines_withProcessor() throws IOException {
        TestCharSource lines = new TestCharSource(LINES, new TestOption[0]);
        List list = (List)lines.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return true;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        CharSourceTest.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"something"), (Object)list);
        CharSourceTest.assertTrue((lines.wasStreamOpened() && lines.wasStreamClosed() ? 1 : 0) != 0);
    }

    public void testReadLines_withProcessor_stopsOnFalse() throws IOException {
        TestCharSource lines = new TestCharSource(LINES, new TestOption[0]);
        List list = (List)lines.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return false;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        CharSourceTest.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)list);
        CharSourceTest.assertTrue((lines.wasStreamOpened() && lines.wasStreamClosed() ? 1 : 0) != 0);
    }

    public void testCopyToAppendable_doesNotCloseIfWriter() throws IOException {
        TestWriter writer = new TestWriter(new TestOption[0]);
        CharSourceTest.assertFalse((boolean)writer.closed());
        this.source.copyTo(writer);
        CharSourceTest.assertFalse((boolean)writer.closed());
    }

    public void testClosesOnErrors_copyingToCharSinkThatThrows() {
        for (TestOption option : EnumSet.of(TestOption.OPEN_THROWS, TestOption.WRITE_THROWS, TestOption.CLOSE_THROWS)) {
            TestCharSource okSource = new TestCharSource(STRING, new TestOption[0]);
            try {
                okSource.copyTo(new TestCharSink(option));
                CharSourceTest.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            CharSourceTest.assertTrue((String)("stream not closed when copying to sink with option: " + (Object)((Object)option)), (!okSource.wasStreamOpened() || okSource.wasStreamClosed() ? 1 : 0) != 0);
        }
    }

    public void testClosesOnErrors_whenReadThrows() {
        TestCharSource failSource = new TestCharSource(STRING, TestOption.READ_THROWS);
        try {
            failSource.copyTo(new TestCharSink(new TestOption[0]));
            CharSourceTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CharSourceTest.assertTrue((boolean)failSource.wasStreamClosed());
    }

    public void testClosesOnErrors_copyingToWriterThatThrows() {
        TestCharSource okSource = new TestCharSource(STRING, new TestOption[0]);
        try {
            okSource.copyTo(new TestWriter(TestOption.WRITE_THROWS));
            CharSourceTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CharSourceTest.assertTrue((boolean)okSource.wasStreamClosed());
    }

    public void testConcat() throws IOException {
        CharSource c1 = CharSource.wrap((CharSequence)"abc");
        CharSource c2 = CharSource.wrap((CharSequence)"");
        CharSource c3 = CharSource.wrap((CharSequence)"de");
        String expected = "abcde";
        CharSourceTest.assertEquals((String)expected, (String)CharSource.concat((Iterable)ImmutableList.of((Object)c1, (Object)c2, (Object)c3)).read());
        CharSourceTest.assertEquals((String)expected, (String)CharSource.concat((CharSource[])new CharSource[]{c1, c2, c3}).read());
        CharSourceTest.assertEquals((String)expected, (String)CharSource.concat((Iterator)ImmutableList.of((Object)c1, (Object)c2, (Object)c3).iterator()).read());
        CharSourceTest.assertFalse((boolean)CharSource.concat((CharSource[])new CharSource[]{c1, c2, c3}).isEmpty());
        CharSource emptyConcat = CharSource.concat((CharSource[])new CharSource[]{CharSource.empty(), CharSource.empty()});
        CharSourceTest.assertTrue((boolean)emptyConcat.isEmpty());
    }

    public void testConcat_infiniteIterable() throws IOException {
        CharSource source = CharSource.wrap((CharSequence)"abcd");
        Iterable cycle = Iterables.cycle((Iterable)ImmutableList.of((Object)source));
        CharSource concatenated = CharSource.concat((Iterable)cycle);
        String expected = "abcdabcd";
        StringBuilder builder = new StringBuilder();
        Reader reader = concatenated.openStream();
        for (int i = 0; i < 8; ++i) {
            builder.append((char)reader.read());
        }
        CharSourceTest.assertEquals((String)expected, (String)builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyExceptions() {
        if (!Closer.SuppressingSuppressor.isAvailable()) {
            TestLogHandler logHandler = new TestLogHandler();
            Closeables.logger.addHandler((Handler)logHandler);
            try {
                for (CharSource in : BROKEN_SOURCES) {
                    CharSourceTest.runFailureTest(in, CharSourceTest.newNormalCharSink());
                    CharSourceTest.assertTrue((boolean)logHandler.getStoredLogRecords().isEmpty());
                    CharSourceTest.runFailureTest(in, BROKEN_CLOSE_SINK);
                    CharSourceTest.assertEquals((int)(in == BROKEN_OPEN_SOURCE ? 0 : 1), (int)CharSourceTest.getAndResetRecords(logHandler));
                }
                for (CharSink out : BROKEN_SINKS) {
                    CharSourceTest.runFailureTest(CharSourceTest.newNormalCharSource(), out);
                    CharSourceTest.assertTrue((boolean)logHandler.getStoredLogRecords().isEmpty());
                    CharSourceTest.runFailureTest(BROKEN_CLOSE_SOURCE, out);
                    CharSourceTest.assertEquals((int)1, (int)CharSourceTest.getAndResetRecords(logHandler));
                }
                for (CharSource in : BROKEN_SOURCES) {
                    for (CharSink out : BROKEN_SINKS) {
                        CharSourceTest.runFailureTest(in, out);
                        CharSourceTest.assertTrue((CharSourceTest.getAndResetRecords(logHandler) <= 1 ? 1 : 0) != 0);
                    }
                }
            }
            finally {
                Closeables.logger.removeHandler((Handler)logHandler);
            }
        } else {
            int suppressed;
            for (CharSource in : BROKEN_SOURCES) {
                suppressed = CharSourceTest.runSuppressionFailureTest(in, CharSourceTest.newNormalCharSink());
                CharSourceTest.assertEquals((int)0, (int)suppressed);
                suppressed = CharSourceTest.runSuppressionFailureTest(in, BROKEN_CLOSE_SINK);
                CharSourceTest.assertEquals((int)(in == BROKEN_OPEN_SOURCE ? 0 : 1), (int)suppressed);
            }
            for (CharSink out : BROKEN_SINKS) {
                suppressed = CharSourceTest.runSuppressionFailureTest(CharSourceTest.newNormalCharSource(), out);
                CharSourceTest.assertEquals((int)0, (int)suppressed);
                suppressed = CharSourceTest.runSuppressionFailureTest(BROKEN_CLOSE_SOURCE, out);
                CharSourceTest.assertEquals((int)1, (int)suppressed);
            }
            for (CharSource in : BROKEN_SOURCES) {
                for (CharSink out : BROKEN_SINKS) {
                    int suppressed2 = CharSourceTest.runSuppressionFailureTest(in, out);
                    CharSourceTest.assertTrue((suppressed2 <= 1 ? 1 : 0) != 0);
                }
            }
        }
    }

    private static int getAndResetRecords(TestLogHandler logHandler) {
        int records = logHandler.getStoredLogRecords().size();
        logHandler.clear();
        return records;
    }

    private static void runFailureTest(CharSource in, CharSink out) {
        try {
            in.copyTo(out);
            CharSourceTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int runSuppressionFailureTest(CharSource in, CharSink out) {
        try {
            in.copyTo(out);
            CharSourceTest.fail();
        }
        catch (IOException expected) {
            return CloserTest.getSuppressed(expected).length;
        }
        throw new AssertionError();
    }

    private static CharSource newNormalCharSource() {
        return CharSource.wrap((CharSequence)"ABC");
    }

    private static CharSink newNormalCharSink() {
        return new CharSink(){

            public Writer openStream() {
                return new StringWriter();
            }
        };
    }
}

