/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.Closeables;
import com.google.common.io.TestInputStream;
import com.google.common.io.TestOption;
import com.google.common.io.TestReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class CloseablesTest
extends TestCase {
    private Closeable mockCloseable;

    public void testClose_closeableClean() throws IOException {
        this.setupCloseable(false);
        this.doClose(this.mockCloseable, false, false);
        this.setupCloseable(false);
        this.doClose(this.mockCloseable, true, false);
    }

    public void testClose_closeableWithEatenException() throws IOException {
        this.setupCloseable(true);
        this.doClose(this.mockCloseable, true);
    }

    public void testClose_closeableWithThrownException() throws IOException {
        this.setupCloseable(true);
        this.doClose(this.mockCloseable, false);
    }

    public void testCloseQuietly_inputStreamWithEatenException() throws IOException {
        TestInputStream in = new TestInputStream((InputStream)new ByteArrayInputStream(new byte[1]), TestOption.CLOSE_THROWS);
        Closeables.closeQuietly((InputStream)in);
        CloseablesTest.assertTrue((boolean)in.closed());
    }

    public void testCloseQuietly_readerWithEatenException() throws IOException {
        TestReader in = new TestReader(TestOption.CLOSE_THROWS);
        Closeables.closeQuietly((Reader)in);
        CloseablesTest.assertTrue((boolean)in.closed());
    }

    public void testCloseNull() throws IOException {
        Closeables.close(null, (boolean)true);
        Closeables.close(null, (boolean)false);
    }

    public void testCloseQuietlyNull_inputStream() {
        Closeables.closeQuietly((InputStream)null);
    }

    public void testCloseQuietlyNull_reader() {
        Closeables.closeQuietly((Reader)null);
    }

    private void setupCloseable(boolean shouldThrow) throws IOException {
        this.mockCloseable = (Closeable)Mockito.mock(Closeable.class);
        if (shouldThrow) {
            ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("This should only appear in the logs. It should not be rethrown.")}).when((Object)this.mockCloseable)).close();
        }
    }

    private void doClose(Closeable closeable, boolean swallowException) throws IOException {
        this.doClose(closeable, swallowException, !swallowException);
    }

    private void doClose(Closeable closeable, boolean swallowException, boolean expectThrown) throws IOException {
        block3: {
            try {
                Closeables.close((Closeable)closeable, (boolean)swallowException);
                if (expectThrown) {
                    CloseablesTest.fail((String)"Didn't throw exception.");
                }
            }
            catch (IOException e) {
                if (expectThrown) break block3;
                CloseablesTest.fail((String)"Threw exception");
            }
        }
        ((Closeable)Mockito.verify((Object)closeable)).close();
    }
}

